/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;

public class CacheEventQueue
implements ICacheEventQueue {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$CacheEventQueue == null ? (class$org$apache$jcs$engine$CacheEventQueue = CacheEventQueue.class$("org.apache.jcs.engine.CacheEventQueue")) : class$org$apache$jcs$engine$CacheEventQueue));
    private static int processorInstanceCount = 0;
    private ICacheListener listener;
    private byte listenerId;
    private String cacheName;
    private int failureCount;
    private int maxFailure;
    private int waitBeforeRetry;
    private boolean destroyed;
    private Thread t;
    private Object queueLock = new Object();
    private Node head;
    private Node tail = this.head = new Node();
    static /* synthetic */ Class class$org$apache$jcs$engine$CacheEventQueue;

    public CacheEventQueue(ICacheListener listener, byte listenerId, String cacheName) {
        this(listener, listenerId, cacheName, 10, 500);
    }

    public CacheEventQueue(ICacheListener listener, byte listenerId, String cacheName, int maxFailure, int waitBeforeRetry) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listener = listener;
        this.listenerId = listenerId;
        this.cacheName = cacheName;
        this.maxFailure = maxFailure <= 0 ? 10 : maxFailure;
        this.waitBeforeRetry = waitBeforeRetry <= 0 ? 500 : waitBeforeRetry;
        this.t = new QProcessor();
        this.t.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed: " + this));
        }
    }

    public synchronized void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            Object object = this.queueLock;
            synchronized (object) {
                this.t.interrupt();
            }
            this.t = null;
            log.info((Object)("Cache event queue destroyed: " + this));
        }
    }

    public String toString() {
        return "listenerId=" + this.listenerId + ", cacheName=" + this.cacheName;
    }

    public boolean isAlive() {
        return !this.destroyed;
    }

    public byte getListenerId() {
        return this.listenerId;
    }

    public synchronized void addPutEvent(ICacheElement ce) throws IOException {
        if (!this.destroyed) {
            this.put(new PutEvent(ce));
        }
    }

    public void addRemoveEvent(Serializable key) throws IOException {
        if (!this.destroyed) {
            this.put(new RemoveEvent(key));
        }
    }

    public synchronized void addRemoveAllEvent() throws IOException {
        if (!this.destroyed) {
            this.put(new RemoveAllEvent());
        }
    }

    public synchronized void addDisposeEvent() throws IOException {
        if (!this.destroyed) {
            this.put(new DisposeEvent());
        }
    }

    private void put(AbstractCacheEvent event) {
        Node newNode = new Node();
        newNode.event = event;
        Object object = this.queueLock;
        synchronized (object) {
            this.tail.next = newNode;
            this.tail = newNode;
            this.queueLock.notify();
        }
    }

    private AbstractCacheEvent take() throws InterruptedException {
        Object object = this.queueLock;
        synchronized (object) {
            while (this.head == this.tail) {
                this.queueLock.wait();
            }
            Node node = this.head.next;
            AbstractCacheEvent value = node.event;
            if (log.isDebugEnabled()) {
                log.debug((Object)("head.event = " + this.head.event));
                log.debug((Object)("node.event = " + node.event));
            }
            node.event = null;
            this.head = node;
            AbstractCacheEvent abstractCacheEvent = value;
            return abstractCacheEvent;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DisposeEvent
    extends AbstractCacheEvent {
        private DisposeEvent() {
        }

        protected void doRun() throws IOException {
            CacheEventQueue.this.listener.handleDispose(CacheEventQueue.this.cacheName);
        }
    }

    private class RemoveAllEvent
    extends AbstractCacheEvent {
        private RemoveAllEvent() {
        }

        protected void doRun() throws IOException {
            CacheEventQueue.this.listener.handleRemoveAll(CacheEventQueue.this.cacheName);
        }
    }

    private class RemoveEvent
    extends AbstractCacheEvent {
        private Serializable key;

        RemoveEvent(Serializable key) throws IOException {
            this.key = key;
        }

        protected void doRun() throws IOException {
            CacheEventQueue.this.listener.handleRemove(CacheEventQueue.this.cacheName, this.key);
        }
    }

    private class PutEvent
    extends AbstractCacheEvent {
        private ICacheElement ice;

        PutEvent(ICacheElement ice) throws IOException {
            this.ice = ice;
        }

        protected void doRun() throws IOException {
            CacheEventQueue.this.listener.handlePut(this.ice);
        }
    }

    private abstract class AbstractCacheEvent
    implements Runnable {
        private AbstractCacheEvent() {
        }

        public void run() {
            IOException ex = null;
            while (!CacheEventQueue.this.destroyed && CacheEventQueue.this.failureCount <= CacheEventQueue.this.maxFailure) {
                try {
                    ex = null;
                    this.doRun();
                    CacheEventQueue.this.failureCount = 0;
                    return;
                }
                catch (IOException e) {
                    CacheEventQueue.this.failureCount++;
                    ex = e;
                    if (CacheEventQueue.this.destroyed || CacheEventQueue.this.failureCount > CacheEventQueue.this.maxFailure) continue;
                    try {
                        log.warn((Object)("...retrying propagation " + CacheEventQueue.this + "..." + CacheEventQueue.this.failureCount));
                        Thread.currentThread();
                        Thread.sleep(CacheEventQueue.this.waitBeforeRetry);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (ex != null) {
                log.warn((Object)("Giving up propagation " + CacheEventQueue.this), ex);
                CacheEventQueue.this.destroy();
            }
        }

        protected abstract void doRun() throws IOException;
    }

    private class QProcessor
    extends Thread {
        QProcessor() {
            super("CacheEventQueue.QProcessor-" + ++processorInstanceCount);
            this.setDaemon(true);
        }

        public void run() {
            AbstractCacheEvent r = null;
            while (!CacheEventQueue.this.destroyed) {
                try {
                    r = CacheEventQueue.this.take();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("r from take() = " + r));
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (CacheEventQueue.this.destroyed || r == null) continue;
                r.run();
            }
            CacheEventQueue.this.listener = null;
            log.info((Object)("QProcessor exiting for " + CacheEventQueue.this));
        }
    }

    private static class Node {
        Node next = null;
        AbstractCacheEvent event = null;

        private Node() {
        }
    }
}

