/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.xslt;

import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.xslt.XSLTService;
import org.w3c.dom.Node;

public class TurbineXSLTService
extends BaseService
implements XSLTService {
    protected boolean caching = false;
    protected String path;
    protected Hashtable cache = new Hashtable();
    protected static final String STYLESHEET_PATH = "path";
    protected static final String STYLESHEET_CACHING = "cache";
    private static TransformerFactory tfactory;

    public void init() throws InitializationException {
        if (this.isInitialized()) {
            return;
        }
        this.path = this.getRealPath(this.getConfiguration().getString(STYLESHEET_PATH));
        if (!this.path.endsWith("/") && !this.path.endsWith("\\")) {
            this.path = this.path + File.separator;
        }
        this.caching = this.getConfiguration().getBoolean(STYLESHEET_CACHING);
        tfactory = TransformerFactory.newInstance();
        this.setInit(true);
    }

    protected String getFileName(String templateName) {
        File f;
        int colon = templateName.lastIndexOf(".");
        if (colon > 0) {
            templateName = templateName.substring(0, colon);
        }
        if ((f = new File(this.path + templateName + ".xsl")).exists()) {
            return this.path + templateName + ".xsl";
        }
        f = new File(this.path + "default.xsl");
        if (f.exists()) {
            return this.path + "default.xsl";
        }
        return null;
    }

    protected Templates compileTemplates(String source) throws Exception {
        StreamSource xslin = new StreamSource(new File(source));
        Templates root = tfactory.newTemplates(xslin);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Templates getTemplates(String xslName) throws Exception {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            String fn;
            block7: {
                block6: {
                    fn = this.getFileName(xslName);
                    if (fn != null) break block6;
                    Templates templates = null;
                    return templates;
                }
                if (!this.caching || !this.cache.containsKey(fn)) break block7;
                Templates templates = (Templates)this.cache.get(fn);
                return templates;
            }
            Templates sr = this.compileTemplates(fn);
            if (this.caching) {
                this.cache.put(fn, sr);
            }
            Templates templates = sr;
            return templates;
        }
    }

    protected void transform(String xslName, Source xmlin, Result xmlout) throws Exception {
        Transformer transformer = this.getTransformer(xslName);
        transformer.transform(xmlin, xmlout);
    }

    public void transform(String xslName, Reader in, Writer out) throws Exception {
        StreamSource xmlin = new StreamSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout);
    }

    public String transform(String xslName, Reader in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }

    public void transform(String xslName, Node in, Writer out) throws Exception {
        DOMSource xmlin = new DOMSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout);
    }

    public String transform(String xslName, Node in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }

    public Transformer getTransformer(String xslName) throws Exception {
        Templates sr = this.getTemplates(xslName);
        if (sr == null) {
            return tfactory.newTransformer();
        }
        return sr.newTransformer();
    }

    static {
        STYLESHEET_PATH = STYLESHEET_PATH;
        STYLESHEET_CACHING = STYLESHEET_CACHING;
    }
}

