/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.template;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.template.DefaultTemplateContext;
import org.apache.fulcrum.template.TemplateContext;
import org.apache.fulcrum.template.TemplateEngineService;
import org.apache.fulcrum.template.TemplateService;

public class TurbineTemplateService
extends BaseService
implements TemplateService {
    protected static final String NO_FILE_EXT = "";
    private String defaultExtension;
    private HashMap templateEngineRegistry;

    public void init() throws InitializationException {
        this.setInit(true);
    }

    public String[] translateTemplatePaths(String[] templatePaths) {
        int i = 0;
        while (i < templatePaths.length) {
            templatePaths[i] = this.getRealPath(templatePaths[i]);
            ++i;
        }
        return templatePaths;
    }

    public boolean templateExists(String template, String[] templatePaths) {
        int i = 0;
        while (i < templatePaths.length) {
            if (new File(templatePaths[i], template).exists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean templateExists(String template) {
        TemplateEngineService tes = this.getTemplateEngineService(template);
        if (tes != null) {
            return tes.templateExists(template);
        }
        return false;
    }

    public synchronized void registerTemplateEngineService(TemplateEngineService service) {
        HashMap registry = this.templateEngineRegistry != null ? (HashMap)this.templateEngineRegistry.clone() : new HashMap();
        String[] exts = service.getAssociatedFileExtensions();
        int i = 0;
        while (i < exts.length) {
            registry.put(exts[i], service);
            ++i;
        }
        this.templateEngineRegistry = registry;
    }

    protected TemplateEngineService getTemplateEngineService(String template) {
        HashMap registry = this.templateEngineRegistry;
        if (registry != null && template != null) {
            int dotIndex = template.lastIndexOf(46);
            String ext = dotIndex == -1 ? this.defaultExtension : template.substring(dotIndex + 1);
            return (TemplateEngineService)registry.get(ext);
        }
        return null;
    }

    public String handleRequest(TemplateContext context, String template) throws ServiceException {
        TemplateEngineService tes = this.getTemplateEngineService(template);
        return tes.handleRequest(context, template);
    }

    public void handleRequest(TemplateContext context, String template, OutputStream outputStream) throws ServiceException {
        TemplateEngineService tes = this.getTemplateEngineService(template);
        tes.handleRequest(context, template, outputStream);
    }

    public void handleRequest(TemplateContext context, String template, Writer writer) throws ServiceException {
        TemplateEngineService tes = this.getTemplateEngineService(template);
        tes.handleRequest(context, template, writer);
    }

    public TemplateContext getTemplateContext() {
        return new DefaultTemplateContext();
    }

    static {
        NO_FILE_EXT = NO_FILE_EXT;
    }
}

