/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.template;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.SimpleEmail;
import org.apache.commons.util.WordWrapper;
import org.apache.fulcrum.template.TemplateContext;
import org.apache.fulcrum.template.TurbineTemplate;

public class TemplateEmail {
    private String toName = null;
    private String toEmail = null;
    private String fromName = null;
    private String fromEmail = null;
    private String ccName = null;
    private String ccEmail = null;
    private String subject = null;
    private List toList = null;
    private List ccList = null;
    private List replyToList = null;
    private int wordWrap = 0;
    private String template = null;
    private TemplateContext context = null;
    private String charset = null;
    private List headersList;

    public TemplateEmail() {
        this(null);
    }

    public TemplateEmail(TemplateContext context) {
        this.context = context;
    }

    public void addTo(String email, String name) throws Exception {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            if (this.toList == null) {
                this.toList = new ArrayList();
            }
            this.toList.add(new InternetAddress(email, name));
        }
        catch (Exception e) {
            throw new Exception("Cannot add 'To' recipient: " + e);
        }
    }

    public void addCc(String email, String name) throws Exception {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            if (this.ccList == null) {
                this.ccList = new ArrayList();
            }
            this.ccList.add(new InternetAddress(email, name));
        }
        catch (Exception e) {
            throw new Exception("Cannot add 'CC' recipient: " + e);
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public TemplateEmail setTo(String to, String email) {
        this.toName = to;
        this.toEmail = email;
        return this;
    }

    public TemplateEmail setFrom(String from, String email) {
        this.fromName = from;
        this.fromEmail = email;
        return this;
    }

    public TemplateEmail setCC(String cc, String email) {
        this.ccName = cc;
        this.ccEmail = email;
        return this;
    }

    public TemplateEmail addReplyTo(String name, String email) {
        String[] emailName = new String[]{email, name};
        if (this.replyToList == null) {
            this.replyToList = new ArrayList(3);
        }
        this.replyToList.add(emailName);
        return this;
    }

    public TemplateEmail addHeader(String name, String value) {
        String[] pair = new String[]{name, value};
        if (this.headersList == null) {
            this.headersList = new ArrayList(3);
        }
        this.headersList.add(pair);
        return this;
    }

    public TemplateEmail setSubject(String subject) {
        this.subject = subject == null ? "" : subject;
        return this;
    }

    public TemplateEmail setTemplate(String template) {
        this.template = template;
        return this;
    }

    public TemplateEmail setWordWrap(int wordWrap) {
        this.wordWrap = wordWrap;
        return this;
    }

    public TemplateEmail setContext(TemplateContext context) {
        this.context = context;
        return this;
    }

    public TemplateContext getContext() {
        return this.context;
    }

    public void send() throws Exception {
        if (this.toEmail == null || this.toName == null) {
            throw new Exception("Must set a To:");
        }
        this.toList = null;
        this.addTo(this.toEmail, this.toName);
        this.sendMultiple();
    }

    public void sendMultiple() throws Exception {
        if (this.toList == null || this.toList.isEmpty()) {
            throw new Exception("Must set a To:");
        }
        StringWriter sw = new StringWriter();
        TurbineTemplate.handleRequest(this.context, this.template, sw);
        String body = sw.toString();
        if (this.wordWrap > 0) {
            body = WordWrapper.wrapText((String)body, (String)System.getProperty("line.separator"), (int)this.wordWrap);
        }
        SimpleEmail se = new SimpleEmail();
        se.setFrom(this.fromEmail, this.fromName);
        se.setTo((Collection)this.toList);
        if (this.ccList != null && !this.ccList.isEmpty()) {
            se.setCc((Collection)this.ccList);
        }
        this.addReplyTo(se);
        if (this.charset != null) {
            se.setCharset(this.charset);
        }
        se.setSubject(this.subject);
        se.setMsg(body);
        if (this.headersList != null) {
            Iterator i = this.headersList.iterator();
            while (i.hasNext()) {
                String[] pair = (String[])i.next();
                se.addHeader(pair[0], pair[1]);
            }
        }
        se.send();
    }

    private void addReplyTo(SimpleEmail se) throws Exception {
        if (this.replyToList != null) {
            Iterator i = this.replyToList.iterator();
            while (i.hasNext()) {
                String[] emailName = (String[])i.next();
                se.addReplyTo(emailName[0], emailName[1]);
            }
        }
    }

    public String toString() {
        try {
            this.send();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

