/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.util.Iterator;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineRole;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.TurbineSecurityException;

public class TurbineRole
extends BaseTurbineRole
implements Role,
Comparable {
    private PermissionSet permissionSet = null;

    public TurbineRole() {
    }

    public TurbineRole(String name) {
        this.setName(name);
    }

    public PermissionSet getPermissions() throws Exception {
        return this.permissionSet;
    }

    public void setPermissions(PermissionSet permissionSet) {
        this.permissionSet = permissionSet;
    }

    public Role create(String name) throws TurbineSecurityException {
        TurbineRole role = new TurbineRole(name);
        TurbineSecurity.addRole(role);
        return role;
    }

    public void save() throws TurbineSecurityException {
        TurbineSecurity.saveRole(this);
    }

    public void remove() throws TurbineSecurityException {
        TurbineSecurity.removeRole(this);
    }

    public void rename(String name) throws TurbineSecurityException {
        TurbineSecurity.renameRole(this, name);
    }

    public void grant(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.grant(this, permission);
    }

    public void grant(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator permissions = permissionSet.elements();
        while (permissions.hasNext()) {
            TurbineSecurity.grant(this, (Permission)permissions.next());
        }
    }

    public void revoke(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.revoke(this, permission);
    }

    public void revoke(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator permissions = permissionSet.elements();
        while (permissions.hasNext()) {
            TurbineSecurity.revoke(this, (Permission)permissions.next());
        }
    }

    public int compareTo(Object obj) {
        if (this.getClass() != obj.getClass()) {
            throw new ClassCastException();
        }
        String name1 = ((SecurityEntity)obj).getName();
        String name2 = this.getName();
        return name2.compareTo(name1);
    }
}

