/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.entity.TurbineUser;
import org.apache.fulcrum.security.impl.db.entity.TurbineUserPeer;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.util.Criteria;

public class DBUserManager
implements UserManager {
    private static final boolean DEBUG = false;

    public boolean accountExists(User user) throws DataBackendException {
        return this.accountExists(user.getUserName());
    }

    public boolean accountExists(String username) throws DataBackendException {
        List users;
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserPeer.USERNAME, (Object)username);
        try {
            users = TurbineUserPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to check account's presence", e);
        }
        if (users.size() > 1) {
            throw new DataBackendException("Multiple Users with same username '" + username + "'");
        }
        return users.size() == 1;
    }

    public User retrieve(String username) throws UnknownEntityException, DataBackendException {
        List users;
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserPeer.USERNAME, (Object)username);
        try {
            users = TurbineUserPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to retrieve user '" + username + "'", e);
        }
        if (users.size() > 1) {
            throw new DataBackendException("Multiple Users with same username '" + username + "'");
        }
        if (users.size() == 1) {
            return (User)users.get(0);
        }
        throw new UnknownEntityException("Unknown user '" + username + "'");
    }

    public User[] retrieve(Criteria criteria) throws DataBackendException {
        Iterator keys = criteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Criteria.Criterion[] criterion = criteria.getCriterion(key).getAttachedCriterion();
            int i = 0;
            while (i < criterion.length) {
                String table = criterion[i].getTable();
                if (table == null || "".equals(table)) {
                    criterion[i].setTable(TurbineUserPeer.getTableName());
                }
                ++i;
            }
        }
        List users = new ArrayList(0);
        try {
            users = TurbineUserPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to retrieve users", e);
        }
        return users.toArray(new User[0]);
    }

    public User retrieve(String username, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        User user = this.retrieve(username);
        this.authenticate(user, password);
        return user;
    }

    public void store(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        try {
            ((TurbineUser)user).setNew(false);
            ((TurbineUser)user).setModified(true);
            ((TurbineUser)user).save();
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to save user object", e);
        }
    }

    public void authenticate(User user, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        String encrypted = TurbineSecurity.encryptPassword(password);
        if (!user.getPassword().equals(encrypted)) {
            throw new PasswordMismatchException("The passwords do not match");
        }
    }

    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        String encrypted = TurbineSecurity.encryptPassword(oldPassword);
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        if (!user.getPassword().equals(encrypted)) {
            throw new PasswordMismatchException("The supplied old password for '" + user.getUserName() + "' was incorrect");
        }
        user.setPassword(TurbineSecurity.encryptPassword(newPassword));
        this.store(user);
    }

    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        user.setPassword(TurbineSecurity.encryptPassword(password));
        this.store(user);
    }

    public void createAccount(User user, String initialPassword) throws EntityExistsException, DataBackendException {
        if (this.accountExists(user)) {
            throw new EntityExistsException("The account '" + user.getUserName() + "' already exists");
        }
        String encrypted = TurbineSecurity.encryptPassword(initialPassword);
        user.setPassword(encrypted);
        try {
            ((TurbineUser)user).setNew(true);
            ((TurbineUser)user).setModified(true);
            ((TurbineUser)user).save();
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to create account '" + user.getUserName() + "'", e);
        }
    }

    public void removeAccount(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserPeer.USERNAME, (Object)user.getUserName());
        try {
            TurbineUserPeer.doDelete(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to remove account '" + user.getUserName() + "'", e);
        }
    }

    static {
        DEBUG = false;
    }
}

