/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.fulcrum.security.BaseSecurityService;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.entity.TurbineGroup;
import org.apache.fulcrum.security.impl.db.entity.TurbineGroupPeer;
import org.apache.fulcrum.security.impl.db.entity.TurbinePermission;
import org.apache.fulcrum.security.impl.db.entity.TurbinePermissionPeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineRole;
import org.apache.fulcrum.security.impl.db.entity.TurbineRolePeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineRolePermissionPeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineUserGroupRolePeer;
import org.apache.fulcrum.security.impl.db.entity.UserPeer;
import org.apache.fulcrum.security.util.AccessControlList;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.log4j.Category;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.util.Criteria;

public class DBSecurityService
extends BaseSecurityService {
    public static final String USER_PEER_CLASS_KEY = "userPeer.class";
    public static final String USER_PEER_CLASS_DEFAULT = "org.apache.fulcrum.security.impl.db.entity.TurbineUserPeer";
    Category category = Category.getInstance((String)this.getClass().getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessControlList getACL(User user) throws DataBackendException, UnknownEntityException {
        AccessControlList accessControlList;
        if (!TurbineSecurity.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        try {
            try {
                Hashtable<Group, RoleSet> roles = new Hashtable<Group, RoleSet>();
                Hashtable<Group, PermissionSet> permissions = new Hashtable<Group, PermissionSet>();
                this.lockShared();
                Iterator groupsIterator = this.getAllGroups().elements();
                block4: while (true) {
                    if (!groupsIterator.hasNext()) {
                        accessControlList = this.getAclInstance(roles, permissions);
                        Object var12_12 = null;
                        break;
                    }
                    Group group = (Group)groupsIterator.next();
                    RoleSet groupRoles = TurbineRolePeer.retrieveSet(user, group);
                    roles.put(group, groupRoles);
                    PermissionSet groupPermissions = new PermissionSet();
                    Iterator rolesIterator = groupRoles.elements();
                    while (true) {
                        if (!rolesIterator.hasNext()) {
                            permissions.put(group, groupPermissions);
                            continue block4;
                        }
                        Role role = (Role)rolesIterator.next();
                        PermissionSet rolePermissions = TurbinePermissionPeer.retrieveSet(role);
                        groupPermissions.add(rolePermissions);
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new DataBackendException("Failed to build ACL for user '" + user.getUserName() + "'", e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.unlockShared();
            throw throwable;
        }
        this.unlockShared();
        return accessControlList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void grant(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists;
        boolean groupExists;
        boolean userExists;
        block7: {
            userExists = false;
            groupExists = false;
            roleExists = false;
            try {
                try {
                    this.lockExclusive();
                    userExists = TurbineSecurity.accountExists(user);
                    groupExists = this.checkExists(group);
                    roleExists = this.checkExists(role);
                    if (!userExists || !groupExists || !roleExists) break block7;
                    Criteria criteria = new Criteria();
                    criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)((BaseObject)user).getPrimaryKey());
                    criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)((BaseObject)group).getPrimaryKey());
                    criteria.add(TurbineUserGroupRolePeer.ROLE_ID, (Object)((TurbineRole)role).getPrimaryKey());
                    TurbineUserGroupRolePeer.doInsert(criteria);
                    Object var9_9 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("grant(User,Group,Role) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var9_10 = null;
        this.unlockExclusive();
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getUserName() + "'");
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void revoke(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists;
        boolean groupExists;
        boolean userExists;
        block7: {
            userExists = false;
            groupExists = false;
            roleExists = false;
            try {
                try {
                    this.lockExclusive();
                    userExists = TurbineSecurity.accountExists(user);
                    groupExists = this.checkExists(group);
                    roleExists = this.checkExists(role);
                    if (!userExists || !groupExists || !roleExists) break block7;
                    Criteria criteria = new Criteria();
                    criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)((BaseObject)user).getPrimaryKey());
                    criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)((BaseObject)group).getPrimaryKey());
                    criteria.add(TurbineUserGroupRolePeer.ROLE_ID, (Object)((TurbineRole)role).getPrimaryKey());
                    TurbineUserGroupRolePeer.doDelete(criteria);
                    Object var9_9 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("revoke(User,Role,Group) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var9_10 = null;
        this.unlockExclusive();
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getUserName() + "'");
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        block5: {
            boolean userExists = false;
            try {
                try {
                    this.lockExclusive();
                    userExists = TurbineSecurity.accountExists(user);
                    if (!userExists) break block5;
                    ObjectKey key = ((BaseObject)user).getPrimaryKey();
                    TurbineUserGroupRolePeer.deleteAll((String)"TURBINE_USER_GROUP_ROLE", (String)TurbineUserGroupRolePeer.USER_ID, (int)((BigDecimal)key.getValue()).intValue());
                    Object var5_5 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("revokeAll(User) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var5_6 = null;
        this.unlockExclusive();
        throw new UnknownEntityException("Unknown user '" + user.getUserName() + '\'');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists;
        boolean roleExists;
        block6: {
            roleExists = false;
            permissionExists = false;
            try {
                try {
                    this.lockExclusive();
                    roleExists = this.checkExists(role);
                    permissionExists = this.checkExists(permission);
                    if (!roleExists || !permissionExists) break block6;
                    Criteria criteria = new Criteria();
                    criteria.add(TurbineRolePermissionPeer.ROLE_ID, (Object)((TurbineRole)role).getPrimaryKey());
                    criteria.add(TurbineRolePermissionPeer.PERMISSION_ID, (Object)((BaseObject)permission).getPrimaryKey());
                    TurbineUserGroupRolePeer.doInsert(criteria);
                    Object var7_7 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("grant(Role,Permission) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var7_8 = null;
        this.unlockExclusive();
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists;
        boolean roleExists;
        block6: {
            roleExists = false;
            permissionExists = false;
            try {
                try {
                    this.lockExclusive();
                    roleExists = this.checkExists(role);
                    permissionExists = this.checkExists(permission);
                    if (!roleExists || !permissionExists) break block6;
                    Criteria criteria = new Criteria();
                    criteria.add(TurbineRolePermissionPeer.ROLE_ID, (Object)((TurbineRole)role).getPrimaryKey());
                    criteria.add(TurbineRolePermissionPeer.PERMISSION_ID, (Object)((BaseObject)permission).getPrimaryKey());
                    TurbineRolePermissionPeer.doDelete(criteria);
                    Object var7_7 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("revoke(Role,Permission) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var7_8 = null;
        this.unlockExclusive();
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        block5: {
            boolean roleExists = false;
            try {
                try {
                    this.lockExclusive();
                    roleExists = this.checkExists(role);
                    if (!roleExists) break block5;
                    ObjectKey key = ((TurbineRole)role).getPrimaryKey();
                    TurbineRolePermissionPeer.deleteAll((String)"TURBINE_ROLE_PERMISSION", (String)TurbineRolePermissionPeer.ROLE_ID, (int)((BigDecimal)key.getValue()).intValue());
                    Object var5_5 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("revokeAll(Role) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var5_6 = null;
        this.unlockExclusive();
        throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
    }

    public GroupSet getGroups(Criteria criteria) throws DataBackendException {
        Criteria dbCriteria = new Criteria();
        Iterator keys = criteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            dbCriteria.put((Object)TurbineGroupPeer.getColumnName(key), criteria.get((Object)key));
        }
        List groups = new ArrayList(0);
        try {
            groups = TurbineGroupPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("getGroups(Criteria) failed", e);
        }
        return new GroupSet(groups);
    }

    public RoleSet getRoles(Criteria criteria) throws DataBackendException {
        Criteria dbCriteria = new Criteria();
        Iterator keys = criteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            dbCriteria.put((Object)TurbineRolePeer.getColumnName(key), criteria.get((Object)key));
        }
        List roles = new ArrayList(0);
        try {
            roles = TurbineRolePeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("getRoles(Criteria) failed", e);
        }
        return new RoleSet(roles);
    }

    public PermissionSet getPermissions(Criteria criteria) throws DataBackendException {
        Criteria dbCriteria = new Criteria();
        Iterator keys = criteria.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            dbCriteria.put((Object)TurbinePermissionPeer.getColumnName(key), criteria.get((Object)key));
        }
        List permissions = new ArrayList(0);
        try {
            permissions = TurbinePermissionPeer.doSelect(criteria);
        }
        catch (Exception e) {
            throw new DataBackendException("getPermissions(Criteria) failed", e);
        }
        return new PermissionSet(permissions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PermissionSet getPermissions(Role role) throws DataBackendException, UnknownEntityException {
        block5: {
            PermissionSet permissionSet;
            boolean roleExists = false;
            try {
                try {
                    this.lockShared();
                    roleExists = this.checkExists(role);
                    if (!roleExists) break block5;
                    permissionSet = TurbinePermissionPeer.retrieveSet(role);
                    Object var5_5 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("getPermissions(Role) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.unlockShared();
                throw throwable;
            }
            this.unlockShared();
            return permissionSet;
        }
        Object var5_6 = null;
        this.unlockShared();
        throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
    }

    public void saveGroup(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            groupExists = this.checkExists(group);
            if (groupExists) {
                Criteria criteria = TurbineGroupPeer.buildCriteria((TurbineGroup)group);
                TurbineGroupPeer.doUpdate(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("saveGroup(Group) failed", e);
        }
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    public void saveRole(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            roleExists = this.checkExists(role);
            if (roleExists) {
                Criteria criteria = TurbineRolePeer.buildCriteria((TurbineRole)role);
                TurbineRolePeer.doUpdate(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("saveRole(Role) failed", e);
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    public void savePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            permissionExists = this.checkExists(permission);
            if (permissionExists) {
                Criteria criteria = TurbinePermissionPeer.buildCriteria((TurbinePermission)permission);
                TurbinePermissionPeer.doUpdate(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("savePermission(Permission) failed", e);
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    public Group getNewGroup(String groupName) {
        try {
            return this.getGroupInstance(groupName);
        }
        catch (UnknownEntityException uee) {
            return null;
        }
    }

    public Role getNewRole(String roleName) {
        try {
            return this.getRoleInstance(roleName);
        }
        catch (UnknownEntityException uee) {
            return null;
        }
    }

    public Permission getNewPermission(String permissionName) {
        try {
            return this.getPermissionInstance(permissionName);
        }
        catch (UnknownEntityException uee) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Group addGroup(Group group) throws DataBackendException, EntityExistsException {
        block6: {
            Group group2;
            boolean groupExists = false;
            try {
                try {
                    this.lockExclusive();
                    groupExists = this.checkExists(group);
                    if (groupExists) break block6;
                    Criteria criteria = TurbineGroupPeer.buildCriteria((TurbineGroup)group);
                    TurbineGroupPeer.doInsert(criteria);
                    criteria = new Criteria();
                    criteria.add(TurbineGroupPeer.NAME, (Object)group.getName());
                    List results = TurbineGroupPeer.doSelect(criteria);
                    if (results.size() != 1) {
                        throw new DataBackendException("Internal error - query returned " + results.size() + " rows");
                    }
                    Group newGroup = (Group)results.get(0);
                    this.getAllGroups().add(newGroup);
                    group2 = newGroup;
                    Object var8_8 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("addGroup(Group) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return group2;
        }
        Object var8_9 = null;
        this.unlockExclusive();
        throw new EntityExistsException("Group '" + group + "' already exists");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Role addRole(Role role) throws DataBackendException, EntityExistsException {
        block6: {
            Role role2;
            boolean roleExists = false;
            try {
                try {
                    this.lockExclusive();
                    roleExists = this.checkExists(role);
                    if (roleExists) break block6;
                    Criteria criteria = TurbineRolePeer.buildCriteria((TurbineRole)role);
                    TurbineRolePeer.doInsert(criteria);
                    criteria = new Criteria();
                    criteria.add(TurbineRolePeer.NAME, (Object)role.getName());
                    List results = TurbineRolePeer.doSelect(criteria);
                    if (results.size() != 1) {
                        throw new DataBackendException("Internal error - query returned " + results.size() + " rows");
                    }
                    Role newRole = (Role)results.get(0);
                    this.getAllRoles().add(newRole);
                    role2 = newRole;
                    Object var8_8 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("addRole(Role) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return role2;
        }
        Object var8_9 = null;
        this.unlockExclusive();
        throw new EntityExistsException("Role '" + role + "' already exists");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Permission addPermission(Permission permission) throws DataBackendException, EntityExistsException {
        block6: {
            Permission permission2;
            boolean permissionExists = false;
            try {
                try {
                    this.lockExclusive();
                    permissionExists = this.checkExists(permission);
                    if (permissionExists) break block6;
                    Criteria criteria = TurbinePermissionPeer.buildCriteria((TurbinePermission)permission);
                    TurbinePermissionPeer.doInsert(criteria);
                    criteria = new Criteria();
                    criteria.add(TurbinePermissionPeer.NAME, (Object)permission.getName());
                    List results = TurbinePermissionPeer.doSelect(criteria);
                    if (results.size() != 1) {
                        throw new DataBackendException("Internal error - query returned " + results.size() + " rows");
                    }
                    Permission newPermission = (Permission)results.get(0);
                    this.getAllPermissions().add(newPermission);
                    permission2 = newPermission;
                    Object var8_8 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("addPermission(Permission) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return permission2;
        }
        Object var8_9 = null;
        this.unlockExclusive();
        throw new EntityExistsException("Permission '" + permission + "' already exists");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        block5: {
            boolean groupExists = false;
            try {
                try {
                    this.lockExclusive();
                    groupExists = this.checkExists(group);
                    if (!groupExists) break block5;
                    Criteria criteria = TurbineGroupPeer.buildCriteria((TurbineGroup)group);
                    TurbineGroupPeer.doDelete(criteria);
                    this.getAllGroups().remove(group);
                    Object var5_5 = null;
                }
                catch (Exception e) {
                    this.category.error((Object)"Failed to delete a Group");
                    this.category.error((Object)e);
                    throw new DataBackendException("removeGroup(Group) failed", e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var5_6 = null;
        this.unlockExclusive();
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        block5: {
            boolean roleExists = false;
            try {
                try {
                    this.lockExclusive();
                    roleExists = this.checkExists(role);
                    if (!roleExists) break block5;
                    this.revokeAll(role);
                    Criteria criteria = TurbineRolePeer.buildCriteria((TurbineRole)role);
                    TurbineRolePeer.doDelete(criteria);
                    this.getAllRoles().remove(role);
                    Object var5_5 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("removeRole(Role)", e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var5_6 = null;
        this.unlockExclusive();
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        block5: {
            boolean permissionExists = false;
            try {
                try {
                    this.lockExclusive();
                    permissionExists = this.checkExists(permission);
                    if (!permissionExists) break block5;
                    Criteria criteria = TurbinePermissionPeer.buildCriteria((TurbinePermission)permission);
                    TurbinePermissionPeer.doDelete(criteria);
                    this.getAllPermissions().remove(permission);
                    Object var5_5 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("removePermission(Permission)", e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var5_6 = null;
        this.unlockExclusive();
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void renameGroup(Group group, String name) throws DataBackendException, UnknownEntityException {
        block5: {
            boolean groupExists = false;
            try {
                try {
                    this.lockExclusive();
                    groupExists = this.checkExists(group);
                    if (!groupExists) break block5;
                    group.setName(name);
                    Criteria criteria = TurbineGroupPeer.buildCriteria((TurbineGroup)group);
                    TurbineGroupPeer.doUpdate(criteria);
                    Object var6_6 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("renameGroup(Group,String)", e);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var6_7 = null;
        this.unlockExclusive();
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void renameRole(Role role, String name) throws DataBackendException, UnknownEntityException {
        block5: {
            boolean roleExists = false;
            try {
                try {
                    this.lockExclusive();
                    roleExists = this.checkExists(role);
                    if (!roleExists) break block5;
                    role.setName(name);
                    Criteria criteria = TurbineRolePeer.buildCriteria((TurbineRole)role);
                    TurbineRolePeer.doUpdate(criteria);
                    Object var6_6 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("renameRole(Role,String)", e);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var6_7 = null;
        this.unlockExclusive();
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void renamePermission(Permission permission, String name) throws DataBackendException, UnknownEntityException {
        block5: {
            boolean permissionExists = false;
            try {
                try {
                    this.lockExclusive();
                    permissionExists = this.checkExists(permission);
                    if (!permissionExists) break block5;
                    permission.setName(name);
                    Criteria criteria = TurbinePermissionPeer.buildCriteria((TurbinePermission)permission);
                    TurbinePermissionPeer.doUpdate(criteria);
                    Object var6_6 = null;
                }
                catch (Exception e) {
                    throw new DataBackendException("renamePermission(Permission,name)", e);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.unlockExclusive();
                throw throwable;
            }
            this.unlockExclusive();
            return;
        }
        Object var6_7 = null;
        this.unlockExclusive();
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    public Class getUserPeerClass() throws UnknownEntityException {
        String userPeerClassName = this.getConfiguration().getString(USER_PEER_CLASS_KEY, USER_PEER_CLASS_DEFAULT);
        try {
            return Class.forName(userPeerClassName);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed create a Class object for UserPeer implementation", e);
        }
    }

    public UserPeer getUserPeerInstance() throws UnknownEntityException {
        UserPeer up;
        try {
            up = (UserPeer)this.getUserPeerClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed instantiate an UserPeer implementation object", e);
        }
        return up;
    }

    protected boolean checkExists(Group group) throws DataBackendException, Exception {
        return TurbineGroupPeer.checkExists(group);
    }

    protected boolean checkExists(Role role) throws DataBackendException, Exception {
        return TurbineRolePeer.checkExists(role);
    }

    protected boolean checkExists(Permission permission) throws DataBackendException, Exception {
        return TurbinePermissionPeer.checkExists(permission);
    }

    static {
        USER_PEER_CLASS_KEY = USER_PEER_CLASS_KEY;
        USER_PEER_CLASS_DEFAULT = USER_PEER_CLASS_DEFAULT;
    }
}

