/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security;

import java.security.MessageDigest;
import java.util.Map;
import org.apache.commons.codec.base64.Base64;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.TurbineServices;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.util.AccessControlList;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.util.Criteria;

public abstract class BaseSecurityService
extends BaseService
implements SecurityService {
    private GroupSet allGroups = null;
    private RoleSet allRoles = null;
    private PermissionSet allPermissions = null;
    private int readerCount = 0;
    protected UserManager userManager = null;
    private Class userClass = null;
    private Class groupClass = null;
    private Class permissionClass = null;
    private Class roleClass = null;
    private Class aclClass = null;
    private FactoryService aclFactoryService = null;
    private static Group globalGroup = null;
    static /* synthetic */ Class class$org$apache$fulcrum$security$BaseSecurityService;

    public String encryptPassword(String password) {
        if (password == null) {
            return null;
        }
        String secure = this.getConfiguration().getString("secure.passwords", "false").toLowerCase();
        String algorithm = this.getConfiguration().getString("secure.passwords.algorithm", "SHA");
        if (secure.equals("true") || secure.equals("yes")) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                byte[] digest = md.digest(password.getBytes("UTF-8"));
                byte[] encodedDigest = Base64.encode((byte[])digest);
                return encodedDigest == null ? null : new String(encodedDigest);
            }
            catch (Exception e) {
                this.getCategory().error((Object)"Unable to encrypt password");
                this.getCategory().error((Object)e);
                return null;
            }
        }
        return password;
    }

    public void init() throws InitializationException {
        String userManagerClassName;
        block10: {
            userManagerClassName = this.getConfiguration().getString("user.manager", "org.apache.fulcrum.security.impl.db.DBUserManager");
            String userClassName = this.getConfiguration().getString("user.class", "org.apache.fulcrum.security.impl.db.entity.TurbineUser");
            String groupClassName = this.getConfiguration().getString("group.class", "org.apache.fulcrum.security.impl.db.entity.TurbineGroup");
            String permissionClassName = this.getConfiguration().getString("permission.class", "org.apache.fulcrum.security.impl.db.entity.TurbinePermission");
            String roleClassName = this.getConfiguration().getString("role.class", "org.apache.fulcrum.security.impl.db.entity.TurbineRole");
            String aclClassName = this.getConfiguration().getString("acl.class", "org.apache.fulcrum.security.impl.TurbineAccessControlList");
            try {
                this.userClass = Class.forName(userClassName);
                this.groupClass = Class.forName(groupClassName);
                this.permissionClass = Class.forName(permissionClassName);
                this.roleClass = Class.forName(roleClassName);
                this.aclClass = Class.forName(aclClassName);
            }
            catch (Exception e) {
                if (this.userClass == null) {
                    throw new InitializationException("Failed to create a Class object for User implementation", e);
                }
                if (this.groupClass == null) {
                    throw new InitializationException("Failed to create a Class object for Group implementation", e);
                }
                if (this.permissionClass == null) {
                    throw new InitializationException("Failed to create a Class object for Permission implementation", e);
                }
                if (this.roleClass == null) {
                    throw new InitializationException("Failed to create a Class object for Role implementation", e);
                }
                if (this.aclClass != null) break block10;
                throw new InitializationException("Failed to create a Class object for ACL implementation", e);
            }
        }
        try {
            this.userManager = (UserManager)Class.forName(userManagerClassName).newInstance();
        }
        catch (Exception e) {
            throw new InitializationException("BaseSecurityService.init: Failed to instantiate UserManager", e);
        }
        try {
            this.aclFactoryService = (FactoryService)TurbineServices.getInstance().getService("FactoryService");
        }
        catch (Exception e) {
            throw new InitializationException("BaseSecurityService.init: Failed to get the Factory Service object", e);
        }
        this.setInit(true);
    }

    public Class getUserClass() throws UnknownEntityException {
        if (this.userClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for User implementation");
        }
        return this.userClass;
    }

    public User getUserInstance() throws UnknownEntityException {
        User user;
        try {
            user = (User)this.getUserClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed instantiate an User implementation object", e);
        }
        return user;
    }

    public User getUserInstance(String userName) throws UnknownEntityException {
        User user = this.getUserInstance();
        user.setName(userName);
        return user;
    }

    public Class getGroupClass() throws UnknownEntityException {
        if (this.groupClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for Group implementation");
        }
        return this.groupClass;
    }

    public Group getGroupInstance() throws UnknownEntityException {
        Group group;
        try {
            group = (Group)this.getGroupClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed instantiate an Group implementation object", e);
        }
        return group;
    }

    public Group getGroupInstance(String groupName) throws UnknownEntityException {
        Group group = this.getGroupInstance();
        group.setName(groupName);
        return group;
    }

    public Class getPermissionClass() throws UnknownEntityException {
        if (this.permissionClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for Permission implementation");
        }
        return this.permissionClass;
    }

    public Permission getPermissionInstance() throws UnknownEntityException {
        Permission permission;
        try {
            permission = (Permission)this.getPermissionClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed instantiate an Permission implementation object", e);
        }
        return permission;
    }

    public Permission getPermissionInstance(String permName) throws UnknownEntityException {
        Permission perm = this.getPermissionInstance();
        perm.setName(permName);
        return perm;
    }

    public Class getRoleClass() throws UnknownEntityException {
        if (this.roleClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for Role implementation");
        }
        return this.roleClass;
    }

    public Role getRoleInstance() throws UnknownEntityException {
        Role role;
        try {
            role = (Role)this.getRoleClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed instantiate an Role implementation object", e);
        }
        return role;
    }

    public Role getRoleInstance(String roleName) throws UnknownEntityException {
        Role role = this.getRoleInstance();
        role.setName(roleName);
        return role;
    }

    public Class getAclClass() throws UnknownEntityException {
        if (this.aclClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for ACL implementation");
        }
        return this.aclClass;
    }

    public AccessControlList getAclInstance(Map roles, Map permissions) throws UnknownEntityException {
        AccessControlList accessControlList;
        Object[] objects = new Object[]{roles, permissions};
        String[] signatures = new String[]{"java.util.Map", "java.util.Map"};
        try {
            accessControlList = (AccessControlList)this.aclFactoryService.getInstance(this.aclClass.getName(), objects, signatures);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed instantiate an ACL implementation object", e);
        }
        return accessControlList;
    }

    public boolean accountExists(User user) throws DataBackendException {
        return this.userManager.accountExists(user);
    }

    public boolean accountExists(String userName) throws DataBackendException {
        return this.userManager.accountExists(userName);
    }

    public User getAuthenticatedUser(String username, String password) throws DataBackendException, UnknownEntityException, PasswordMismatchException {
        return this.userManager.retrieve(username, password);
    }

    public User getUser(String username) throws DataBackendException, UnknownEntityException {
        return this.userManager.retrieve(username);
    }

    public User[] getUsers(Criteria criteria) throws DataBackendException {
        return this.userManager.retrieve(criteria);
    }

    public User getAnonymousUser() throws UnknownEntityException {
        User user = this.getUserInstance();
        user.setUserName("");
        return user;
    }

    public void saveUser(User user) throws UnknownEntityException, DataBackendException {
        this.userManager.store(user);
    }

    public void addUser(User user, String password) throws DataBackendException, EntityExistsException {
        this.userManager.createAccount(user, password);
    }

    public void removeUser(User user) throws DataBackendException, UnknownEntityException {
        this.revokeAll(user);
        this.userManager.removeAccount(user);
    }

    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        this.userManager.changePassword(user, oldPassword, newPassword);
    }

    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        this.userManager.forcePassword(user, password);
    }

    protected synchronized void lockShared() {
        ++this.readerCount;
    }

    protected synchronized void unlockShared() {
        --this.readerCount;
        this.notify();
    }

    protected void lockExclusive() {
        while (this.readerCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void unlockExclusive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGlobalGroup() {
        if (globalGroup == null) {
            Class clazz = class$org$apache$fulcrum$security$BaseSecurityService == null ? (class$org$apache$fulcrum$security$BaseSecurityService = BaseSecurityService.class$("org.apache.fulcrum.security.BaseSecurityService")) : class$org$apache$fulcrum$security$BaseSecurityService;
            synchronized (clazz) {
                if (globalGroup == null) {
                    try {
                        globalGroup = this.getAllGroups().getGroup("global");
                    }
                    catch (DataBackendException e) {
                        this.getCategory().error((Object)"Failed to retrieve global group object");
                        this.getCategory().error((Object)e);
                    }
                }
            }
        }
        return globalGroup;
    }

    public Group getGroup(String name) throws DataBackendException, UnknownEntityException {
        GroupSet groups = this.getAllGroups();
        Group group = groups.getGroup(name);
        if (group != null) {
            return group;
        }
        throw new UnknownEntityException("The specified group does not exist");
    }

    public Role getRole(String name) throws DataBackendException, UnknownEntityException {
        RoleSet roles = this.getAllRoles();
        Role role = roles.getRole(name);
        if (role != null) {
            role.setPermissions(this.getPermissions(role));
            return role;
        }
        throw new UnknownEntityException("The specified role does not exist");
    }

    public Permission getPermission(String name) throws DataBackendException, UnknownEntityException {
        PermissionSet permissions = this.getAllPermissions();
        Permission permission = permissions.getPermission(name);
        if (permission != null) {
            return permission;
        }
        throw new UnknownEntityException("The specified permission does not exist");
    }

    public GroupSet getAllGroups() throws DataBackendException {
        return this.getGroups(new Criteria());
    }

    public RoleSet getAllRoles() throws DataBackendException {
        return this.getRoles(new Criteria());
    }

    public PermissionSet getAllPermissions() throws DataBackendException {
        return this.getPermissions(new Criteria());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

