/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.xmlmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;
import org.xml.sax.Attributes;

public class AppData
implements Serializable {
    private List inputs = new ArrayList();
    private String basePackage;

    public void loadFromXML(Attributes attrib) {
        String basePkg = attrib.getValue("basePackage");
        if (basePkg == null) {
            this.setBasePackage("");
        } else if (basePkg.charAt(basePkg.length() - 1) != '.') {
            this.setBasePackage(basePkg + '.');
        } else {
            this.setBasePackage(basePkg);
        }
    }

    public List getGroups() {
        return this.inputs;
    }

    public XmlGroup getGroup(String groupName) throws Exception {
        if (groupName == null) {
            throw new Exception("Intake AppData.getGroup(groupName) is null");
        }
        XmlGroup group = null;
        Iterator iter = this.inputs.iterator();
        while (!(group = (XmlGroup)iter.next()).getName().equals(groupName)) {
        }
        return group;
    }

    public XmlGroup addGroup(Attributes attrib) {
        XmlGroup input = new XmlGroup();
        input.loadFromXML(attrib);
        this.addGroup(input);
        return input;
    }

    public void addGroup(XmlGroup input) {
        input.setAppData(this);
        this.inputs.add(input);
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String v) {
        this.basePackage = v;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<input-data>\n");
        Iterator iter = this.inputs.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
        }
        result.append("</input-data>");
        return result.toString();
    }
}

