/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.GlobalCacheService;
import org.apache.fulcrum.cache.ObjectExpiredException;
import org.apache.fulcrum.cache.RefreshableCachedObject;

public class TurbineGlobalCacheService
extends BaseService
implements GlobalCacheService,
Runnable {
    protected Hashtable cache = null;
    private static final long DEFAULT_CACHE_CHECK_FREQUENCY = 5000L;
    private long cacheCheckFrequency;

    public void init() throws InitializationException {
        this.cacheCheckFrequency = this.getConfiguration().getLong("cacheCheckFrequency", 5000L);
        try {
            this.cache = new Hashtable(20);
            Thread housekeeping = new Thread(this);
            housekeeping.setDaemon(true);
            housekeeping.start();
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("TurbineGlobalCacheService failed to initialize", e);
        }
    }

    public CachedObject getObject(String id) throws ObjectExpiredException {
        CachedObject obj = null;
        boolean stale = false;
        obj = (CachedObject)this.cache.get(id);
        if (obj == null) {
            throw new ObjectExpiredException();
        }
        if (obj.isStale()) {
            throw new ObjectExpiredException();
        }
        if (obj instanceof RefreshableCachedObject) {
            RefreshableCachedObject rco = (RefreshableCachedObject)obj;
            rco.touch();
        }
        return obj;
    }

    public void addObject(String id, CachedObject o) {
        if (this.cache.containsKey(id)) {
            this.cache.remove(id);
        }
        this.cache.put(id, o);
    }

    public void removeObject(String id) {
        this.cache.remove(id);
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.cacheCheckFrequency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        RefreshableCachedObject rco;
        CachedObject co;
        String key;
        Enumeration<Object> e;
        Vector<String> refreshThese = new Vector<String>(20);
        TurbineGlobalCacheService turbineGlobalCacheService = this;
        synchronized (turbineGlobalCacheService) {
            e = this.cache.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                co = (CachedObject)this.cache.get(key);
                if (co instanceof RefreshableCachedObject) {
                    rco = (RefreshableCachedObject)co;
                    if (rco.isUntouched()) {
                        this.cache.remove(key);
                        continue;
                    }
                    if (!rco.isStale()) continue;
                    refreshThese.addElement(key);
                    continue;
                }
                if (!co.isStale()) continue;
                this.cache.remove(key);
            }
        }
        e = refreshThese.elements();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            co = (CachedObject)this.cache.get(key);
            rco = (RefreshableCachedObject)co;
            rco.refresh();
        }
    }

    public int getNumberOfObjects() {
        return this.cache.size();
    }

    public int getCacheSize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(this.cache);
        out.flush();
        int objectsize = baos.toByteArray().length - 4;
        return objectsize;
    }

    static {
        DEFAULT_CACHE_CHECK_FREQUENCY = 5000L;
    }
}

