/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.bsf;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.bsf.BSFService;

public class TurbineBSFService
extends BaseService
implements BSFService {
    protected BSFManager manager;
    protected String scriptsDirectory;
    protected static final String SCRIPTS_DIRECTORY = "scriptsDirectory";
    protected String defaultExtension;
    protected static final String DEFAULT_EXTENSION = "defaultExtension";

    public void init() throws InitializationException {
        this.scriptsDirectory = this.getConfiguration().getString(SCRIPTS_DIRECTORY);
        if (this.scriptsDirectory == null) {
            throw new InitializationException("You must provide a scripts directory in order to executes scripts!");
        }
        this.defaultExtension = this.getConfiguration().getString(DEFAULT_EXTENSION);
        this.initBSFManagers();
        this.setInit(true);
    }

    private void initBSFManagers() {
        this.manager = new BSFManager();
    }

    public void execute(String script) {
        if (script.lastIndexOf(46) == -1) {
            script = script + '.' + this.defaultExtension;
        }
        script = this.getRealPath(this.scriptsDirectory + "/" + script);
        this.getCategory().debug((Object)("[BSFService] Script to execute: " + script));
        try {
            this.manager.exec(BSFManager.getLangFromFilename((String)script), script, 0, 0, (Object)this.fileContentsToString(script));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (BSFException bsfe) {
            int reason = bsfe.getReason();
            bsfe.printStackTrace();
        }
    }

    protected String fileContentsToString(String file) throws IOException {
        StringWriter sw = new StringWriter();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf, 0, 1024)) != -1) {
            sw.write(buf, 0, len);
        }
        return sw.toString();
    }

    static {
        SCRIPTS_DIRECTORY = SCRIPTS_DIRECTORY;
        DEFAULT_EXTENSION = DEFAULT_EXTENSION;
    }
}

