/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.InstantiationException;
import org.apache.fulcrum.Service;
import org.apache.fulcrum.ServiceBroker;
import org.apache.fulcrum.ServiceException;
import org.apache.log4j.Category;
import org.apache.log4j.helpers.NullEnumeration;

public abstract class BaseServiceBroker
implements ServiceBroker {
    protected Configuration mapping = new BaseConfiguration();
    protected Hashtable services = new Hashtable();
    protected Configuration configuration;
    public static final String SERVICE_PREFIX = "services.";
    public static final String CLASSNAME_SUFFIX = ".classname";
    protected boolean loggingConfigured;
    protected Hashtable serviceObjects = new Hashtable();
    protected Category category = Category.getInstance((String)this.getClass().getName());
    protected String applicationRoot;

    protected BaseServiceBroker() {
    }

    protected boolean isLoggingConfigured() {
        Enumeration enumeration = Category.getRoot().getAllAppenders();
        if (!(enumeration instanceof NullEnumeration)) {
            return true;
        }
        Enumeration cats = Category.getCurrentCategories();
        while (cats.hasMoreElements()) {
            Category c = (Category)cats.nextElement();
            if (c.getAllAppenders() instanceof NullEnumeration) continue;
            return true;
        }
        return false;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Category getCategory() {
        return this.category;
    }

    public void init() throws InitializationException {
        this.loggingConfigured = this.isLoggingConfigured();
        this.initMapping();
        this.initServices(false);
    }

    public void setServiceObject(String name, Object value) {
        this.serviceObjects.put(name, value);
    }

    public Object getServiceObject(String name) {
        return this.serviceObjects.get(name);
    }

    protected void initMapping() {
        Iterator keys = this.configuration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] keyParts = StringUtils.split((String)key, (String)".");
            if (keyParts.length != 3 || !(keyParts[0] + ".").equals(SERVICE_PREFIX) || !("." + keyParts[2]).equals(CLASSNAME_SUFFIX)) continue;
            String serviceKey = keyParts[1];
            this.notice("Added Mapping for Service: " + serviceKey);
            if (this.mapping.containsKey(serviceKey)) continue;
            this.mapping.setProperty(serviceKey, (Object)this.configuration.getString(key));
        }
    }

    public boolean isRegistered(String serviceName) {
        return this.services.get(serviceName) != null;
    }

    public Iterator getServiceNames() {
        return this.mapping.getKeys();
    }

    public Iterator getServiceNames(String prefix) {
        return this.mapping.getKeys(prefix);
    }

    public synchronized void initService(String name) throws InitializationException {
        Service instance = this.getServiceInstance(name);
        if (!instance.isInitialized()) {
            instance.init();
        }
    }

    public void initServices() {
        try {
            this.initServices(false);
        }
        catch (InstantiationException notThrown) {
        }
        catch (InitializationException initializationException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    public void initServices(boolean report) throws InstantiationException, InitializationException {
        block5: {
            names = this.getServiceNames();
            if (!report) ** GOTO lbl15
            while (names.hasNext()) {
                this.doInitService((String)names.next());
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                try {
                    this.doInitService((String)names.next());
                    continue;
                }
                catch (InstantiationException e) {
                    this.error((Throwable)e);
                    continue;
                }
                catch (InitializationException e) {
                    this.error((Throwable)e);
                }
lbl15:
                // 4 sources

                ** while (names.hasNext())
            }
        }
        this.notice("Finished initializing all services!");
    }

    private void doInitService(String name) throws InstantiationException, InitializationException {
        if (this.getConfiguration(name).getBoolean("earlyInit", false)) {
            this.notice("Start Initializing service (early): " + name);
            this.initService(name);
            this.notice("Finish Initializing service (early): " + name);
        }
    }

    public synchronized void shutdownService(String name) {
        try {
            Service service = this.getServiceInstance(name);
            if (service != null && service.isInitialized()) {
                service.shutdown();
                if (service.isInitialized() && service instanceof BaseService) {
                    ((BaseService)service).setInit(false);
                }
            }
        }
        catch (InstantiationException e) {
            this.error((Throwable)((Object)new ServiceException("Shutdown of a nonexistent Service '" + name + "' was requested", (Throwable)((Object)e))));
        }
    }

    public void shutdownServices() {
        this.notice("Shutting down all services!");
        Iterator serviceNames = this.getServiceNames();
        String serviceName = null;
        ArrayList<String> reverseServicesList = new ArrayList<String>();
        while (serviceNames.hasNext()) {
            serviceName = (String)serviceNames.next();
            reverseServicesList.add(0, serviceName);
        }
        serviceNames = reverseServicesList.iterator();
        while (serviceNames.hasNext()) {
            serviceName = (String)serviceNames.next();
            this.notice("Shutting down service: " + serviceName);
            this.shutdownService(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getService(String name) throws InstantiationException {
        try {
            Service service = this.getServiceInstance(name);
            if (!service.isInitialized()) {
                Class<?> clazz = service.getClass();
                synchronized (clazz) {
                    if (!service.isInitialized()) {
                        this.notice("Start Initializing service (late): " + name);
                        service.init();
                        this.notice("Finish Initializing service (late): " + name);
                    }
                }
            }
            if (!service.isInitialized()) {
                throw new InitializationException("init() failed to initialize service " + name);
            }
            return service;
        }
        catch (InitializationException e) {
            throw new InstantiationException("Service " + name + " failed to initialize", (Throwable)((Object)e));
        }
    }

    protected Service getServiceInstance(String name) throws InstantiationException {
        Service service = (Service)this.services.get(name);
        if (service == null) {
            block9: {
                String className = this.mapping.getString(name);
                if (className == null || className.length() == 0) {
                    throw new InstantiationException("ServiceBroker: Unknown Service '" + name + "' requested");
                }
                try {
                    service = (Service)this.services.get(className);
                    if (service != null) break block9;
                    try {
                        service = (Service)Class.forName(className).newInstance();
                    }
                    catch (ThreadDeath t) {
                        throw t;
                    }
                    catch (OutOfMemoryError t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        String msg = null;
                        msg = t instanceof NoClassDefFoundError ? "A class referenced by " + className + " is unavailable. Check your jars and classes." : (t instanceof ClassNotFoundException ? "Class " + className + " is unavailable. Check your jars and classes." : (t instanceof ClassCastException ? "Class " + className + " doesn't implement the Service interface" : "Failed to instantiate " + className));
                        throw new InstantiationException(msg, t);
                    }
                }
                catch (ClassCastException e) {
                    throw new InstantiationException("ServiceBroker: Class " + className + " does not implement Service interface.", e);
                }
                catch (InstantiationException e) {
                    throw new InstantiationException("Failed to instantiate service " + name, (Throwable)((Object)e));
                }
            }
            service.setServiceBroker(this);
            service.setName(name);
            this.services.put(name, service);
        }
        return service;
    }

    public Configuration getConfiguration(String name) {
        return this.configuration.subset(SERVICE_PREFIX + name);
    }

    public void notice(String msg) {
        if (this.loggingConfigured) {
            this.category.info((Object)msg);
        } else {
            System.out.println("NOTICE: " + msg);
        }
    }

    public void error(Throwable t) {
        if (this.loggingConfigured) {
            this.category.info((Object)t);
            this.category.info((Object)this.stackTrace(t));
        } else {
            System.out.println("ERROR: " + t.getMessage());
            t.printStackTrace();
        }
    }

    public String stackTrace(Throwable e) {
        String trace = null;
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(buf, true));
            trace = buf.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trace;
    }

    public void setApplicationRoot(String applicationRoot) {
        this.applicationRoot = applicationRoot;
    }

    public String getApplicationRoot() {
        return this.applicationRoot;
    }

    public String getRealPath(String path) {
        return new File(this.getApplicationRoot(), path).getAbsolutePath();
    }

    static {
        SERVICE_PREFIX = SERVICE_PREFIX;
        CLASSNAME_SUFFIX = CLASSNAME_SUFFIX;
    }
}

