/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsql.Access;
import org.hsql.Channel;
import org.hsql.Column;
import org.hsql.Constraint;
import org.hsql.DatabaseInformation;
import org.hsql.Library;
import org.hsql.Log;
import org.hsql.Parser;
import org.hsql.Result;
import org.hsql.Table;
import org.hsql.Tokenizer;
import org.hsql.Trace;
import org.hsql.User;

class Database {
    private String sName;
    private Access aAccess;
    private Vector tTable;
    private DatabaseInformation dInfo;
    private Log lLog;
    private boolean bReadOnly;
    private boolean bShutdown;
    private Hashtable hAlias;
    private boolean bIgnoreCase;
    private boolean bReferentialIntegrity;
    private Vector cChannel;

    String getName() {
        return this.sName;
    }

    boolean isShutdown() {
        return this.bShutdown;
    }

    synchronized Channel connect(String string, String string2) throws SQLException {
        int n;
        User user = this.aAccess.getUser(string.toUpperCase(), string2.toUpperCase());
        int n2 = n = this.cChannel.size();
        int n3 = 0;
        while (n3 < n) {
            if (this.cChannel.elementAt(n3) == null) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        Channel channel = new Channel(this, user, true, this.bReadOnly, n2);
        if (this.lLog != null) {
            this.lLog.write(channel, "CONNECT USER " + string + " PASSWORD \"" + string2 + "\"");
        }
        this.registerChannel(channel);
        return channel;
    }

    void registerChannel(Channel channel) {
        int n = this.cChannel.size();
        int n2 = channel.getId();
        if (n2 >= n) {
            this.cChannel.setSize(n2 + 1);
        }
        this.cChannel.setElementAt(channel, n2);
    }

    byte[] execute(String string, String string2, String string3) {
        Result result = null;
        try {
            Channel channel = this.connect(string, string2);
            result = this.execute(string3, channel);
            this.execute("DISCONNECT", channel);
        }
        catch (Exception exception) {
            result = new Result(exception.getMessage());
        }
        try {
            return result.getBytes();
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    synchronized Result execute(String string, Channel channel) {
        Tokenizer tokenizer = new Tokenizer(string);
        Parser parser = new Parser(this, tokenizer, channel);
        Result result = new Result();
        try {
            if (this.lLog != null && this.lLog.cCache != null) {
                this.lLog.cCache.cleanUp();
            }
            Trace.check(channel != null, 31);
            Trace.check(!this.bShutdown, 3);
            while (true) {
                int n = tokenizer.getPosition();
                boolean bl = false;
                String string2 = tokenizer.getString();
                if (!string2.equals("")) {
                    if (string2.equals("SELECT")) {
                        result = parser.processSelect();
                    } else if (string2.equals("INSERT")) {
                        result = parser.processInsert();
                    } else if (string2.equals("UPDATE")) {
                        result = parser.processUpdate();
                    } else if (string2.equals("DELETE")) {
                        result = parser.processDelete();
                    } else if (string2.equals("CREATE")) {
                        result = this.processCreate(tokenizer, channel);
                        bl = true;
                    } else if (string2.equals("DROP")) {
                        result = this.processDrop(tokenizer, channel);
                        bl = true;
                    } else if (string2.equals("GRANT")) {
                        result = this.processGrantOrRevoke(tokenizer, channel, true);
                        bl = true;
                    } else if (string2.equals("REVOKE")) {
                        result = this.processGrantOrRevoke(tokenizer, channel, false);
                        bl = true;
                    } else if (string2.equals("CONNECT")) {
                        result = this.processConnect(tokenizer, channel);
                    } else if (string2.equals("DISCONNECT")) {
                        result = this.processDisconnect(tokenizer, channel);
                        bl = true;
                    } else if (string2.equals("SET")) {
                        result = this.processSet(tokenizer, channel);
                        bl = true;
                    } else if (string2.equals("SCRIPT")) {
                        result = this.processScript(tokenizer, channel);
                    } else if (string2.equals("COMMIT")) {
                        result = this.processCommit(tokenizer, channel);
                        bl = true;
                    } else if (string2.equals("ROLLBACK")) {
                        result = this.processRollback(tokenizer, channel);
                        bl = true;
                    } else if (string2.equals("SHUTDOWN")) {
                        result = this.processShutdown(tokenizer, channel);
                    } else if (string2.equals("CHECKPOINT")) {
                        result = this.processCheckpoint(channel);
                    } else if (string2.equals("CALL")) {
                        result = parser.processCall();
                    } else if (!string2.equals(";")) {
                        throw Trace.error(10, string2);
                    }
                    if (!bl || this.lLog == null) continue;
                    int n2 = tokenizer.getPosition();
                    this.lLog.write(channel, tokenizer.getPart(n, n2));
                    continue;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            result = new Result(Trace.getMessage(sQLException) + " in statement [" + string + "]");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = Trace.getMessage(38) + " " + exception;
            result = new Result(string3 + " in statement [" + string + "]");
        }
        return result;
    }

    void setReadOnly() {
        this.bReadOnly = true;
    }

    Vector getTables() {
        return this.tTable;
    }

    void setReferentialIntegrity(boolean bl) {
        this.bReferentialIntegrity = bl;
    }

    boolean isReferentialIntegrity() {
        return this.bReferentialIntegrity;
    }

    Hashtable getAlias() {
        return this.hAlias;
    }

    String getAlias(String string) {
        Object v = this.hAlias.get(string);
        if (v == null) {
            return string;
        }
        return (String)v;
    }

    Log getLog() {
        return this.lLog;
    }

    Table getTable(String string, Channel channel) throws SQLException {
        Table table = null;
        int n = 0;
        while (n < this.tTable.size()) {
            table = (Table)this.tTable.elementAt(n);
            if (table.getName().equals(string)) {
                return table;
            }
            ++n;
        }
        table = this.dInfo.getSystemTable(string, channel);
        if (table == null) {
            throw Trace.error(21, string);
        }
        return table;
    }

    Result getScript(boolean bl, boolean bl2, boolean bl3, Channel channel) throws SQLException {
        return this.dInfo.getScript(bl, bl2, bl3, channel);
    }

    void linkTable(Table table) throws SQLException {
        String string = table.getName();
        int n = 0;
        while (n < this.tTable.size()) {
            Table table2 = (Table)this.tTable.elementAt(n);
            if (table2.getName().equals(string)) {
                throw Trace.error(20, string);
            }
            ++n;
        }
        this.tTable.addElement(table);
    }

    boolean isIgnoreCase() {
        return this.bIgnoreCase;
    }

    private Result processScript(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (tokenizer.wasValue()) {
            string = (String)tokenizer.getAsValue();
            Log.scriptToFile(this, string, true, channel);
            return new Result();
        }
        tokenizer.back();
        return this.getScript(true, true, false, channel);
    }

    private Result processCreate(Tokenizer tokenizer, Channel channel) throws SQLException {
        channel.checkReadWrite();
        channel.checkAdmin();
        String string = tokenizer.getString();
        if (string.equals("TABLE")) {
            this.processCreateTable(tokenizer, channel, false);
        } else if (string.equals("MEMORY")) {
            tokenizer.getThis("TABLE");
            this.processCreateTable(tokenizer, channel, false);
        } else if (string.equals("CACHED")) {
            tokenizer.getThis("TABLE");
            this.processCreateTable(tokenizer, channel, true);
        } else if (string.equals("USER")) {
            String string2 = tokenizer.getStringToken();
            tokenizer.getThis("PASSWORD");
            String string3 = tokenizer.getStringToken();
            boolean bl = tokenizer.getString().equals("ADMIN");
            this.aAccess.createUser(string2, string3, bl);
        } else if (string.equals("ALIAS")) {
            String string4 = tokenizer.getString();
            string = tokenizer.getString();
            Trace.check(string.equals("FOR"), 10, string);
            string = tokenizer.getString();
            this.hAlias.put(string4, string);
        } else {
            boolean bl = false;
            if (string.equals("UNIQUE")) {
                bl = true;
                string = tokenizer.getString();
            }
            if (!string.equals("INDEX")) {
                throw Trace.error(10, string);
            }
            String string5 = tokenizer.getName();
            tokenizer.getThis("ON");
            Table table = this.getTable(tokenizer.getString(), channel);
            this.addIndexOn(tokenizer, channel, string5, table, bl);
        }
        return new Result();
    }

    private int[] processColumnList(Tokenizer tokenizer, Table table) throws SQLException {
        Vector<String> vector;
        block2: {
            String string;
            vector = new Vector<String>();
            tokenizer.getThis("(");
            do {
                vector.addElement(tokenizer.getString());
                string = tokenizer.getString();
                if (string.equals(")")) break block2;
            } while (string.equals(","));
            throw Trace.error(10, string);
        }
        int n = vector.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = table.getColumnNr((String)vector.elementAt(n2));
            ++n2;
        }
        return nArray;
    }

    private void createIndex(Channel channel, Table table, int[] nArray, String string, boolean bl) throws SQLException {
        channel.commit();
        if (table.isEmpty()) {
            table.createIndex(nArray, string, bl);
        } else {
            Table table2 = table.moveDefinition(null);
            table2.createIndex(nArray, string, bl);
            table2.moveData(table);
            this.dropTable(table.getName());
            this.linkTable(table2);
        }
    }

    private void addForeignKeyOn(Tokenizer tokenizer, Channel channel, String string, Table table) throws SQLException {
        int[] nArray = this.processColumnList(tokenizer, table);
        tokenizer.getThis("REFERENCES");
        Table table2 = this.getTable(tokenizer.getString(), channel);
        int[] nArray2 = this.processColumnList(tokenizer, table2);
        if (table.getIndexForColumns(nArray) == null) {
            this.createIndex(channel, table, nArray, "SYSTEM_FOREIGN_KEY_" + string, false);
        }
        if (table2.getIndexForColumns(nArray2) == null) {
            this.createIndex(channel, table2, nArray2, "SYSTEM_REFERENCE_" + string, false);
        }
        table.addConstraint(new Constraint(0, table2, table, nArray2, nArray));
        table2.addConstraint(new Constraint(1, table2, table, nArray2, nArray));
    }

    private void addUniqueConstraintOn(Tokenizer tokenizer, Channel channel, String string, Table table) throws SQLException {
        int[] nArray = this.processColumnList(tokenizer, table);
        this.createIndex(channel, table, nArray, string, true);
        table.addConstraint(new Constraint(2, table, nArray));
    }

    private void addIndexOn(Tokenizer tokenizer, Channel channel, String string, Table table, boolean bl) throws SQLException {
        int[] nArray = this.processColumnList(tokenizer, table);
        this.createIndex(channel, table, nArray, string, bl);
    }

    private void processCreateTable(Tokenizer tokenizer, Channel channel, boolean bl) throws SQLException {
        Table table;
        block22: {
            String string;
            boolean bl2;
            String string2 = tokenizer.getName();
            table = bl && this.lLog != null ? new Table(this, true, string2, true) : new Table(this, true, string2, false);
            tokenizer.getThis("(");
            int n = -1;
            int n2 = 0;
            boolean bl3 = false;
            while (true) {
                bl2 = false;
                string2 = tokenizer.getString();
                if (string2.equals("CONSTRAINT") || string2.equals("PRIMARY") || string2.equals("FOREIGN") || string2.equals("UNIQUE")) {
                    tokenizer.back();
                    bl3 = true;
                    break;
                }
                string = string2;
                int n3 = Column.getTypeNr(tokenizer.getString());
                if (n3 == 12 && this.bIgnoreCase) {
                    n3 = 100;
                }
                string2 = tokenizer.getString();
                if (n3 == 8 && string2.equals("PRECISION")) {
                    string2 = tokenizer.getString();
                }
                if (string2.equals("(")) {
                    while (!(string2 = tokenizer.getString()).equals(")")) {
                    }
                    string2 = tokenizer.getString();
                }
                boolean bl4 = true;
                if (string2.equals("NULL")) {
                    string2 = tokenizer.getString();
                } else if (string2.equals("NOT")) {
                    tokenizer.getThis("NULL");
                    bl4 = false;
                    string2 = tokenizer.getString();
                }
                if (string2.equals("IDENTITY")) {
                    bl2 = true;
                    Trace.check(n == -1, 23, string);
                    string2 = tokenizer.getString();
                    n = n2;
                }
                if (string2.equals("PRIMARY")) {
                    tokenizer.getThis("KEY");
                    Trace.check(bl2 || n == -1, 23, string);
                    n = n2;
                    string2 = tokenizer.getString();
                }
                table.addColumn(string, n3, bl4, bl2);
                if (string2.equals(")")) break;
                if (!string2.equals(",")) {
                    throw Trace.error(10, string2);
                }
                ++n2;
            }
            if (n != -1) {
                table.createPrimaryKey(n);
            } else {
                table.createPrimaryKey();
            }
            if (bl3) {
                bl2 = false;
                do {
                    string2 = tokenizer.getString();
                    string = "SYSTEM_CONSTRAINT" + (int)(bl2 ? 1 : 0);
                    bl2 += 1;
                    if (string2.equals("CONSTRAINT")) {
                        string = tokenizer.getString();
                        string2 = tokenizer.getString();
                    }
                    if (string2.equals("PRIMARY")) {
                        tokenizer.getThis("KEY");
                        this.addUniqueConstraintOn(tokenizer, channel, string, table);
                    } else if (string2.equals("UNIQUE")) {
                        this.addUniqueConstraintOn(tokenizer, channel, string, table);
                    } else if (string2.equals("FOREIGN")) {
                        tokenizer.getThis("KEY");
                        this.addForeignKeyOn(tokenizer, channel, string, table);
                    }
                    string2 = tokenizer.getString();
                    if (string2.equals(")")) break block22;
                } while (string2.equals(","));
                throw Trace.error(10, string2);
            }
        }
        channel.commit();
        this.linkTable(table);
    }

    private Result processDrop(Tokenizer tokenizer, Channel channel) throws SQLException {
        channel.checkReadWrite();
        channel.checkAdmin();
        String string = tokenizer.getString();
        if (string.equals("TABLE")) {
            this.dropTable(tokenizer.getString());
            channel.commit();
        } else if (string.equals("USER")) {
            this.aAccess.dropUser(tokenizer.getStringToken());
        } else if (string.equals("INDEX")) {
            string = tokenizer.getString();
            if (!tokenizer.wasLongName()) {
                throw Trace.error(10, string);
            }
            String string2 = tokenizer.getLongNameFirst();
            String string3 = tokenizer.getLongNameLast();
            Table table = this.getTable(string2, channel);
            table.checkDropIndex(string3);
            Table table2 = table.moveDefinition(string3);
            table2.moveData(table);
            this.dropTable(string2);
            this.linkTable(table2);
            channel.commit();
        } else {
            throw Trace.error(10, string);
        }
        return new Result();
    }

    private Result processGrantOrRevoke(Tokenizer tokenizer, Channel channel, boolean bl) throws SQLException {
        String string;
        String string2;
        channel.checkReadWrite();
        channel.checkAdmin();
        int n = 0;
        do {
            string = tokenizer.getString();
            n |= Access.getRight(string);
        } while ((string2 = tokenizer.getString()).equals(","));
        if (!string2.equals("ON")) {
            throw Trace.error(10, string2);
        }
        string = tokenizer.getString();
        if (string.equals("CLASS")) {
            string = string + " \"" + tokenizer.getString() + "\"";
        } else {
            this.getTable(string, channel);
        }
        tokenizer.getThis("TO");
        String string3 = tokenizer.getStringToken();
        if (bl) {
            this.aAccess.grant(string3, string, n);
            String string4 = "GRANT";
        } else {
            this.aAccess.revoke(string3, string, n);
            String string5 = "REVOKE";
        }
        return new Result();
    }

    private Result processConnect(Tokenizer tokenizer, Channel channel) throws SQLException {
        tokenizer.getThis("USER");
        String string = tokenizer.getStringToken();
        tokenizer.getThis("PASSWORD");
        String string2 = tokenizer.getStringToken();
        User user = this.aAccess.getUser(string, string2);
        channel.commit();
        channel.setUser(user);
        return new Result();
    }

    private Result processDisconnect(Tokenizer tokenizer, Channel channel) throws SQLException {
        if (!channel.isClosed()) {
            channel.disconnect();
            this.cChannel.setElementAt(null, channel.getId());
        }
        return new Result();
    }

    private Result processSet(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (string.equals("PASSWORD")) {
            channel.checkReadWrite();
            channel.setPassword(tokenizer.getStringToken());
        } else if (string.equals("READONLY")) {
            channel.commit();
            channel.setReadOnly(this.processTrueOrFalse(tokenizer));
        } else if (string.equals("LOGSIZE")) {
            channel.checkAdmin();
            int n = Integer.parseInt(tokenizer.getString());
            if (this.lLog != null) {
                this.lLog.setLogSize(n);
            }
        } else if (string.equals("IGNORECASE")) {
            channel.checkAdmin();
            this.bIgnoreCase = this.processTrueOrFalse(tokenizer);
        } else if (string.equals("MAXROWS")) {
            int n = Integer.parseInt(tokenizer.getString());
            channel.setMaxRows(n);
        } else if (string.equals("AUTOCOMMIT")) {
            channel.setAutoCommit(this.processTrueOrFalse(tokenizer));
        } else if (string.equals("TABLE")) {
            channel.checkReadWrite();
            channel.checkAdmin();
            Table table = this.getTable(tokenizer.getString(), channel);
            tokenizer.getThis("INDEX");
            tokenizer.getString();
            table.setIndexRoots((String)tokenizer.getAsValue());
        } else if (string.equals("REFERENCIAL_INTEGRITY") || string.equals("REFERENTIAL_INTEGRITY")) {
            channel.checkAdmin();
            this.bReferentialIntegrity = this.processTrueOrFalse(tokenizer);
        } else if (string.equals("WRITE_DELAY")) {
            channel.checkAdmin();
            boolean bl = this.processTrueOrFalse(tokenizer);
            if (this.lLog != null) {
                this.lLog.setWriteDelay(bl);
            }
        } else {
            throw Trace.error(10, string);
        }
        return new Result();
    }

    private boolean processTrueOrFalse(Tokenizer tokenizer) throws SQLException {
        String string = tokenizer.getString();
        if (string.equals("TRUE")) {
            return true;
        }
        if (string.equals("FALSE")) {
            return false;
        }
        throw Trace.error(10, string);
    }

    private Result processCommit(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (!string.equals("WORK")) {
            tokenizer.back();
        }
        channel.commit();
        return new Result();
    }

    private Result processRollback(Tokenizer tokenizer, Channel channel) throws SQLException {
        String string = tokenizer.getString();
        if (!string.equals("WORK")) {
            tokenizer.back();
        }
        channel.rollback();
        return new Result();
    }

    public void finalize() {
        try {
            this.close(0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void close(int n) throws SQLException {
        if (this.lLog == null) {
            return;
        }
        this.lLog.stop();
        if (n == -1) {
            this.lLog.shutdown();
        } else if (n == 0) {
            this.lLog.close(false);
        } else if (n == 1) {
            this.lLog.close(true);
        }
        this.lLog = null;
        this.bShutdown = true;
    }

    private Result processShutdown(Tokenizer tokenizer, Channel channel) throws SQLException {
        channel.checkAdmin();
        int n = 1;
        while (n < this.cChannel.size()) {
            Channel channel2 = (Channel)this.cChannel.elementAt(n);
            if (channel2 != null) {
                channel2.disconnect();
            }
            ++n;
        }
        this.cChannel.removeAllElements();
        String string = tokenizer.getString();
        if (string.equals("IMMEDIATELY")) {
            this.close(-1);
        } else if (string.equals("COMPACT")) {
            this.close(1);
        } else {
            tokenizer.back();
            this.close(0);
        }
        this.processDisconnect(tokenizer, channel);
        return new Result();
    }

    private Result processCheckpoint(Channel channel) throws SQLException {
        channel.checkAdmin();
        if (this.lLog != null) {
            this.lLog.checkpoint();
        }
        return new Result();
    }

    private void dropTable(String string) throws SQLException {
        int n = 0;
        while (n < this.tTable.size()) {
            Table table = (Table)this.tTable.elementAt(n);
            if (table.getName().equals(string)) {
                this.tTable.removeElementAt(n);
                return;
            }
            ++n;
        }
        throw Trace.error(21, string);
    }

    Database(String string) throws SQLException {
        this.sName = string;
        this.tTable = new Vector();
        this.aAccess = new Access();
        this.cChannel = new Vector();
        this.hAlias = new Hashtable();
        this.bReferentialIntegrity = true;
        Library.register(this.hAlias);
        this.dInfo = new DatabaseInformation(this, this.tTable, this.aAccess);
        boolean bl = false;
        Channel channel = new Channel(this, new User(null, null, true, null), true, false, 0);
        this.registerChannel(channel);
        if (string.equals(".")) {
            bl = true;
        } else {
            this.lLog = new Log(this, channel, string);
            bl = this.lLog.open();
        }
        if (bl) {
            this.execute("CREATE USER SA PASSWORD \"\" ADMIN", channel);
        }
        this.aAccess.grant("PUBLIC", "CLASS \"java.lang.Math\"", 15);
        this.aAccess.grant("PUBLIC", "CLASS \"org.hsql.Library\"", 15);
    }
}

