/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.request;

import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.TModelBag;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FindBinding
extends UDDIElement {
    public static final String UDDI_TAG = "find_binding";
    protected Element base = null;
    String maxRows = null;
    String serviceKey = null;
    FindQualifiers findQualifiers = null;
    TModelBag tModelBag = null;

    public FindBinding() {
    }

    public FindBinding(String string, TModelBag tModelBag) {
        this.serviceKey = string;
        this.tModelBag = tModelBag;
    }

    public FindBinding(Element element) throws UDDIException {
        super(element);
        this.maxRows = element.getAttribute("maxRows");
        this.serviceKey = element.getAttribute("serviceKey");
        NodeList nodeList = null;
        nodeList = this.getChildElementsByTagName(element, "findQualifiers");
        if (nodeList.getLength() > 0) {
            this.findQualifiers = new FindQualifiers((Element)nodeList.item(0));
        }
        if ((nodeList = this.getChildElementsByTagName(element, "tModelBag")).getLength() > 0) {
            this.tModelBag = new TModelBag((Element)nodeList.item(0));
        }
    }

    public FindQualifiers getFindQualifiers() {
        return this.findQualifiers;
    }

    public String getMaxRows() {
        return this.maxRows;
    }

    public int getMaxRowsInt() {
        return Integer.parseInt(this.maxRows);
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public TModelBag getTModelBag() {
        return this.tModelBag;
    }

    public void saveToXML(Element element) {
        this.base = element.getOwnerDocument().createElement(UDDI_TAG);
        this.base.setAttribute("generic", UDDIElement.GENERIC);
        this.base.setAttribute("xmlns", UDDIElement.XMLNS);
        if (this.maxRows != null) {
            this.base.setAttribute("maxRows", this.maxRows);
        }
        if (this.serviceKey != null) {
            this.base.setAttribute("serviceKey", this.serviceKey);
        }
        if (this.findQualifiers != null) {
            this.findQualifiers.saveToXML(this.base);
        }
        if (this.tModelBag != null) {
            this.tModelBag.saveToXML(this.base);
        }
        element.appendChild(this.base);
    }

    public void setFindQualifiers(FindQualifiers findQualifiers) {
        this.findQualifiers = findQualifiers;
    }

    public void setMaxRows(int n) {
        this.maxRows = Integer.toString(n);
    }

    public void setMaxRows(String string) {
        this.maxRows = string;
    }

    public void setServiceKey(String string) {
        this.serviceKey = string;
    }

    public void setTModelBag(TModelBag tModelBag) {
        this.tModelBag = tModelBag;
    }
}

