/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CursorableLinkedList;
import org.apache.commons.pool.BaseKeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public class GenericKeyedObjectPool
extends BaseKeyedObjectPool
implements KeyedObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    protected int _maxIdle = 8;
    protected int _maxActive = 8;
    protected long _maxWait = -1L;
    protected byte _whenExhaustedAction = 1;
    protected boolean _testOnBorrow = false;
    protected boolean _testOnReturn = false;
    protected boolean _testWhileIdle = false;
    protected long _timeBetweenEvictionRunsMillis = -1L;
    protected int _numTestsPerEvictionRun = 3;
    protected long _minEvictableIdleTimeMillis = 1800000L;
    protected HashMap _poolMap = null;
    protected CursorableLinkedList _poolList = null;
    protected HashMap _activeMap = null;
    protected int _totalActive = 0;
    protected int _totalIdle = 0;
    protected KeyedPoolableObjectFactory _factory = null;
    protected Evictor _evictor = null;

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory) {
        this(keyedPoolableObjectFactory, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n) {
        this(keyedPoolableObjectFactory, n, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n, byte by, long l) {
        this(keyedPoolableObjectFactory, n, by, l, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n, byte by, long l, int n2) {
        this(keyedPoolableObjectFactory, n, by, l, n2, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n, byte by, long l, int n2, boolean bl, boolean bl2) {
        this(keyedPoolableObjectFactory, n, by, l, n2, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n, byte by, long l, int n2, boolean bl, boolean bl2, long l2, int n3, long l3, boolean bl3) {
        this._factory = keyedPoolableObjectFactory;
        this._maxActive = n;
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
            }
        }
        this._maxWait = l;
        this._maxIdle = n2;
        this._testOnBorrow = bl;
        this._testOnReturn = bl2;
        this._timeBetweenEvictionRunsMillis = l2;
        this._numTestsPerEvictionRun = n3;
        this._minEvictableIdleTimeMillis = l3;
        this._testWhileIdle = bl3;
        this._poolMap = new HashMap();
        this._activeMap = new HashMap();
        this._poolList = new CursorableLinkedList();
        if (this._timeBetweenEvictionRunsMillis > 0L) {
            this._evictor = new Evictor();
            Thread thread = new Thread(this._evictor);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n, byte by, long l, boolean bl, boolean bl2) {
        this(keyedPoolableObjectFactory, n, by, l, 8, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, Config config) {
        this(keyedPoolableObjectFactory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public synchronized Object borrowObject(Object object) throws Exception {
        ObjectTimestampPair objectTimestampPair;
        long l = System.currentTimeMillis();
        block11: while (true) {
            CursorableLinkedList cursorableLinkedList;
            if ((cursorableLinkedList = (CursorableLinkedList)this._poolMap.get(object)) == null) {
                cursorableLinkedList = new CursorableLinkedList();
                this._poolMap.put(object, cursorableLinkedList);
                this._poolList.add(object);
            }
            objectTimestampPair = null;
            try {
                objectTimestampPair = (ObjectTimestampPair)cursorableLinkedList.removeFirst();
                if (objectTimestampPair != null) {
                    --this._totalIdle;
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
            if (objectTimestampPair == null) {
                Object object2;
                int n = 0;
                Integer n2 = (Integer)this._activeMap.get(object);
                if (n2 != null) {
                    n = n2;
                }
                if (this._maxActive > 0 && n < this._maxActive) {
                    object2 = this._factory.makeObject(object);
                    objectTimestampPair = new ObjectTimestampPair(object2);
                } else {
                    switch (this._whenExhaustedAction) {
                        case 2: {
                            object2 = this._factory.makeObject(object);
                            objectTimestampPair = new ObjectTimestampPair(object2);
                            break;
                        }
                        case 0: {
                            throw new NoSuchElementException();
                        }
                        case 1: {
                            try {
                                if (this._maxWait <= 0L) {
                                    this.wait();
                                } else {
                                    this.wait(this._maxWait);
                                }
                            }
                            catch (InterruptedException interruptedException) {}
                            if (this._maxWait <= 0L || System.currentTimeMillis() - l < this._maxWait) continue block11;
                            throw new NoSuchElementException("Timeout waiting for idle object");
                        }
                        default: {
                            throw new IllegalArgumentException("whenExhaustedAction " + this._whenExhaustedAction + " not recognized.");
                        }
                    }
                }
            }
            this._factory.activateObject(object, objectTimestampPair.value);
            if (!this._testOnBorrow || this._factory.validateObject(object, objectTimestampPair.value)) break;
            try {
                this._factory.passivateObject(object, objectTimestampPair.value);
            }
            catch (Exception exception) {}
            this._factory.destroyObject(object, objectTimestampPair.value);
        }
        Integer n = (Integer)this._activeMap.get(object);
        if (n == null) {
            this._activeMap.put(object, new Integer(1));
        } else {
            this._activeMap.put(object, new Integer(n + 1));
        }
        ++this._totalActive;
        return objectTimestampPair.value;
    }

    public synchronized void clear() {
        Iterator iterator = this._poolList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            CursorableLinkedList cursorableLinkedList = (CursorableLinkedList)this._poolMap.get(e);
            Iterator iterator2 = cursorableLinkedList.iterator();
            while (iterator2.hasNext()) {
                try {
                    this._factory.destroyObject(e, ((ObjectTimestampPair)iterator2.next()).value);
                }
                catch (Exception exception) {}
                iterator2.remove();
            }
        }
        this._poolMap.clear();
        this._poolList.clear();
        this._totalIdle = 0;
        this.notifyAll();
    }

    public synchronized void clear(Object object) {
        CursorableLinkedList cursorableLinkedList = (CursorableLinkedList)this._poolMap.remove(object);
        if (cursorableLinkedList == null) {
            return;
        }
        this._poolList.remove(object);
        Iterator iterator = cursorableLinkedList.iterator();
        while (iterator.hasNext()) {
            try {
                this._factory.destroyObject(object, ((ObjectTimestampPair)iterator.next()).value);
            }
            catch (Exception exception) {}
            iterator.remove();
            --this._totalIdle;
        }
        this.notifyAll();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._poolList = null;
        this._poolMap = null;
        this._activeMap = null;
        if (this._evictor != null) {
            this._evictor.cancel();
            this._evictor = null;
        }
    }

    synchronized String debugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Active: ").append(this.getNumActive()).append("\n");
        stringBuffer.append("Idle: ").append(this.getNumIdle()).append("\n");
        Iterator iterator = this._poolList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t").append(this._poolMap.get(iterator.next())).append("\n");
        }
        return stringBuffer.toString();
    }

    public int getMaxActive() {
        return this._maxActive;
    }

    public int getMaxIdle() {
        return this._maxIdle;
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public int getNumActive() {
        return this._totalActive;
    }

    public synchronized int getNumActive(Object object) {
        try {
            return (Integer)this._activeMap.get(object);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getNumIdle() {
        return this._totalIdle;
    }

    public synchronized int getNumIdle(Object object) {
        try {
            return ((CursorableLinkedList)this._poolMap.get(object)).size();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    public void returnObject(Object object, Object object2) throws Exception {
        block21: {
            CursorableLinkedList cursorableLinkedList = null;
            GenericKeyedObjectPool genericKeyedObjectPool = this;
            synchronized (genericKeyedObjectPool) {
                cursorableLinkedList = (CursorableLinkedList)this._poolMap.get(object);
                if (cursorableLinkedList == null) {
                    cursorableLinkedList = new CursorableLinkedList();
                    this._poolMap.put(object, cursorableLinkedList);
                    this._poolList.add(object);
                }
            }
            boolean bl = true;
            if (this._testOnReturn && !this._factory.validateObject(object, object2)) {
                bl = false;
                try {
                    this._factory.destroyObject(object, object2);
                }
                catch (Exception exception) {}
            } else {
                try {
                    this._factory.passivateObject(object, object2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            boolean bl2 = false;
            GenericKeyedObjectPool genericKeyedObjectPool2 = this;
            synchronized (genericKeyedObjectPool2) {
                --this._totalActive;
                Integer n = (Integer)this._activeMap.get(object);
                if (n != null) {
                    if (n <= 1) {
                        this._activeMap.remove(object);
                    } else {
                        this._activeMap.put(object, new Integer(n - 1));
                    }
                }
                if (this._maxIdle > 0 && cursorableLinkedList.size() >= this._maxIdle) {
                    bl2 = true;
                } else if (bl) {
                    cursorableLinkedList.addFirst((Object)new ObjectTimestampPair(object2));
                    ++this._totalIdle;
                }
                this.notifyAll();
            }
            if (!bl2) break block21;
            try {
                this._factory.destroyObject(object, object2);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void setConfig(Config config) {
        this.setMaxIdle(config.maxIdle);
        this.setMaxActive(config.maxActive);
        this.setMaxWait(config.maxWait);
        this.setWhenExhaustedAction(config.whenExhaustedAction);
        this.setTestOnBorrow(config.testOnBorrow);
        this.setTestOnReturn(config.testOnReturn);
        this.setTestWhileIdle(config.testWhileIdle);
        this.setNumTestsPerEvictionRun(config.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(config.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(config.timeBetweenEvictionRunsMillis);
    }

    public synchronized void setFactory(KeyedPoolableObjectFactory keyedPoolableObjectFactory) throws IllegalStateException {
        if (this.getNumActive() > 0) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = keyedPoolableObjectFactory;
    }

    public void setMaxActive(int n) {
        this._maxActive = n;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this.notifyAll();
        }
    }

    public void setMaxIdle(int n) {
        this._maxIdle = n;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this.notifyAll();
        }
    }

    public synchronized void setMaxWait(long l) {
        this._maxWait = l;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l) {
        this._minEvictableIdleTimeMillis = l;
    }

    public void setNumTestsPerEvictionRun(int n) {
        this._numTestsPerEvictionRun = n;
    }

    public void setTestOnBorrow(boolean bl) {
        this._testOnBorrow = bl;
    }

    public void setTestOnReturn(boolean bl) {
        this._testOnReturn = bl;
    }

    public void setTestWhileIdle(boolean bl) {
        this._testWhileIdle = bl;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l) {
        if (this._timeBetweenEvictionRunsMillis > 0L && l <= 0L) {
            this._evictor.cancel();
            this._evictor = null;
            this._timeBetweenEvictionRunsMillis = l;
        } else if (this._timeBetweenEvictionRunsMillis <= 0L && l > 0L) {
            this._timeBetweenEvictionRunsMillis = l;
            this._evictor = new Evictor();
            Thread thread = new Thread(this._evictor);
            thread.setDaemon(true);
            thread.start();
        } else {
            this._timeBetweenEvictionRunsMillis = l;
        }
    }

    public synchronized void setWhenExhaustedAction(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = by;
                this.notifyAll();
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
            }
        }
    }

    class ObjectTimestampPair {
        Object value;
        long tstamp;

        ObjectTimestampPair(Object object) {
            this.value = object;
            this.tstamp = System.currentTimeMillis();
        }

        ObjectTimestampPair(Object object, long l) {
            this.value = object;
            this.tstamp = l;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.value)) + ";" + this.tstamp;
        }
    }

    class Evictor
    implements Runnable {
        protected boolean _cancelled = false;

        Evictor() {
        }

        void cancel() {
            this._cancelled = true;
        }

        private int getNumTests() {
            if (GenericKeyedObjectPool.this._numTestsPerEvictionRun >= 0) {
                return GenericKeyedObjectPool.this._numTestsPerEvictionRun;
            }
            return (int)Math.ceil((double)GenericKeyedObjectPool.this._totalIdle / Math.abs((double)GenericKeyedObjectPool.this._numTestsPerEvictionRun));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            CursorableLinkedList.Cursor cursor = null;
            CursorableLinkedList.Cursor cursor2 = null;
            Object object = null;
            block22: while (!this._cancelled) {
                long l = 0L;
                GenericKeyedObjectPool genericKeyedObjectPool = GenericKeyedObjectPool.this;
                synchronized (genericKeyedObjectPool) {
                    l = GenericKeyedObjectPool.this._timeBetweenEvictionRunsMillis;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(l);
                }
                catch (Exception exception) {}
                try {
                    genericKeyedObjectPool = GenericKeyedObjectPool.this;
                    synchronized (genericKeyedObjectPool) {
                        int n = 0;
                        int n2 = this.getNumTests();
                        while (true) {
                            block37: {
                                block40: {
                                    ObjectTimestampPair objectTimestampPair;
                                    block41: {
                                        block38: {
                                            block39: {
                                                if (n >= n2) {
                                                    continue block22;
                                                }
                                                if (GenericKeyedObjectPool.this._poolMap.size() <= 0) break block37;
                                                if (cursor2 == null) {
                                                    cursor2 = GenericKeyedObjectPool.this._poolList.cursor();
                                                    object = null;
                                                    if (cursor != null) {
                                                        cursor.close();
                                                        cursor = null;
                                                    }
                                                }
                                                if (cursor != null) break block38;
                                                if (cursor2.hasNext()) break block39;
                                                if (cursor2 != null) {
                                                    cursor2.close();
                                                    cursor2 = GenericKeyedObjectPool.this._poolList.cursor();
                                                    if (cursor != null) {
                                                        cursor.close();
                                                        cursor = null;
                                                    }
                                                }
                                                break block37;
                                            }
                                            object = cursor2.next();
                                            objectTimestampPair = (CursorableLinkedList)GenericKeyedObjectPool.this._poolMap.get(object);
                                            cursor = objectTimestampPair.cursor(objectTimestampPair.size());
                                        }
                                        if (!cursor.hasPrevious()) break block40;
                                        objectTimestampPair = (ObjectTimestampPair)cursor.previous();
                                        if (System.currentTimeMillis() - objectTimestampPair.tstamp <= GenericKeyedObjectPool.this._minEvictableIdleTimeMillis) break block41;
                                        try {
                                            cursor.remove();
                                            --GenericKeyedObjectPool.this._totalIdle;
                                            GenericKeyedObjectPool.this._factory.destroyObject(object, objectTimestampPair.value);
                                            if (((CursorableLinkedList)GenericKeyedObjectPool.this._poolMap.get(object)).isEmpty()) {
                                                GenericKeyedObjectPool.this._poolMap.remove(object);
                                                GenericKeyedObjectPool.this._poolList.remove(object);
                                            }
                                            break block37;
                                        }
                                        catch (Exception exception) {}
                                        break block37;
                                    }
                                    if (!GenericKeyedObjectPool.this._testWhileIdle) break block37;
                                    boolean bl = false;
                                    try {
                                        GenericKeyedObjectPool.this._factory.activateObject(object, objectTimestampPair.value);
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        cursor.remove();
                                        try {
                                            GenericKeyedObjectPool.this._factory.passivateObject(object, objectTimestampPair.value);
                                        }
                                        catch (Exception exception2) {}
                                        GenericKeyedObjectPool.this._factory.destroyObject(object, objectTimestampPair.value);
                                    }
                                    if (!bl) break block37;
                                    if (!GenericKeyedObjectPool.this._factory.validateObject(object, objectTimestampPair.value)) {
                                        try {
                                            cursor.remove();
                                            --GenericKeyedObjectPool.this._totalIdle;
                                            try {
                                                GenericKeyedObjectPool.this._factory.passivateObject(object, objectTimestampPair.value);
                                            }
                                            catch (Exception exception) {}
                                            GenericKeyedObjectPool.this._factory.destroyObject(object, objectTimestampPair.value);
                                            if (((CursorableLinkedList)GenericKeyedObjectPool.this._poolMap.get(object)).isEmpty()) {
                                                GenericKeyedObjectPool.this._poolMap.remove(object);
                                                GenericKeyedObjectPool.this._poolList.remove(object);
                                            }
                                            break block37;
                                        }
                                        catch (Exception exception) {}
                                        break block37;
                                    } else {
                                        try {
                                            GenericKeyedObjectPool.this._factory.passivateObject(object, objectTimestampPair.value);
                                        }
                                        catch (Exception exception) {
                                            cursor.remove();
                                            --GenericKeyedObjectPool.this._totalIdle;
                                            GenericKeyedObjectPool.this._factory.destroyObject(object, objectTimestampPair.value);
                                            if (((CursorableLinkedList)GenericKeyedObjectPool.this._poolMap.get(object)).isEmpty()) {
                                                GenericKeyedObjectPool.this._poolMap.remove(object);
                                                GenericKeyedObjectPool.this._poolList.remove(object);
                                            }
                                            break block37;
                                        }
                                    }
                                }
                                if (cursor != null) {
                                    cursor.close();
                                    cursor = null;
                                }
                            }
                            ++n;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            if (cursor2 != null) {
                cursor2.close();
            }
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public static class Config {
        public int maxIdle = 8;
        public int maxActive = 8;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
    }
}

