/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.CollectionDescriptor;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.metadata.ObjectReferenceDescriptor;
import ojb.broker.metadata.PersistentField;
import ojb.broker.query.BetweenCriteria;
import ojb.broker.query.Criteria;
import ojb.broker.query.EqualToColumnCriteria;
import ojb.broker.query.ExistsCriteria;
import ojb.broker.query.InCriteria;
import ojb.broker.query.NullCriteria;
import ojb.broker.query.Query;
import ojb.broker.query.QueryByMtoNCriteria;
import ojb.broker.query.SelectionCriteria;
import ojb.broker.query.SqlCriteria;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;

public class SqlGenerator {
    private static SqlGenerator _instance;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;

    private SqlGenerator() {
    }

    public static SqlGenerator getInstance() {
        if (_instance == null) {
            _instance = new SqlGenerator();
        }
        return _instance;
    }

    private String getListOfColumns(ClassDescriptor mif, boolean useFullNames) {
        StringBuffer list = new StringBuffer();
        String cn = null;
        FieldDescriptor[] fields = mif.getFieldDescriptions();
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fmd = fields[i];
            cn = useFullNames ? fmd.getFullColumnName() : fmd.getColumnName();
            list.append(this.quote(cn));
            if (i < fields.length - 1) {
                list.append(",");
            }
            ++i;
        }
        return list.toString();
    }

    private String getListOfColumns(Object[] columns) {
        StringBuffer list = new StringBuffer();
        int i = 0;
        while (i < columns.length) {
            String cn = columns[i].toString();
            list.append(this.quote(cn));
            if (i < columns.length - 1) {
                list.append(",");
            }
            ++i;
        }
        return list.toString();
    }

    private String quote(String col) {
        return col;
    }

    private String quoteIfNeeded(String str, String dbtype) {
        String[] quotables = new String[]{"DATE", "TIME", "CHAR", "STRING"};
        boolean test = false;
        int i = 0;
        while (i < quotables.length) {
            if (dbtype.startsWith(quotables[i])) {
                test = true;
                break;
            }
            ++i;
        }
        if (test) {
            str = this.escapeSingleQuotes(str);
            return "'" + str + "'";
        }
        return str;
    }

    private String escapeSingleQuotes(String str) {
        String result = str;
        if (str.indexOf("'") != -1) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (c == '\'') {
                    buf.append("\\'");
                } else {
                    buf.append(c);
                }
                ++i;
            }
            result = buf.toString();
        }
        return result;
    }

    private String getColName(SelectionCriteria c, ClassDescriptor cld) {
        String colName;
        String attr = c.getAttribute();
        FieldDescriptor fld = null;
        if (cld != null) {
            int sp = attr.lastIndexOf(".");
            if (sp == -1) {
                fld = cld.getFieldDescriptorByName(attr);
            } else {
                ClassDescriptor refCld = null;
                String pathName = attr.substring(0, sp);
                String fieldName = attr.substring(sp + 1);
                ObjectReferenceDescriptor ord = cld.getObjectReferenceDescriptorByName(pathName);
                CollectionDescriptor cod = cld.getCollectionDescriptorByName(pathName);
                if (ord != null) {
                    refCld = cld.getRepository().getDescriptorFor(ord.getItemClass());
                } else if (cod != null) {
                    refCld = cld.getRepository().getDescriptorFor(cod.getItemClass());
                }
                if (refCld != null) {
                    fld = refCld.getFieldDescriptorByName(fieldName);
                }
            }
            colName = fld != null ? fld.getFullColumnName() : attr;
        } else {
            colName = attr;
        }
        return colName;
    }

    private String toSQLClause(NullCriteria c, ClassDescriptor cld) {
        String colName = this.getColName(c, cld);
        return colName + c.getClause();
    }

    private String toSQLClause(EqualToColumnCriteria c, ClassDescriptor cld) {
        String colName = this.getColName(c, cld);
        return colName + c.getClause() + c.getValue();
    }

    private String toSQLClause(BetweenCriteria c, ClassDescriptor cld) {
        String colName = this.getColName(c, cld);
        return colName + c.getClause() + " ? AND ? ";
    }

    private String toSQLClause(InCriteria c, ClassDescriptor cld) {
        StringBuffer buf = new StringBuffer();
        Collection values = (Collection)c.getO();
        int size = values.size();
        buf.append(this.getColName(c, cld));
        buf.append(c.getClause());
        buf.append("(");
        int i = 0;
        while (i < size - 1) {
            buf.append("?,");
            ++i;
        }
        buf.append("?)");
        return buf.toString();
    }

    private String toSQLClause(SelectionCriteria c, ClassDescriptor cld) {
        String colName = this.getColName(c, cld);
        return colName + c.getClause() + " ? ";
    }

    private String toSQLClause(SqlCriteria c, ClassDescriptor cld) {
        return c.getClause();
    }

    private String toSQLClause(ExistsCriteria c, ClassDescriptor cld) {
        StringBuffer buf = new StringBuffer();
        Query subQuery = (Query)c.getO();
        buf.append(c.getClause());
        buf.append(" (");
        if (cld != null) {
            buf.append(this.getPreparedSelectStatement(subQuery, cld.getRepository().getDescriptorFor(subQuery.getSearchClass())));
        } else {
            buf.append(subQuery);
        }
        buf.append(")");
        return buf.toString();
    }

    protected String asSQLClause(SelectionCriteria c, ClassDescriptor cld) {
        if (c instanceof EqualToColumnCriteria) {
            return this.toSQLClause((EqualToColumnCriteria)c, cld);
        }
        if (c instanceof NullCriteria) {
            return this.toSQLClause((NullCriteria)c, cld);
        }
        if (c instanceof BetweenCriteria) {
            return this.toSQLClause((BetweenCriteria)c, cld);
        }
        if (c instanceof InCriteria) {
            return this.toSQLClause((InCriteria)c, cld);
        }
        if (c instanceof SqlCriteria) {
            return this.toSQLClause((SqlCriteria)c, cld);
        }
        if (c instanceof ExistsCriteria) {
            return this.toSQLClause((ExistsCriteria)c, cld);
        }
        return this.toSQLClause(c, cld);
    }

    public String asSQLStatement(Criteria crit, ClassDescriptor cld) {
        Enumeration e = crit.getElements();
        StringBuffer statement = new StringBuffer();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                String addAtEnd;
                String addAtStart;
                Criteria pc = (Criteria)o;
                if (pc.isEmbraced()) {
                    addAtStart = " (";
                    addAtEnd = ") ";
                } else {
                    addAtStart = "";
                    addAtEnd = "";
                }
                switch (pc.getType()) {
                    case 0: {
                        statement.append(" OR " + addAtStart);
                        statement.append(this.asSQLStatement(pc, cld));
                        statement.append(addAtEnd);
                        break;
                    }
                    case 1: {
                        statement.insert(0, "( ");
                        statement.append(") ");
                        statement.append(" AND " + addAtStart);
                        statement.append(this.asSQLStatement(pc, cld));
                        statement.append(addAtEnd);
                    }
                }
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            if (statement.length() == 0) {
                statement.append(this.asSQLClause(c, cld));
                continue;
            }
            statement.insert(0, "(");
            statement.append(") ");
            statement.append(" AND ");
            statement.append(this.asSQLClause(c, cld));
        }
        if (statement.length() == 0) {
            return null;
        }
        return statement.toString();
    }

    private String getListOfValues(ClassDescriptor mif) {
        StringBuffer list = new StringBuffer();
        FieldDescriptor[] fields = mif.getFieldDescriptions();
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fmd = fields[i];
            PersistentField f = fmd.getPersistentField();
            list.append("?");
            if (i < fields.length - 1) {
                list.append(",");
            }
            ++i;
        }
        return list.toString();
    }

    private String getListOfValues(Object[] values) {
        StringBuffer list = new StringBuffer();
        String val = null;
        int i = 0;
        while (i < values.length) {
            Object obj = values[i];
            val = obj.toString();
            if (!(obj instanceof Number)) {
                val = "'" + val + "'";
            }
            list.append(val);
            if (i < values.length - 1) {
                list.append(",");
            }
            ++i;
        }
        return list.toString();
    }

    public String getPreparedCountStatement(Query query, ClassDescriptor mif) {
        Criteria crit = query.getCriteria();
        StringBuffer stmt = new StringBuffer("SELECT COUNT(*) FROM ");
        stmt.append(mif.getFullTableName());
        stmt.append(this.getJoinClause(query, mif));
        stmt.append(this.getWhereClause(query, mif));
        return stmt.toString();
    }

    public String getPreparedDeleteStatement(ClassDescriptor mif) {
        String tbl = mif.getFullTableName();
        String stmt = "DELETE ";
        stmt = stmt + " FROM " + tbl;
        stmt = stmt + this.getWhereClause(mif, true);
        return stmt;
    }

    public String getPreparedInsertStatement(ClassDescriptor mif) {
        String tbl = mif.getFullTableName();
        String qry = "INSERT INTO " + tbl;
        qry = qry + " (" + this.getListOfColumns(mif, false) + ")";
        qry = qry + " VALUES (" + this.getListOfValues(mif) + ")";
        return qry;
    }

    public String getPreparedSelectByPkStatement(ClassDescriptor mif) {
        String tbl = mif.getFullTableName();
        String stmt = "SELECT ";
        stmt = stmt + this.getListOfColumns(mif, true);
        stmt = stmt + " FROM " + tbl;
        stmt = stmt + this.getWhereClause(mif);
        return stmt;
    }

    public String getPreparedSelectStatement(Query query, ClassDescriptor mif) {
        StringBuffer stmt = new StringBuffer("SELECT ");
        if (query instanceof QueryByMtoNCriteria) {
            QueryByMtoNCriteria m2nq = (QueryByMtoNCriteria)query;
            String tbl = m2nq.getTables();
            if (query.isDistinct()) {
                stmt.append("DISTINCT ");
            }
            stmt.append(this.getListOfColumns(mif, true));
            stmt.append(" FROM " + tbl);
            stmt.append(this.getJoinClause(query, mif));
            stmt.append(this.getWhereClause(query, mif));
            stmt.append(this.getOrderByClause(query, mif));
            return stmt.toString();
        }
        String tbl = mif.getFullTableName();
        if (query.isDistinct()) {
            stmt.append("DISTINCT ");
        }
        stmt.append(this.getListOfColumns(mif, true));
        stmt.append(" FROM " + tbl);
        stmt.append(this.getJoinClause(query, mif));
        stmt.append(this.getWhereClause(query, mif));
        stmt.append(this.getOrderByClause(query, mif));
        return stmt.toString();
    }

    private String getOrderByClause(Query query, ClassDescriptor mif) {
        String stmt = "";
        if (query.getCriteria() == null) {
            return stmt;
        }
        String orderbyField = query.getCriteria().getOrderby();
        if (orderbyField == null) {
            return stmt;
        }
        FieldDescriptor fld = mif.getFieldDescriptorByName(orderbyField);
        if (fld == null) {
            return orderbyField;
        }
        stmt = stmt + " ORDER BY " + fld.getFullColumnName();
        if (!query.getCriteria().isAscending()) {
            stmt = stmt + " DESC";
        }
        return stmt;
    }

    public String getPreparedUpdateStatement(ClassDescriptor mif) {
        String tbl = mif.getFullTableName();
        String stmt = "UPDATE " + tbl;
        String setClause = this.getSetClause(mif);
        if (setClause == null) {
            return null;
        }
        stmt = stmt + setClause;
        stmt = stmt + this.getWhereClause(mif, true);
        return stmt;
    }

    public String getInsertStatement(String table, Object[] columns, Object[] values) {
        String stmt = "INSERT INTO " + table;
        stmt = stmt + " (" + this.getListOfColumns(columns) + ")";
        stmt = stmt + " VALUES (" + this.getListOfValues(values) + ")";
        return stmt;
    }

    public String getDeleteStatement(String table, Object[] columns, Object[] values) {
        String stmt = "DELETE FROM " + table;
        stmt = stmt + this.getWhereClause(columns, values);
        return stmt;
    }

    public String getSelectStatementDep(Query query, ClassDescriptor mif) {
        StringBuffer stmt = new StringBuffer("SELECT ");
        String tbl = mif.getFullTableName();
        if (query.isDistinct()) {
            stmt.append("DISTINCT ");
        }
        stmt.append(this.getListOfColumns(mif, true));
        stmt.append(" FROM " + tbl);
        stmt.append(this.getJoinClause(query, mif));
        stmt.append(this.getWhereClause(query, mif));
        stmt.append(this.getOrderByClause(query, mif));
        return stmt.toString();
    }

    private String getSetClause(ClassDescriptor mif) {
        StringBuffer clause = new StringBuffer(" SET ");
        FieldDescriptor[] fields = mif.getNonPkFields();
        if (fields.length == 0) {
            return null;
        }
        int i = 0;
        while (i < fields.length) {
            String cn = this.quote(fields[i].getColumnName());
            clause.append(cn);
            clause.append("=?");
            if (i < fields.length - 1) {
                clause.append(", ");
            }
            ++i;
        }
        return clause.toString();
    }

    private String getWhereClause(ClassDescriptor mif, boolean useLocking) {
        FieldDescriptor[] lockingFields;
        FieldDescriptor[] pkFields;
        FieldDescriptor[] fields = pkFields = mif.getPkFields();
        if (useLocking && (lockingFields = mif.getLockingFields()).length > 0) {
            fields = new FieldDescriptor[pkFields.length + lockingFields.length];
            System.arraycopy(pkFields, 0, fields, 0, pkFields.length);
            System.arraycopy(lockingFields, 0, fields, pkFields.length, lockingFields.length);
        }
        return this.getWhereClause(fields, null, mif);
    }

    private String getWhereClause(ClassDescriptor mif) {
        return this.getWhereClause(mif, false);
    }

    private String getWhereClause(Query query, ClassDescriptor mif) {
        if (query.getCriteria() != null) {
            String clause = this.asSQLStatement(query.getCriteria(), mif);
            if (clause != null) {
                return " WHERE " + clause;
            }
            return "";
        }
        return "";
    }

    private String getJoinClause(Query query, ClassDescriptor cld) {
        StringBuffer sql = new StringBuffer("");
        if (query.getCriteria() != null) {
            Iterator joins = this.getJoins(query.getCriteria(), cld).iterator();
            while (joins.hasNext()) {
                JoinInfo ji = (JoinInfo)joins.next();
                sql.append(ji.asSqlClause());
            }
        }
        return sql.toString();
    }

    private Set getJoins(Criteria crit, ClassDescriptor cld) {
        Enumeration e = crit.getElements();
        HashSet<JoinInfo> result = new HashSet<JoinInfo>();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                Criteria pc = (Criteria)o;
                result.addAll(this.getJoins(pc, cld));
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            int sp = c.getAttribute().lastIndexOf(".");
            if (sp == -1) continue;
            String pathName = c.getAttribute().substring(0, sp);
            ObjectReferenceDescriptor ord = cld.getObjectReferenceDescriptorByName(pathName);
            CollectionDescriptor cod = cld.getCollectionDescriptorByName(pathName);
            if (ord != null) {
                result.add(new JoinInfo(cld, ord));
                continue;
            }
            if (cod == null) continue;
            result.add(new JoinInfo(cld, cod));
        }
        return result;
    }

    private String getWhereClause(FieldDescriptor[] fields, Object[] values, ClassDescriptor mif) throws PersistenceBrokerException {
        if (fields.length == 0) {
            return "";
        }
        StringBuffer clause = new StringBuffer(" WHERE ");
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fmd = fields[i];
            PersistentField f = fmd.getPersistentField();
            String cn = fmd.getFullColumnName();
            String ct = fmd.getColumnType();
            String val = null;
            if (values != null) {
                try {
                    val = this.quoteIfNeeded(values[i].toString(), ct);
                }
                catch (Exception ex) {
                    this.logger.error("Vector of FieldDescriptors " + fields + " and Vector of values " + values + " differ in size");
                    this.logger.error(ex);
                    throw new PersistenceBrokerException(ex);
                }
            } else {
                val = "?";
            }
            clause.append("(");
            clause.append(this.quote(cn));
            clause.append(" = ");
            clause.append((Object)val);
            clause.append(")");
            if (i < fields.length - 1) {
                clause.append(" AND ");
            }
            ++i;
        }
        return clause.toString();
    }

    private String getWhereClause(Object[] columns, Object[] values) throws PersistenceBrokerException {
        String clause = "";
        int i = 0;
        while (i < columns.length) {
            String cn = columns[i].toString();
            Class<?> c = values[i].getClass();
            String ct = "noquote";
            if (c == (class$java$lang$String == null ? SqlGenerator.class$("java.lang.String") : class$java$lang$String) || c == Character.TYPE || c == (class$java$sql$Date == null ? SqlGenerator.class$("java.sql.Date") : class$java$sql$Date) || c == (class$java$sql$Time == null ? SqlGenerator.class$("java.sql.Time") : class$java$sql$Time)) {
                ct = "STRING";
            }
            clause = clause.equals("") ? " WHERE " : clause + " AND ";
            String val = null;
            if (values != null) {
                try {
                    val = this.quoteIfNeeded(values[i].toString(), ct);
                }
                catch (Exception ex) {
                    this.logger.error("Vector of FieldDescriptors " + columns + " and Vector of values " + values + " differ in size");
                    this.logger.error(ex);
                    throw new PersistenceBrokerException(ex);
                }
            } else {
                val = "?";
            }
            clause = clause + "(" + this.quote(cn) + " = " + val + ")";
            ++i;
        }
        return clause;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class JoinInfo {
        private ClassDescriptor cld;
        private ClassDescriptor refCld;
        private ObjectReferenceDescriptor ord;

        JoinInfo(ClassDescriptor aCld, ObjectReferenceDescriptor anOrd) {
            this.cld = aCld;
            this.refCld = aCld.getRepository().getDescriptorFor(anOrd.getItemClass());
            this.ord = anOrd;
        }

        String asSqlClause() {
            StringBuffer sql = new StringBuffer("");
            FieldDescriptor[] keys = null;
            FieldDescriptor[] ref_keys = null;
            if (this.ord instanceof CollectionDescriptor) {
                keys = this.cld.getPkFields();
                ref_keys = this.ord.getForeignKeyFieldDescriptors(this.refCld);
            } else {
                keys = this.ord.getForeignKeyFieldDescriptors(this.cld);
                ref_keys = this.refCld.getPkFields();
            }
            sql.append(" INNER JOIN ");
            sql.append(this.refCld.getFullTableName());
            sql.append(" ON ");
            int i = 0;
            while (i < keys.length) {
                sql.append(ref_keys[i].getFullColumnName());
                sql.append(" = ");
                sql.append(keys[i].getFullColumnName());
                if (i < keys.length - 1) {
                    sql.append(" AND ");
                }
                ++i;
            }
            return sql.toString();
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (anObject == null) {
                return false;
            }
            if (anObject.getClass() != this.getClass()) {
                return false;
            }
            JoinInfo ji = (JoinInfo)anObject;
            return this.cld == ji.cld && this.refCld == ji.refCld;
        }

        public int hashCode() {
            return this.cld.hashCode() + this.refCld.hashCode();
        }
    }
}

