/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ojb.broker.Identity;
import ojb.broker.OptimisticLockException;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerSQLException;
import ojb.broker.accesslayer.RowReader;
import ojb.broker.accesslayer.SqlGenerator;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.query.Query;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;

public class JdbcAccess {
    private Logger logger;
    private PersistenceBrokerImpl broker;

    public JdbcAccess(PersistenceBrokerImpl broker) {
        this.broker = broker;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public int executeCount(Query query, ClassDescriptor mif) throws PersistenceBrokerException {
        try {
            String sql = SqlGenerator.getInstance().getPreparedCountStatement(query, mif);
            PreparedStatement stmt = this.broker.getStatementManager().getPreparedStatement(mif, sql);
            this.broker.getStatementManager().bindStatement(stmt, query.getCriteria(), mif, 1);
            ResultSet rs = stmt.executeQuery();
            int result = -1;
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            stmt.close();
            return result;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return 0;
        }
    }

    public void executeDelete(ClassDescriptor mif, Object obj) throws PersistenceBrokerException {
        this.logger.info("executeDelete: " + obj);
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.broker.getStatementManager().getDeleteStatement(mif);
            synchronized (preparedStatement) {
                this.broker.getStatementManager().bindDelete(stmt, mif, obj);
                if (stmt.executeUpdate() == 0 && mif.isLocking()) {
                    throw new OptimisticLockException("Object has been modified by someone else", obj);
                }
            }
            stmt = null;
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }

    public void executeInsert(ClassDescriptor mif, Object obj) throws PersistenceBrokerException {
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.broker.getStatementManager().getInsertStatement(mif);
            synchronized (preparedStatement) {
                this.broker.getStatementManager().bindInsert(stmt, mif, obj);
                stmt.executeUpdate();
            }
            stmt = null;
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }

    ResultSet executeQuery(Query query, ClassDescriptor mif) throws PersistenceBrokerException {
        try {
            if (query.getCriteria() != null && !query.getCriteria().isEmpty()) {
                String sql = SqlGenerator.getInstance().getPreparedSelectStatement(query, mif);
                PreparedStatement stmt = this.broker.getStatementManager().getPreparedStatement(mif, sql);
                this.broker.getStatementManager().bindStatement(stmt, query.getCriteria(), mif, 1);
                ResultSet rs = stmt.executeQuery();
                return rs;
            }
            Statement stmt = this.broker.getStatementManager().getGenericStatement(mif);
            String sql = SqlGenerator.getInstance().getSelectStatementDep(query, mif);
            ResultSet rs = stmt.executeQuery(sql);
            return rs;
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }

    ResultSet executeSQL(String sqlStatement, ClassDescriptor cld) throws PersistenceBrokerException {
        ResultSet rs = null;
        try {
            Statement stmt = this.broker.getStatementManager().getGenericStatement(cld);
            rs = stmt.executeQuery(sqlStatement);
            return rs;
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }

    public int executeUpdateSQL(String sqlStatement, ClassDescriptor cld) throws PersistenceBrokerException {
        try {
            Statement stmt = this.broker.getStatementManager().getGenericStatement(cld);
            int result = stmt.executeUpdate(sqlStatement);
            return result;
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }

    public void executeUpdate(ClassDescriptor mif, Object obj) throws PersistenceBrokerException {
        this.logger.info("executeUpdate: " + obj);
        try {
            PreparedStatement stmt = this.broker.getStatementManager().getUpdateStatement(mif);
            if (stmt == null) {
                return;
            }
            PreparedStatement preparedStatement = stmt;
            synchronized (preparedStatement) {
                this.broker.getStatementManager().bindUpdate(stmt, mif, obj);
                if (stmt.executeUpdate() == 0 && mif.isLocking()) {
                    throw new OptimisticLockException("Object has been modified by someone else", obj);
                }
            }
            stmt = null;
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }

    public Object materializeObject(ClassDescriptor mif, Identity oid) throws PersistenceBrokerException {
        Object obj = null;
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.broker.getStatementManager().getSelectByPKStatement(mif);
            synchronized (preparedStatement) {
                this.broker.getStatementManager().bindSelect(stmt, oid);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    RowReader reader = mif.getRowReader();
                    Object[] row = new Object[mif.getFieldDescriptions().length];
                    reader.readObjectArrayFrom(rs, mif, row);
                    obj = mif.getRowReader().readObjectFrom(row, mif);
                } else {
                    obj = null;
                }
                rs.close();
                rs = null;
                Object object = obj;
                return object;
            }
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object readObjectFromResultSet(ResultSet rs, ClassDescriptor mif) throws PersistenceBrokerException {
        val = null;
        fmd = null;
        multiArgsConstructor = mif.getConstructor();
        conversion = mif.getConversionStrategy();
        args = null;
        try {
            if (multiArgsConstructor != null) {
                fields = mif.getFieldDescriptions();
                args = new Object[fields.length];
                i = 0;
                while (i < fields.length) {
                    fmd = fields[i];
                    val = JdbcAccess.getObjectFromColumn(rs, fmd);
                    args[i] = conversion.sqlToJava(val, fmd);
                    ++i;
                }
                return multiArgsConstructor.newInstance(args);
            }
            c = mif.getClassOfObject();
            obj = c.newInstance();
            fields = mif.getFieldDescriptions();
            i = 0;
            while (i < fields.length) {
                fmd = fields[i];
                val = JdbcAccess.getObjectFromColumn(rs, fmd);
                if (val != null || !fmd.getPersistentField().getDeclaringClass().isPrimitive()) {
                    fmd.getPersistentField().set(obj, conversion.sqlToJava(val, fmd));
                }
                ++i;
            }
            return obj;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
        catch (Exception ex) {
            this.logger.error("class: " + mif.getClassOfObject().getName());
            buf = new StringBuffer();
            buf.append("args: ");
            x = 0;
            ** while (x < args.length)
        }
lbl-1000:
        // 1 sources

        {
            buf.append(args[x] + ",");
            ++x;
            continue;
        }
lbl43:
        // 1 sources

        this.logger.error(buf.toString());
        this.logger.error(ex);
        throw new PersistenceBrokerException(ex);
    }

    static Object getObjectFromColumn(ResultSet rs, FieldDescriptor fld) throws SQLException {
        int jdbcType = JdbcAccess.getJdbcType(fld);
        int columnId = rs.findColumn(fld.getColumnName());
        return JdbcAccess.getObjectFromColumn(rs, jdbcType, columnId);
    }

    static Object getObjectFromColumn(ResultSet rs, int jdbcType, int columnId) throws SQLException {
        Object result = null;
        switch (jdbcType) {
            case -7: {
                result = new Boolean(rs.getBoolean(columnId));
                break;
            }
            case -6: {
                result = new Byte(rs.getByte(columnId));
                break;
            }
            case 5: {
                result = new Short(rs.getShort(columnId));
                break;
            }
            case 4: {
                result = new Integer(rs.getInt(columnId));
                break;
            }
            case -5: {
                result = new Long(rs.getLong(columnId));
                break;
            }
            case 6: {
                result = new Double(rs.getDouble(columnId));
                break;
            }
            case 7: {
                result = new Float(rs.getFloat(columnId));
                break;
            }
            case 8: {
                result = new Double(rs.getDouble(columnId));
                break;
            }
            case 2: {
                result = rs.getBigDecimal(columnId);
                break;
            }
            case 3: {
                result = rs.getBigDecimal(columnId);
                break;
            }
            case 1: {
                result = rs.getString(columnId);
                break;
            }
            case 12: {
                result = rs.getString(columnId);
                break;
            }
            case -1: {
                result = rs.getString(columnId);
                break;
            }
            case 91: {
                result = rs.getDate(columnId);
                break;
            }
            case 92: {
                result = rs.getTime(columnId);
                break;
            }
            case 93: {
                result = rs.getTimestamp(columnId);
                break;
            }
            case -2: {
                result = rs.getBytes(columnId);
                break;
            }
            case -3: {
                result = rs.getBytes(columnId);
                break;
            }
            case -4: {
                result = rs.getBytes(columnId);
                break;
            }
            case 2005: {
                Clob aClob = rs.getClob(columnId);
                result = aClob.getSubString(0L, (int)aClob.length());
                break;
            }
            case 2004: {
                Blob aBlob = rs.getBlob(columnId);
                result = aBlob.getBytes(0L, (int)aBlob.length());
                break;
            }
            default: {
                throw new RuntimeException("The type " + jdbcType + " for attribute " + columnId + " can not be handled by OJB. Please specify only types as defined by java.sql.Types.");
            }
        }
        return result;
    }

    private static int getJdbcType(FieldDescriptor fld) {
        int result;
        String type = fld.getColumnType().toLowerCase();
        if (type.equals("bit")) {
            result = -7;
        } else if (type.equals("tinyint")) {
            result = -6;
        } else if (type.equals("smallint")) {
            result = 5;
        } else if (type.equals("integer")) {
            result = 4;
        } else if (type.equals("bigint")) {
            result = -5;
        } else if (type.equals("float")) {
            result = 6;
        } else if (type.equals("real")) {
            result = 7;
        } else if (type.equals("double")) {
            result = 8;
        } else if (type.equals("numeric")) {
            result = 2;
        } else if (type.equals("decimal")) {
            result = 3;
        } else if (type.equals("char")) {
            result = 1;
        } else if (type.equals("varchar")) {
            result = 12;
        } else if (type.equals("longvarchar")) {
            result = -1;
        } else if (type.equals("date")) {
            result = 91;
        } else if (type.equals("time")) {
            result = 92;
        } else if (type.equals("timestamp")) {
            result = 93;
        } else if (type.equals("binary")) {
            result = -2;
        } else if (type.equals("varbinary")) {
            result = -3;
        } else if (type.equals("longvarbinary")) {
            result = -4;
        } else if (type.equals("clob")) {
            result = 2005;
        } else if (type.equals("blob")) {
            result = 2004;
        } else {
            throw new RuntimeException("The type " + fld.getColumnType() + " for attribute " + fld.getColumnName() + " can not be handled by OJB. Please specify only types as defined by java.sql.Types.");
        }
        return result;
    }

    static int getSqlTypeAll(ClassDescriptor cld, int index) {
        FieldDescriptor fld = cld.getFieldDescriptions()[index];
        return JdbcAccess.getJdbcType(fld);
    }

    static int getSqlTypeNonPk(ClassDescriptor cld, int index) {
        FieldDescriptor fld = cld.getNonPkFields()[index];
        return JdbcAccess.getJdbcType(fld);
    }

    static int getSqlTypePk(ClassDescriptor cld, int index) {
        FieldDescriptor fld = cld.getPkFields()[index];
        return JdbcAccess.getJdbcType(fld);
    }
}

