/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe.attribute;

import com.develop.jcfe.attribute.Attribute;
import com.develop.jcfe.attribute.CustomAttribute;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializableAttribute
extends Attribute {
    private final Object info;
    private final byte[] packet;

    public SerializableAttribute(Object info) throws IOException {
        super("ser." + info.getClass().getName());
        this.info = info;
        this.packet = this.writePacket();
    }

    private SerializableAttribute(String name, short index, Object info, byte[] packet) {
        super(name, index);
        this.info = info;
        this.packet = packet;
    }

    public static Attribute read(String name, DataInputStream dis, short name_index, int length) throws IOException {
        byte[] packet = new byte[length];
        dis.readFully(packet);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(packet));
        Object info = null;
        try {
            info = ois.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            return new CustomAttribute(name, packet);
        }
        return new SerializableAttribute(name, name_index, info, packet);
    }

    private byte[] writePacket() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.info);
        return baos.toByteArray();
    }

    public Object getObject() {
        return this.info;
    }

    public int getLength() {
        return this.packet.length;
    }

    public void writeToStream(DataOutputStream ds) throws IOException {
        super.writeToStream(ds);
        ds.write(this.packet);
    }

    public String toString() {
        return "Attribute " + this.getName() + "\n" + this.info;
    }
}

