/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

public class DefaultFileItem
implements FileItem {
    private static int counter = 0;
    private String fileName;
    private String contentType;
    private byte[] content;
    private File storeLocation;
    private ByteArrayOutputStream byteStream;
    private String fieldName;
    private boolean isFormField;
    static /* synthetic */ Class class$org$apache$commons$fileupload$DefaultFileItem;

    public DefaultFileItem() {
    }

    protected DefaultFileItem(String fileName, String contentType) {
        this.fileName = fileName;
        this.contentType = contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.content == null) {
            if (this.storeLocation != null) {
                return new FileInputStream(this.storeLocation);
            }
            this.content = this.byteStream.toByteArray();
            this.byteStream = null;
        }
        return new ByteArrayInputStream(this.content);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        return this.content != null || this.byteStream != null;
    }

    public long getSize() {
        if (this.storeLocation != null) {
            return this.storeLocation.length();
        }
        if (this.byteStream != null) {
            return this.byteStream.size();
        }
        return this.content.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] get() {
        if (this.content != null) return this.content;
        if (this.storeLocation != null) {
            this.content = new byte[(int)this.getSize()];
            FileInputStream fis = null;
            fis = new FileInputStream(this.storeLocation);
            fis.read(this.content);
            Object var4_2 = null;
            if (fis == null) return this.content;
            try {
                fis.close();
                return this.content;
            }
            catch (IOException e2) {}
            return this.content;
            {
                catch (Exception e) {
                    this.content = null;
                    Object var4_3 = null;
                    if (fis == null) return this.content;
                    try {
                        fis.close();
                        return this.content;
                    }
                    catch (IOException e2) {}
                    return this.content;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.content = this.byteStream.toByteArray();
        this.byteStream = null;
        return this.content;
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public String getString() {
        return new String(this.get());
    }

    public File getStoreLocation() {
        return this.storeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(String file) throws Exception {
        if (this.isInMemory()) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                fout.write(this.get());
                Object var4_4 = null;
                if (fout == null) return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            fout.close();
            return;
        }
        if (this.storeLocation == null) throw new FileUploadException("Cannot write uploaded file to disk!");
        if (this.storeLocation.renameTo(new File(file))) return;
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(this.storeLocation));
            out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] bytes = new byte[2048];
            int s = 0;
            while ((s = in.read(bytes)) != -1) {
                ((BufferedOutputStream)out).write(bytes, 0, s);
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            try {
                in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                out.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            out.close();
            return;
        }
        catch (Exception e) {}
    }

    public void delete() {
        this.byteStream = null;
        this.content = null;
        if (this.storeLocation != null && this.storeLocation.exists()) {
            this.storeLocation.delete();
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setIsFormField(boolean state) {
        this.isFormField = state;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.storeLocation == null) {
            return this.byteStream;
        }
        return new FileOutputStream(this.storeLocation);
    }

    protected void finalize() {
        if (this.storeLocation != null && this.storeLocation.exists()) {
            this.storeLocation.delete();
        }
    }

    public static FileItem newInstance(String path, String name, String contentType, int requestSize, int threshold) {
        DefaultFileItem item = new DefaultFileItem(name, contentType);
        if (requestSize > threshold) {
            String fileName = DefaultFileItem.getUniqueId();
            fileName = "upload_" + fileName + ".tmp";
            fileName = path + "/" + fileName;
            File f = new File(fileName);
            f.deleteOnExit();
            item.storeLocation = f;
        } else {
            item.byteStream = new ByteArrayOutputStream();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUniqueId() {
        int current;
        Class clazz = class$org$apache$commons$fileupload$DefaultFileItem == null ? (class$org$apache$commons$fileupload$DefaultFileItem = DefaultFileItem.class$("org.apache.commons.fileupload.DefaultFileItem")) : class$org$apache$commons$fileupload$DefaultFileItem;
        synchronized (clazz) {
            current = counter++;
        }
        String id = Integer.toString(current);
        if (current < 100000000) {
            id = ("00000000" + id).substring(id.length());
        }
        return id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

