/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.security;

import java.io.Serializable;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Messages;

public final class NodePermission
implements Serializable,
Cloneable {
    protected String objectUri;
    protected NodeRevisionNumber revisionNumber;
    protected String subjectUri;
    protected String actionUri;
    protected boolean inheritable;
    protected boolean negative;
    static /* synthetic */ Class class$org$apache$slide$security$NodePermission;

    public NodePermission(String objectUri, String subjectUri, String actionUri) {
        if (objectUri != null) {
            this.objectUri = objectUri;
        }
        if (subjectUri != null) {
            this.subjectUri = subjectUri;
        }
        if (actionUri != null) {
            this.actionUri = actionUri;
        }
        this.inheritable = true;
        this.negative = false;
    }

    public NodePermission(String objectUri, String revisionNumber, String subjectUri, String actionUri, boolean inheritable, boolean negative) {
        this(objectUri, subjectUri, actionUri);
        this.inheritable = inheritable;
        if (revisionNumber != null) {
            this.revisionNumber = new NodeRevisionNumber(revisionNumber);
            this.inheritable = false;
        }
        this.negative = negative;
    }

    public NodePermission(String objectUri, String subjectUri, String actionUri, boolean inheritable) {
        this(objectUri, subjectUri, actionUri);
        this.inheritable = inheritable;
    }

    public NodePermission(String objectUri, String subjectUri, String actionUri, boolean inheritable, boolean negative) {
        this(objectUri, subjectUri, actionUri);
        this.inheritable = inheritable;
        this.negative = negative;
    }

    public NodePermission(ObjectNode object, NodeRevisionNumber revisionNumber, SubjectNode subject, ActionNode action, boolean inheritable, boolean negative) {
        this(object, subject, action);
        this.inheritable = inheritable;
        if (revisionNumber != null) {
            this.inheritable = false;
        }
        this.negative = negative;
        this.revisionNumber = revisionNumber;
    }

    public NodePermission(ObjectNode object, SubjectNode subject, ActionNode action) {
        this(object.getUri(), subject.getUri(), action.getUri());
    }

    public NodePermission(ObjectNode object, SubjectNode subject, ActionNode action, boolean inheritable) {
        this(object, subject, action);
        this.inheritable = inheritable;
    }

    public NodePermission(ObjectNode object, SubjectNode subject, ActionNode action, boolean inheritable, boolean negative) {
        this(object, subject, action);
        this.inheritable = inheritable;
        this.negative = negative;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public NodePermission cloneObject() {
        NodePermission result = null;
        try {
            result = (NodePermission)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NodePermission) {
            NodePermission permission = (NodePermission)obj;
            result = this.objectUri.equals(permission.getObjectUri()) && this.subjectUri.equals(permission.getSubjectUri()) && this.actionUri.equals(permission.getActionUri()) && this.isNegative() == permission.isNegative();
        }
        return result;
    }

    public String getActionUri() {
        return this.actionUri;
    }

    public String getObjectUri() {
        return this.objectUri;
    }

    public NodeRevisionNumber getRevisionNumber() {
        return this.revisionNumber;
    }

    public String getSubjectUri() {
        return this.subjectUri;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public boolean isNegative() {
        return this.negative;
    }

    void setAction(String actionUri) {
        this.actionUri = actionUri;
    }

    void setAction(ActionNode action) {
        if (action != null) {
            this.actionUri = action.getUri();
        }
    }

    public void setInheritable(boolean inheritable) {
        this.inheritable = inheritable;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    void setObject(String objectUri) {
        this.objectUri = objectUri;
    }

    void setObject(ObjectNode object) {
        if (object != null) {
            this.objectUri = object.getUri();
        }
    }

    void setRevisionNumber(NodeRevisionNumber revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    void setSubject(String subjectUri) {
        this.subjectUri = subjectUri;
    }

    void setSubject(SubjectNode subject) {
        if (subject != null) {
            this.subjectUri = subject.getUri();
        }
    }

    public String toString() {
        return String.valueOf(this.objectUri) + "-" + this.subjectUri + "-" + this.actionUri + "-" + this.inheritable;
    }

    public void validate(String expectedUri) {
        if (this.objectUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$security$NodePermission != null ? class$org$apache$slide$security$NodePermission : (class$org$apache$slide$security$NodePermission = NodePermission.class$("org.apache.slide.security.NodePermission"))).getName()) + ".nullObjectUri"));
        }
        if (!this.objectUri.equals(expectedUri)) {
            String tmpExpectedUri;
            String tmpObjectUri = this.objectUri;
            if (tmpObjectUri.endsWith("/")) {
                tmpObjectUri = tmpObjectUri.substring(0, tmpObjectUri.length() - 1);
            }
            if ((tmpExpectedUri = expectedUri).endsWith("/")) {
                tmpExpectedUri = tmpExpectedUri.substring(0, tmpExpectedUri.length() - 1);
            }
            if (!tmpObjectUri.equals(tmpExpectedUri)) {
                throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$security$NodePermission != null ? class$org$apache$slide$security$NodePermission : (class$org$apache$slide$security$NodePermission = NodePermission.class$("org.apache.slide.security.NodePermission"))).getName()) + ".incorrectObjectUri"));
            }
        }
        if (this.subjectUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$security$NodePermission != null ? class$org$apache$slide$security$NodePermission : (class$org$apache$slide$security$NodePermission = NodePermission.class$("org.apache.slide.security.NodePermission"))).getName()) + ".nullSubjectUri"));
        }
        if (this.actionUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message(String.valueOf((class$org$apache$slide$security$NodePermission != null ? class$org$apache$slide$security$NodePermission : (class$org$apache$slide$security$NodePermission = NodePermission.class$("org.apache.slide.security.NodePermission"))).getName()) + ".nullActionUri"));
        }
    }
}

