/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.slide.search.BadGatewayException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.QueryScope;
import org.jdom.Element;
import org.jdom.Namespace;

public class BasicQueryScope
implements QueryScope {
    private String href;
    private int depth;
    private boolean isCollection = true;

    public BasicQueryScope(String href) {
        this.href = href;
    }

    public BasicQueryScope(String href, int depth) {
        this.href = href;
        this.depth = depth;
        if (depth != 0 && depth != 1 && depth != Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
    }

    public BasicQueryScope(Element fromElement) throws BadQueryException {
        this.depth = Integer.MAX_VALUE;
        Namespace namespace = fromElement.getNamespace();
        String name = fromElement.getName();
        if (!namespace.getURI().equals("DAV:") || !name.equals("from")) {
            throw new BadQueryException("expected DAV:from");
        }
        Element scope = fromElement.getChild("scope", namespace);
        if (scope.getChildren("href", namespace).size() != 1) {
            throw new BadQueryException("exactly one href element must be defined");
        }
        this.href = scope.getChildTextTrim("href", namespace);
        try {
            URL url = new URL(this.href);
            throw new BadGatewayException(String.valueOf(this.href) + ": Bad Gateway (no server redirection allowed)");
        }
        catch (MalformedURLException malformedURLException) {
            Element depth = scope.getChild("depth", namespace);
            if (depth != null) {
                String d = depth.getTextTrim();
                if (d.equals("0")) {
                    this.depth = 0;
                } else if (d.equals("1")) {
                    this.depth = 1;
                }
            }
            return;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryScope)) {
            return false;
        }
        QueryScope other = (QueryScope)o;
        if (!this.href.equals(other.getHref())) {
            return false;
        }
        return this.depth == other.getDepth();
    }

    public int getDepth() {
        return this.depth;
    }

    public String getHref() {
        return this.href;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public void setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
        if (isCollection && !this.href.endsWith("/")) {
            this.href = String.valueOf(this.href) + "/";
        }
    }

    public String toString() {
        return String.valueOf(this.href) + ", depth = " + this.depth;
    }
}

