/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import org.apache.cactus.AbstractTestCase;
import org.apache.cactus.WebTestResult;
import org.apache.cactus.server.WebImplicitObjects;
import org.apache.cactus.util.log.Log;
import org.apache.cactus.util.log.LogService;

public abstract class AbstractTestCaller {
    private static final String TEST_RESULTS = "ServletTestRedirector_TestResults";
    protected static Log logger = LogService.getInstance().getLog((class$org$apache$cactus$server$AbstractTestCaller == null ? (class$org$apache$cactus$server$AbstractTestCaller = AbstractTestCaller.class$("org.apache.cactus.server.AbstractTestCaller")) : class$org$apache$cactus$server$AbstractTestCaller).getName());
    protected WebImplicitObjects webImplicitObjects;
    static /* synthetic */ Class class$org$apache$cactus$server$AbstractTestCaller;
    static /* synthetic */ Class class$java$lang$String;

    public AbstractTestCaller(WebImplicitObjects theObjects) {
        this.webImplicitObjects = theObjects;
    }

    protected abstract void setTestCaseFields(AbstractTestCase var1) throws Exception;

    public void doTest() throws ServletException {
        logger.entry("doTest()");
        WebTestResult result = null;
        try {
            AbstractTestCase testInstance = this.getTestClassInstance(this.getTestClassName(), this.getTestMethodName());
            this.setTestCaseFields(testInstance);
            testInstance.runBareServerTest();
            result = new WebTestResult();
        }
        catch (Throwable e) {
            result = new WebTestResult(e);
        }
        logger.debug("Test result : [" + result + "]");
        this.webImplicitObjects.getServletContext().setAttribute(TEST_RESULTS, (Object)result);
        logger.debug("Result saved in context scope");
        logger.exit("doTest");
    }

    public void doGetResults() throws ServletException {
        logger.entry("doGetResults()");
        WebTestResult result = (WebTestResult)this.webImplicitObjects.getServletContext().getAttribute(TEST_RESULTS);
        logger.debug("Test Result = [" + result + "]");
        try {
            ServletOutputStream os = this.webImplicitObjects.getHttpServletResponse().getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)os);
            oos.writeObject(result);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            String message = "Error writing WebTestResult instance to output stream";
            logger.error(message, e);
            throw new ServletException(message, (Throwable)e);
        }
        logger.exit("doGetResults");
    }

    protected String getTestClassName() throws ServletException {
        logger.entry("getTestClassName()");
        String className = this.webImplicitObjects.getHttpServletRequest().getParameter("ServletTestRedirector_TestClass");
        if (className == null) {
            String message = "Missing class name parameter [ServletTestRedirector_TestClass] in HTTP request.";
            logger.error(message);
            throw new ServletException(message);
        }
        logger.debug("Class to call = " + className);
        logger.exit("getTestClassName");
        return className;
    }

    protected String getTestMethodName() throws ServletException {
        logger.entry("getTestMethodName()");
        String methodName = this.webImplicitObjects.getHttpServletRequest().getParameter("ServletTestRedirector_TestMethod");
        if (methodName == null) {
            String message = "Missing method name parameter [ServletTestRedirector_TestMethod] in HTTP request.";
            logger.error(message);
            throw new ServletException(message);
        }
        logger.debug("Method to call = " + methodName);
        logger.exit("getTestMethodName");
        return methodName;
    }

    protected boolean isAutoSession() {
        logger.entry("isAutoSession()");
        String autoSession = this.webImplicitObjects.getHttpServletRequest().getParameter("ServletTestRedirector_AutomaticSession");
        boolean isAutomaticSession = new Boolean(autoSession);
        logger.debug("Auto session is " + isAutomaticSession);
        logger.exit("isAutoSession");
        return isAutomaticSession;
    }

    protected AbstractTestCase getTestClassInstance(String theClassName, String theTestCaseName) throws ServletException {
        logger.entry("getTestClassInstance([" + theClassName + "], [" + theTestCaseName + "])");
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer("Classloaders = ");
            ClassLoader classLoader = this.getClass().getClassLoader();
            while (classLoader != null) {
                buffer.append(classLoader.toString());
                classLoader = classLoader.getParent();
                if (classLoader == null) continue;
                buffer.append(", ");
            }
            logger.debug(buffer.toString());
        }
        Class testClass = null;
        AbstractTestCase testInstance = null;
        try {
            testClass = this.getTestClassClass(theClassName);
            Constructor constructor = testClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = AbstractTestCaller.class$("java.lang.String")) : class$java$lang$String);
            testInstance = (AbstractTestCase)((Object)constructor.newInstance(theTestCaseName));
        }
        catch (Exception e) {
            String message = "Error instanciating class [" + theClassName + "(" + theTestCaseName + ")]";
            logger.error(message, e);
            throw new ServletException(message, (Throwable)e);
        }
        logger.exit("getTestClassInstance");
        return testInstance;
    }

    protected Class getTestClassClass(String theClassName) throws ServletException {
        logger.entry("getTestClassClass([" + theClassName + "])");
        Class<?> testClass = null;
        try {
            testClass = Class.forName(theClassName);
        }
        catch (Exception e) {
            String message = "Error finding class [" + theClassName + "] in classpath";
            logger.error(message, e);
            throw new ServletException(message, (Throwable)e);
        }
        logger.exit("getTestClassClass");
        return testClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

