/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import javax.servlet.http.HttpServletRequest;
import org.apache.cactus.WebRequest;
import org.apache.cactus.util.log.Log;
import org.apache.cactus.util.log.LogService;

public class ServletURL {
    public static final String URL_SERVER_NAME_PARAM = "ServletTestCase_URL_Server";
    public static final String URL_CONTEXT_PATH_PARAM = "ServletTestCase_URL_ContextPath";
    public static final String URL_SERVLET_PATH_PARAM = "ServletTestCase_URL_ServletPath";
    public static final String URL_PATH_INFO_PARAM = "ServletTestCase_URL_PathInfo";
    public static final String URL_QUERY_STRING_PARAM = "ServletTestCase_URL_QueryString";
    private String serverName;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private static Log logger = LogService.getInstance().getLog((class$org$apache$cactus$ServletURL == null ? (class$org$apache$cactus$ServletURL = ServletURL.class$("org.apache.cactus.ServletURL")) : class$org$apache$cactus$ServletURL).getName());
    static /* synthetic */ Class class$org$apache$cactus$ServletURL;

    public ServletURL(String theServerName, String theContextPath, String theServletPath, String thePathInfo, String theQueryString) {
        this.serverName = theServerName;
        this.contextPath = theContextPath;
        this.servletPath = theServletPath;
        this.pathInfo = thePathInfo;
        this.queryString = theQueryString;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getHost() {
        int pos;
        String host = this.serverName;
        if (host != null && (pos = host.indexOf(":")) > 0) {
            host = host.substring(0, pos + 1);
        }
        return host;
    }

    public int getPort() {
        int port = -1;
        if (this.serverName != null) {
            int pos = this.serverName.indexOf(":");
            if (pos < 0) {
                return -1;
            }
            try {
                port = Integer.parseInt(this.serverName.substring(pos + 1));
            }
            catch (NumberFormatException e) {
                port = -1;
            }
        }
        return port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPath() {
        String path = this.getContextPath() == null ? "" : this.getContextPath();
        path = path + (this.getServletPath() == null ? "" : this.getServletPath());
        if ((path = path + (this.getPathInfo() == null ? "" : this.getPathInfo())).length() == 0) {
            path = null;
        }
        return path;
    }

    public void saveToRequest(WebRequest theRequest) {
        if (this.getServerName() != null) {
            theRequest.addParameter(URL_SERVER_NAME_PARAM, this.getServerName());
        }
        if (this.getContextPath() != null) {
            theRequest.addParameter(URL_CONTEXT_PATH_PARAM, this.getContextPath());
        }
        if (this.getServletPath() != null) {
            theRequest.addParameter(URL_SERVLET_PATH_PARAM, this.getServletPath());
        }
        if (this.getPathInfo() != null) {
            theRequest.addParameter(URL_PATH_INFO_PARAM, this.getPathInfo());
        }
        if (this.getQueryString() != null) {
            theRequest.addParameter(URL_QUERY_STRING_PARAM, this.getQueryString());
        }
    }

    public static ServletURL loadFromRequest(HttpServletRequest theRequest) {
        logger.entry("loadFromRequest(...)");
        String serverName = theRequest.getParameter(URL_SERVER_NAME_PARAM);
        String contextPath = theRequest.getParameter(URL_CONTEXT_PATH_PARAM);
        String servletPath = theRequest.getParameter(URL_SERVLET_PATH_PARAM);
        String pathInfo = theRequest.getParameter(URL_PATH_INFO_PARAM);
        String queryString = theRequest.getParameter(URL_QUERY_STRING_PARAM);
        ServletURL url = new ServletURL(serverName, contextPath, servletPath, pathInfo, queryString);
        logger.debug("URL = [" + url + "]");
        logger.entry("loadFromRequest(...)");
        return url;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("host name = [" + this.getHost() + "], ");
        buffer.append("port = [" + this.getPort() + "], ");
        buffer.append("context path = [" + this.getContextPath() + "], ");
        buffer.append("servlet path = [" + this.getServletPath() + "], ");
        buffer.append("path info = [" + this.getPathInfo() + "], ");
        buffer.append("query string = [" + this.getQueryString() + "]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

