#!/bin/sh

UPDATE_LIST_FILE=/tmp/jetspeed-japan.txt

pushd target/jetspeed-2
svn status > $UPDATE_LIST_FILE

FILES=`cat $UPDATE_LIST_FILE | grep "M " | sed -e "s/M //"`
if [ ! -z "$FILES" ] ; then
    for file in $FILES ; do
        svn diff $file
        echo "======================================================================"
        echo "Create Patch (y|n)?"
        echo "$file"
        read answer
        case $answer in
            yes | YES | Yes | y | Y)
                mkdir -p `dirname ../../src/patch/$file`;
                svn diff $file > ../../src/patch/$file;;
            *)
                echo "Skipped...";;
        esac
        echo "======================================================================"
    done
fi
popd

echo 
echo "======================================================================"
echo "Updated Files"
echo "======================================================================"
cat $UPDATE_LIST_FILE | grep "M " | sed -e "s/M //"
echo "======================================================================"
echo 
echo "======================================================================"
echo "New Files"
echo "======================================================================"
cat $UPDATE_LIST_FILE | grep "? " | sed -e "s/? //"
echo "======================================================================"
