#!/bin/sh

OLDTMPFILE=/tmp/old_tmp_file.$$
NEWTMPFILE=/tmp/new_tmp_file.$$

TARGET_DIR=$1
BASE_LIST=""

unusedmessage() {
    cat $1 | sed -e 's/\#.*//g' | grep "=" | sed -e 's/\(.\)=.*$/\1/g'| sort > $OLDTMPFILE
    cat $2 | sed -e 's/\#.*//g' | grep "=" | sed -e 's/\(.\)=.*$/\1/g'| sort > $NEWTMPFILE

#    diff $OLDTMPFILE $NEWTMPFILE |grep ">"
    diff $OLDTMPFILE $NEWTMPFILE |grep ">" | wc -l
    rm $OLDTMPFILE $NEWTMPFILE
}

newmessage() {
    cat $1 | sed -e 's/\#.*//g' | grep "=" | sed -e 's/\(.\)=.*$/\1/g'| sort > $OLDTMPFILE
    cat $2 | sed -e 's/\#.*//g' | grep "=" | sed -e 's/\(.\)=.*$/\1/g'| sort > $NEWTMPFILE

#    diff $OLDTMPFILE $NEWTMPFILE |grep "<"
    diff $OLDTMPFILE $NEWTMPFILE |grep "<" | wc -l
    rm $OLDTMPFILE $NEWTMPFILE
}

for file in `find $TARGET_DIR -type f | grep -v CVS | grep '\.properties'` ; do
    FLAG=`echo $file | sed -e 's|.*[^/]*_.*\.properties|LANG|'`
    if [ "$FLAG" != "LANG" ] ; then
        L10N_BASE_NAME=`echo $file | sed -e "s|\(.*[^/]*\)\(\.properties\)|\1|"`
        ls $L10N_BASE_NAME\_*.properties 1> /dev/null 2> /dev/null

        if [ "$?" == "0" ] ; then
            BASE_LIST="$BASE_LIST $L10N_BASE_NAME"
        fi
    fi
done

echo "TRANSLATABLE MESSAGE FILE:"
for l10nbasename in $BASE_LIST ; do
    echo " ${l10nbasename}_en.properties"
done

echo 
echo 
echo "#NewMessage:    The number of a new message."
echo "#UnusedMessage: The number of a message which is not included"
echo "                in the target *_en.properties file. So, the message"
echo "                may be not used."
echo 

for l10nbasename in $BASE_LIST ; do
    echo "PROPERTIES: $l10nbasename.properties"
    ls $l10nbasename\_en.properties 1> /dev/null 2> /dev/null
    EXIST=$?

    if [ "$EXIST" == "1" ] ; then
        echo "    English properties does not exist."
    fi

    if [ "$EXIST" == "0" ] ; then
        echo "Locale  #NewMessage     #UnusedMessage"

        for l10nfile in `ls $l10nbasename\_*.properties` ; do
            L=`echo $l10nfile | sed -e 's|.*[^/]*_\(.*\)\.properties|\1|'`
            NWORD=`newmessage $l10nbasename\_en.properties $l10nfile`
            UWORD=`unusedmessage $l10nbasename\_en.properties $l10nfile`
            #    "Locale  #NewMessage     #UnusedMessage"
            echo "$L          $NWORD                $UWORD"
        done
    fi

    echo
done

