<?php

/**
 * フロントコントローラ
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */

// ファイルのインクルード
///*{{{*/
require_once("./config.php");
require_once("./function.php");
require_once("../_smarty/Smarty.class.php");
///*}}}*/

// デバッグ関連
///*{{{*/
ini_set("display_errors", DISPLAY_ERRORS);
error_reporting(E_ALL ^ E_NOTICE);
///*}}}*/

// セッション開始＋セキュリティ対策
///*{{{*/
ini_set("session.use_only_cookies", 1);
session_start();
session_regenerate_id(TRUE);
///*}}}*/

// 下準備
///*{{{*/
$smarty = new Smarty();
$logger = new ClassLogger();
///*}}}*/

// アクセスログ
///*{{{*/
$logger->logAccess($_SERVER['REQUEST_URI']);
///*}}}*/

// メンテナンス
///*{{{*/
if (MODE_MAINTENANCE) {
    $smarty->assign("errorMsg", MSG_MAINTENANCE);
    $smarty->display("error.html");
    exit;
}
///*}}}*/

// コントローラ、コンフィグ定義
///*{{{*/
$url = mb_ereg_replace("\/$", "", $_SERVER['REQUEST_URI']);
$arrUrl = mb_split("/", $url);
$controller = (count($arrUrl) > 0) ? $arrUrl[1] : null;
if (($controller === "") || (is_null($controller))) {
    $controller = "index";
}
if ($controller === "src") {
    $smarty->assign("errorMsg", MSG_PAGE_NOT_FOUND);
    $smarty->display("error.html");
    exit;
}
$config = sprintf("../%s/config.php", $controller);
$controller = sprintf("../%s/index.php", $controller);
if (!file_exists($controller)) {
    $smarty->assign("errorMsg", MSG_PAGE_NOT_FOUND);
    $smarty->display("error.html");
    exit;
}
///*}}}*/

// パラメータ取得
///*{{{*/
$_PARAM = array();
for ($i = 2; $i < count($arrUrl); $i += 2) {
    $_PARAM[$arrUrl[$i]] = (count($arrUrl) > ($i + 1)) ? $arrUrl[$i + 1] : null;
}
///*}}}*/

// コンフィグ読込み
///*{{{*/
if (file_exists($config)) {
    require_once($config);
}
///*}}}*/

// コントローラ呼出し
///*{{{*/
require_once($controller);
///*}}}*/

