<?php

/**
 * モデル（実装例）
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */


class ClassModelExample extends ClassBase
{
    // ● メンバー変数
    ///*{{{*/
    public $validator = null;
    public $logger = null;
    public $smarty = null;
    public $db = null;
    public $arrField = array();
    ///*}}}*/

    // ● コンストラクタ
    public function __construct()/*{{{*/
    {
        parent::__construct();
        $this->validator = new ClassValidator();
        $this->logger = new ClassLogger();
        $this->smarty = new Smarty();
        $this->arrField = $this->getField();
        try {
            $this->db = new ClassDB();
        } catch (Exception $e) {
            $this->logger->logError($e->getMessage());
            $this->smarty->display(FILE_EXCEPTION);
            exit;
        }
    }/*}}}*/

    // ● フィールド登録
    public function getField()/*{{{*/
    {
        $arr = array();
        $arr[] = "name";
        $arr[] = "prefecture";
        $arr[] = "yyyy";
        $arr[] = "mm";
        $arr[] = "dd";
        return $arr;
    }/*}}}*/

    // ● メンバーの存在確認
    public function isMember($no)/*{{{*/
    {
        try {
            $sql = sprintf("SELECT COUNT(*) as cnt FROM example WHERE no = '%s'", $this->db->quote($no));
            $this->db->q($sql);
            $result = $this->db->f();
            if ($result['cnt']) {
                return TRUE;
            } else {
                return FALSE;
            }
        } catch (Exception $e) {
            $this->logger->logError($e->getMessage());
            $this->smarty->display(FILE_EXCEPTION);
            exit;
        }
    }/*}}}*/

    // ● メンバーの情報を取得する
    public function getMember($no = null)/*{{{*/
    {
        try {
            if (is_null($no)) {
                $sql = "SELECT * FROM example";
                $this->db->q($sql);
                return $this->db->fa();
            } else {
                $sql = sprintf("SELECT * FROM example WHERE no = '%s'", $this->db->quote($no));
                $this->db->q($sql);
                return $this->db->f();
            }
        } catch (Exception $e) {
            $this->logger->logError($e->getMessage());
            $this->smarty->display(FILE_EXCEPTION);
            exit;
        }
    }/*}}}*/

    // ● 未入力チェック
    public function chkEmpty(&$session)/*{{{*/
    {
        if (!$this->validator->chkS($session->name)) {
            return ERROR_INSERT_NAME_EMPTY;
        }
        if (!$this->validator->chkR($session->yyyy)) {
            return ERROR_INSERT_YYYY_EMPTY;
        }
        if (!$this->validator->chkR($session->mm)) {
            return ERROR_INSERT_MM_EMPTY;
        }
        if (!$this->validator->chkR($session->dd)) {
            return ERROR_INSERT_DD_EMPTY;
        }
        if ($session->prefecture == 0) {
            return ERROR_INSERT_PREFECTURE_EMPTY;
        }
        return "";
    }/*}}}*/

    // ● 妥当性チェック
    public function chkInvalid(&$session)/*{{{*/
    {
        if (!@checkdate($session->mm, $session->dd, $session->yyyy)) {
            return ERROR_INSERT_BIRTH_INVALID;
        }
        if ((date("Y") < $session->yyyy)
                || ((date("Y") == $session->yyyy) && (date("m") < $session->mm))
                || ((date("Y") == $session->yyyy) && (date("m") == $session->mm) && (date("d") < $session->dd))) {
            return ERROR_INSERT_BIRTH_INVALID;
        }
        $arr = mb_split(DELIMITER, PREFECTURE);
        if ((!$this->validator->chkN($session->prefecture))
                || ($session->prefecture < 0)
                || ($session->prefecture > count($arr))) {
            return ERROR_ISERT_PREFECTURE_INVALID;
        }
        return "";
    }/*}}}*/

    // ● 新規作成
    public function insertMember($session)/*{{{*/
    {
        try {
            $arr = array();
            $arrSession = $session->getAll();
            for ($i = 0; $i < count($this->arrField); $i++) {
                $fieldName = $this->arrField[$i];
                $arr[$fieldName] = $arrSession[$fieldName];
            }
            $arr['time_insert'] = date("Y-m-d H:i:s");
            $arr['time_update'] = $arr['time_insert'];
            $this->db->i("example", $arr);
        } catch (Exception $e) {
            $this->logger->logError($e->getMessage());
            $this->smarty->display(FILE_EXCEPTION);
            exit;
        }
    }/*}}}*/

    // ● 更新
    public function updateMember($session, $no)/*{{{*/
    {
        try {
            $sql = "UPDATE example SET ";
            $arrSession = $session->getAll();
            for ($i = 0; $i < count($this->arrField); $i++) {
                $fieldName = $this->arrField[$i];
                $sql .= sprintf("%s = '%s', ",
                                $fieldName,
                                $this->db->quote($arrSession[$fieldName]));
            }
            $sql .= sprintf("time_update = '%s' ", date("Y-m-d H:i:s"));
            $sql .= sprintf("WHERE no = '%s'", $this->db->quote($no));
            $this->db->q($sql);
        } catch (Exception $e) {
            $this->logger->logError($e->getMessage());
            $this->smarty->display(FILE_EXCEPTION);
            exit;
        }
    }/*}}}*/

    // ● 削除
    public function deleteMember($no)/*{{{*/
    {
        try {
            $sql = sprintf("DELETE FROM example WHERE no = '%s'", $this->db->quote($no));
            $this->db->q($sql);
        } catch (Exception $e) {
            $this->logger->logError($e->getMessage());
            $this->smarty->display(FILE_EXCEPTION);
            exit;
        }
    }/*}}}*/
}

