<?php

/**
 * PostgreSQL用クラス
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */

class ClassPostgresql implements InterfaceDB
{
    // ● メンバー変数
    ///*{{{*/
    // ホスト名
    public $host = DB_HOST;
    // ユーザ名
    public $user = DB_USER;
    // パスワード
    public $pass = DB_PASS;
    // ＤＢ名
    public $database = DB_DATABASE;
    // ＤＢリンクリソース
    public $db = FALSE;
    // クエリリソース
    public $rs = FALSE;
    ///*}}}*/
    
    // ● コンストラクタ
    public function __construct() {/*{{{*/
        $this->s();
        $this->q(sprintf("SET client_encoding = '%s'", CLIENT_ENCODING));
    }/*}}}*/

    // ● ＤＢ接続
    public function s()/*{{{*/
    {
        $strMsg = sprintf("host=%s dbname=%s user=%s password=%s", $this->host, $this->database, $this->user, $this->pass);
        if ($this->db = @pg_connect($strMsg)) {
            return TRUE;
        } else {
            throw new Exception(EXCEPTION_CONNECT_DB);
        }
    }/*}}}*/
    
    // ● ＤＢ切断
    public function e()/*{{{*/
    {
        @pg_close($this->db);
    }/*}}}*/
    
    // ● クエリ発行
    public function q($sql)/*{{{*/
    {
        $this->rs = @pg_query($this->db, $sql);
        if ($this->rs == FALSE) {
            throw new Exception(sprintf("%s : %s", EXCEPTION_INVALID_QUERY, $sql));
        } else {
            return TRUE;
        }
    }/*}}}*/

    // ● フェッチメソッド
    public function f()/*{{{*/
    {
        return @pg_fetch_array($this->rs, null, PGSQL_ASSOC);
    }/*}}}*/

    // ● フェッチメソッド（レコード数を返す）
    public function fn()/*{{{*/
    {
        return @pg_num_rows($this->rs);
    }/*}}}*/

    // ● フェッチメソッド（すべてのデータを配列で返す）
    public function fa()/*{{{*/
    {
        $arr = array();
        $i = 0;
        while ($row = @pg_fetch_array($this->rs, null, PGSQL_ASSOC)) {
            foreach($row as $key => $value) {
                $arr[$i][$key] = $value;
            }
            $i++;
        }
        return $arr;
    }/*}}}*/

    // ● 完全一致するレコードを返す
    public function r($tableName, $arrChkField)/*{{{*/
    {
        foreach ($arrChkField as $varName => $varValue) {
            if (!is_null($varValue)) {
                $arrChkField[$varName] = pg_escape_string($varValue);
            }
        }
        $sql = sprintf("SELECT * FROM %s WHERE ", $tableName);
        $flgAnd = FALSE;
        foreach ($arrChkField as $varName => $varValue) {
            if ($flgAnd) {
                $sql .= " AND ";
            }
            if (is_null($varValue)) {
                $sql .= sprintf(" %s IS NULL ", $varName);
            } else {
                $sql .= sprintf(" %s = '%s' ", $varName, $varValue);
            }
            $flgAnd = TRUE;
        }
        if (($rs = @pg_query($this->db, $sql)) == FALSE) {
            return FALSE;
        }
        while (($rs != FALSE) && ($arrRec = @pg_fetch_array($rs, null, PGSQL_ASSOC))) {
            $cntSame = 0;
            foreach ($arrChkField as $varName => $varValue) {
                if (!strcmp($arrRec[$varName], $varValue)) {
                    $cntSame++;
                }
            }
            if ($cntSame == count($arrChkField)) {
                return $arrRec;
            }
        }
        return FALSE;
    }/*}}}*/
    
    // ● 書込み
    public function i($tableName, $arrInsert)/*{{{*/
    {
        foreach ($arrInsert as $varName => $varValue) {
            if (!is_null($varValue)) {
                $arrInsert[$varName] = pg_escape_string($varValue);
            }
        }
        $sqlHead = "";
        $sqlTail = "";
        $flgC = FALSE;
        foreach ($arrInsert as $varName => $varValue) {
            if ($flgC) {
                $sqlHead .= ", ";
                $sqlTail .= ", ";
            }
            $sqlHead .= $varName;
            if (is_null($varValue)) {
                $sqlTail .= "NULL";
            } else {
                $sqlTail .= sprintf("'%s'", $varValue);
            }
            $flgC = TRUE;
        }
        $sql = sprintf("INSERT INTO %s (%s) VALUES (%s)", $tableName, $sqlHead, $sqlTail);
        $this->q($sql);
    }/*}}}*/
    
    // ● サニタイズ
    public function quote($str)/*{{{*/
    {
        return pg_escape_string($str);
    }/*}}}*/
}

