<?php

/**
 * DBクラス
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */

class ClassDB implements InterfaceDB
{
    // ● メンバー変数
    ///*{{{*/
    public $dbType = DB_TYPE;
    public $db = FALSE;
    ///*}}}*/

    // ● コンストラクタ
    public function __construct()/*{{{*/
    {
        switch ($this->dbType) {
        case "mysql" :
            $this->db = new ClassMysql();
            break;
        case "postgresql" :
            $this->db = new ClassPostgresql();
            break;
        default :
            break;
        }
    }/*}}}*/

    // ● クエリ発行
    public function q($sql)/*{{{*/
    {
        return $this->db->q($sql);
    }/*}}}*/

    // ● フェッチメソッド
    public function f()/*{{{*/
    {
        return $this->db->f();
    }/*}}}*/
    
    // ● フェッチメソッド（レコード数を返す）
    public function fn()/*{{{*/
    {
        return $this->db->fn();
    }/*}}}*/

    // ● フェッチメソッド（すべてのデータを配列で返す）
    public function fa()/*{{{*/
    {
        return $this->db->fa();
    }/*}}}*/

    // ● 完全一致するレコードを返す
    public function r($tableName, $arrChkField)/*{{{*/
    {
        return $this->db->r($tableName, $arrChkField);
    }/*}}}*/

    // ● 書込み
    public function i($tableName, $arrInsert)/*{{{*/
    {
        return $this->db->i($tableName, $arrInsert);
    }/*}}}*/

    // ● サニタイズ
    public function quote($str)/*{{{*/
    {
        return $this->db->quote($str);
    }/*}}}*/
}

