#region Using Xe[gg

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

#endregion

namespace DebugSample
{
    /// <summary>
    /// FPS̑ƕ\pR|[lg
    /// </summary>
    public class FpsCounter : DrawableGameComponent
    {
        #region vpeB

        /// <summary>
        /// ݂FPSl
        /// </summary>
        public float Fps { get; private set; }

        /// <summary>
        /// FPSԊȕƐݒ
        /// </summary>
        public TimeSpan SampleSpan { get; set; }

        #endregion

        #region tB[h

        // fobO}l[W[
        private DebugManager debugManager;

        // p̃XgbvEHb`
        private Stopwatch stopwatch;

        // 蒆̃t[
        private int sampleFrames;

        // FPS\p̕obt@
        private StringBuilder stringBuilder = new StringBuilder( 16 );

        #endregion

        #region 

        public FpsCounter( Game game )
            : base( game )
        {
            SampleSpan = TimeSpan.FromSeconds( 1 );
        }

        public override void Initialize()
        {
            // fobO}l[W[Q[̃T[rX擾
            debugManager =
                Game.Services.GetService( typeof( DebugManager ) ) as DebugManager;

            if ( debugManager == null )
                throw new InvalidOperationException( "DebugManaero^Ă܂" );

            // fobOR}hT[rXɓo^ĂȂAFPSR}ho^
            IDebugCommandHost host =
                                Game.Services.GetService( typeof(IDebugCommandHost) )
                                                                as IDebugCommandHost;

            if ( host != null )
            {
                host.RegisterCommand( "fps", "FPS Counter", this.CommandExecute );
                Visible = false;
            }

            // p[^[̏
            Fps = 0;
            sampleFrames = 0;
            stopwatch = Stopwatch.StartNew();
            stringBuilder.Length = 0;

            base.Initialize();
        }

        #endregion

        /// <summary>
        /// FPSR}h
        /// </summary>
        private void CommandExecute( IDebugCommandHost host,
                                    string command, IList<string> arguments )
        {
            if ( arguments.Count == 0 )
                Visible = !Visible;

            foreach ( string arg in arguments )
            {
                switch ( arg.ToLower() )
                {
                case "on":
                    Visible = true;
                    break;
                case "off":
                    Visible = false;
                    break;
                }
            }
        }

        #region XVƕ`

        public override void Update( GameTime gameTime )
        {
            if ( stopwatch.Elapsed > SampleSpan )
            {
                // FPS̍XVƎ̑Ԃ̊Jn
                Fps = (float)sampleFrames / (float)stopwatch.Elapsed.TotalSeconds;

                stopwatch.Reset();
                stopwatch.Start();
                sampleFrames = 0;

                // \̍XV
                stringBuilder.Length = 0;
                stringBuilder.Append( "FPS: " );
                stringBuilder.AppendNumber( Fps );
            }
        }

        public override void Draw( GameTime gameTime )
        {
            sampleFrames++;

            SpriteBatch spriteBatch = debugManager.SpriteBatch;
            SpriteFont font = debugManager.DebugFont;

            // FPS\̎ɔ̍`̃TCYvZƔzu
            Vector2 size = font.MeasureString( "X" );
            Rectangle rc =
                new Rectangle( 0, 0, (int)( size.X * 14f ), (int)( size.Y * 1.3f ) );

            Layout layout = new Layout( spriteBatch.GraphicsDevice.Viewport );
            rc = layout.Place( rc, 0.01f, 0.01f, Alignment.TopLeft );

            // FPS\`̒Ŕzu
            size = font.MeasureString( stringBuilder );
            layout.ClientArea = rc;
            Vector2 pos = layout.Place( size, 0, 0.1f, Alignment.Center );

            // `
            spriteBatch.Begin();
            spriteBatch.Draw( debugManager.WhiteTexture, rc, new Color( 0, 0, 0, 128 ) );
            spriteBatch.DrawString( font, stringBuilder, pos, Color.White );
            spriteBatch.End();

            base.Draw( gameTime );
        }

        #endregion

    }
}
