#region Using Xe[gg

using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;

#endregion

namespace DebugSample
{
    /// <summary>
    /// fobOpR}hEBhENX
    /// </summary>
    /// <remarks>
    /// Q[œ삷fobNR}hEBhEUI
    /// L[{[h͂ɂăR}h́As邱ƂłB
    /// Xbox 360łUSBL[{[hڑ邱Ƃœ\B
    /// 
    /// gp@:
    /// 1)̃R|[lgQ[ɒǉB
    /// 2)RegisterCommand\bhgăR}ho^
    /// 3)TabL[ŃfobOEBhE̊JR}h
    /// </remarks>
    public class DebugCommandUI : DrawableGameComponent, IDebugCommandHost
    {
        #region 萔錾

        /// <summary>
        /// ős
        /// </summary>
        const int MaxLineCount = 20;

        /// <summary>
        /// R}hqXg
        /// </summary>
        const int MaxCommandHistory = 32;

        /// <summary>
        /// R}hvvg
        /// </summary>
        const string Prompt = "CMD>";

        /// <summary>
        /// J[\BłUnicodeBlock EleemntsJ[\ۂ̂gp
        /// http://www.unicode.org/charts/PDF/U2580.pdf
        /// </summary>
        const string Cursor = "\u2582";

        #endregion

        #region vpeB

        /// <summary>
        /// L[͑ҋ@Ԃ
        /// </summary>
        public bool Focused { get { return state != State.Closed; } }

        #endregion

        #region tB[h

        // R}hEBhẼXe[g
        enum State
        {
            Closed,     // Ă
            Opening,    // JĂr
            Opened,     // JĂ(R}h͑ҋ@)
            Closing     // Ăr
        }

        /// <summary>
        /// R}hspi[p̃NX
        /// </summary>
        class CommandInfo
        {
            public CommandInfo(
                string command, string description, DebugCommandExecute callback )
            {
                this.command = command;
                this.description = description;
                this.callback = callback;
            }

            // R}h
            public string command;

            // R}hڍ
            public string description;

            // R}hsp̃fQ[g
            public DebugCommandExecute callback;
        }

        // fobO}l[W[ւ̎Q
        private DebugManager debugManager;

        // ݂̃Xe[g
        private State state = State.Closed;

        // Xe[gڍsp̃^C}[
        private float stateTransition;

        // o^ĂEchoXi[
        List<IDebugEchoListner> listenrs = new List<IDebugEchoListner>();

        // o^ĂR}h
        private Dictionary<string, CommandInfo> commandTable =
                                                new Dictionary<string, CommandInfo>();

        // ݓ͒̃R}hCƁAJ[\ʒu
        private string commandLine = String.Empty;
        private int cursorIndex = 0;

        // R}hC\
        private Queue<string> lines = new Queue<string>();

        // R}hpobt@
        private List<string> commandHistory = new List<string>();

        // ݑIĂ闚CfbNX
        private int commandHistoryIndex;

        #region L[{[h͏p̕ϐQ

        //@Ot[̃L[{[hXe[g
        private KeyboardState prevKeyState;

        //@ŌɉꂽL[
        private Keys pressedKey;

        //@L[s[g^C}[
        private float keyRepeatTimer;

        // ŏ̃L[̃s[g(b)
        private float keyRepeatStartDuration = 0.3f;

        // Qڈȍ~̃L[s[g(b)
        private float keyRepeatDuration = 0.03f;

        #endregion

        #endregion

        #region 

        /// <summary>
        /// RXgN^
        /// </summary>
        public DebugCommandUI( Game game )
            : base( game )
        {
            // T[rXƂĒǉ
            Game.Services.AddService( typeof( IDebugCommandHost ), this );


            // {R}h̒ǉ

            // wvR}h
            // o^ĂR}h̕\
            RegisterCommand( "help", "Show Command helps",
            delegate( IDebugCommandHost host, string command, IList<string> args )
            {
                int maxLen = 0;
                foreach ( CommandInfo cmd in commandTable.Values )
                    maxLen = Math.Max( maxLen, cmd.command.Length );

                string fmt = String.Format( "{{0,-{0}}}    {{1}}", maxLen );

                foreach ( CommandInfo cmd in commandTable.Values )
                {
                    Echo( String.Format( fmt, cmd.command, cmd.description ) );
                }
            } );

            // NAXN[
            // R}hʃNA
            RegisterCommand( "cls", "Clear Screen",
            delegate( IDebugCommandHost host, string command, IList<string> args )
            {
                lines.Clear();
            } );

            // EchoR}h
            RegisterCommand( "echo", "Display Messages",
            delegate( IDebugCommandHost host, string command, IList<string> args )
            {
                Echo( command.Substring( 5 ) );
            } );
        }

        /// <summary>
        /// R|[lg̏
        /// </summary>
        public override void Initialize()
        {
            debugManager =
                Game.Services.GetService( typeof( DebugManager ) ) as DebugManager;

            if ( debugManager == null )
                throw new InvalidOperationException( "DebugManager܂B" );

            base.Initialize();
        }

        #endregion

        #region IDebugCommandHostC^[tF[X̎

        public void RegisterCommand(
            string command, string description, DebugCommandExecute callback )
        {
            string lowerCommand = command.ToLower();
            if ( commandTable.ContainsKey( lowerCommand ) )
            {
                throw new InvalidOperationException(
                    String.Format( "{0}͊ɓo^Ă܂", command ) );
            }

            commandTable.Add(
                lowerCommand, new CommandInfo( command, description, callback ) );
        }

        public void UnregisterCommand( string command )
        {
            string lowerCommand = command.ToLower();
            if ( !commandTable.ContainsKey( lowerCommand ) )
            {
                throw new InvalidOperationException(
                    String.Format( "{0}͓o^Ă܂", command ) );
            }

            commandTable.Remove( command );
        }

        public void ExecuteCommand( string command )
        {
            // R}h̎s
            char[] spaceChars = new char[] { ' ' };

            Echo( Prompt + command );

            command = command.TrimStart( spaceChars );

            List<string> args = new List<string>( command.Split( spaceChars ) );
            string cmdText = args[0];
            args.RemoveAt( 0 );

            CommandInfo cmd;
            if ( commandTable.TryGetValue( cmdText.ToLower(), out cmd ) )
            {
                try
                {
                    // o^ĂR}h̃fQ[gĂяo
                    cmd.callback( this, command, args );
                }
                catch ( Exception e )
                {
                    // OR}hsɔ
                    EchoError( "Unhandled Exception occured" );

                    string[] lines = e.Message.Split( new char[]{ '\n' } );
                    foreach ( string line in lines )
                        EchoError( line );
                }
            }
            else
            {
                Echo( "Unknown Command" );
            }

            // R}hqXgɒǉ
            commandHistory.Add( command );
            while ( commandHistory.Count > MaxCommandHistory )
                commandHistory.RemoveAt( 0 );

            commandHistoryIndex = commandHistory.Count;
        }

        public void RegisterEchoListner( IDebugEchoListner listner )
        {
            listenrs.Add( listner );
        }

        public void UnregisterEchoListner( IDebugEchoListner listner )
        {
            listenrs.Remove( listner );
        }

        public void Echo( DebugCommandMessage messageType, string text )
        {
            lines.Enqueue( text );
            while ( lines.Count >= MaxLineCount )
                lines.Dequeue();

            // o^Ă郊Xi[Ăяo
            foreach ( IDebugEchoListner listner in listenrs )
                listner.Echo( messageType, text );
        }

        public void Echo( string text )
        {
            Echo( DebugCommandMessage.Standard, text );
        }

        public void EchoWarning( string text )
        {
            Echo( DebugCommandMessage.Warning, text );
        }

        public void EchoError( string text )
        {
            Echo( DebugCommandMessage.Error, text );
        }

        #endregion

        #region XVƕ`

        public override void Update( GameTime gameTime )
        {
            KeyboardState keyState = Keyboard.GetState();

            float dt = (float)gameTime.ElapsedGameTime.TotalSeconds;
            const float OpenSpeed = 8.0f;
            const float CloseSpeed = 8.0f;

            switch ( state )
            {
            case State.Closed:
                if ( keyState.IsKeyDown( Keys.Tab ) )
                    state = State.Opening;
                break;
            case State.Opening:
                stateTransition += dt * OpenSpeed;
                if ( stateTransition > 1.0f )
                {
                    stateTransition = 1.0f;
                    state = State.Opened;
                }
                break;
            case State.Opened:
                ProcessKeyInputs( dt );
                break;
            case State.Closing:
                stateTransition -= dt * CloseSpeed;
                if ( stateTransition < 0.0f )
                {
                    stateTransition = 0.0f;
                    state = State.Closed;
                }
                break;
            }

            prevKeyState = keyState;

            base.Update( gameTime );
        }

        /// <summary>
        /// L[͏
        /// </summary>
        /// <param name="dt"></param>
        public void ProcessKeyInputs( float dt )
        {
            KeyboardState keyState = Keyboard.GetState();
            Keys[] keys = keyState.GetPressedKeys();

            bool shift = keyState.IsKeyDown( Keys.LeftShift ) ||
                            keyState.IsKeyDown( Keys.RightShift );

            foreach ( Keys key in keys )
            {
                if ( !IsKeyPressed( key, dt ) ) continue;

                char ch;
                if ( KeyboardUtils.KeyToString( key, shift, out ch ) )
                {
                    // ʏ핶̓
                    commandLine = commandLine.Insert( cursorIndex, new string( ch, 1 ) );
                    cursorIndex++;
                }
                else
                {
                    switch ( key )
                    {
                    case Keys.Back:
                        if ( cursorIndex > 0 )
                            commandLine = commandLine.Remove( --cursorIndex, 1 );
                        break;
                    case Keys.Delete:
                        if ( cursorIndex < commandLine.Length )
                            commandLine = commandLine.Remove( cursorIndex, 1 );
                        break;
                    case Keys.Left:
                        if ( cursorIndex > 0 )
                            cursorIndex--;
                        break;
                    case Keys.Right:
                        if ( cursorIndex < commandLine.Length )
                            cursorIndex++;
                        break;
                    case Keys.Enter:
                        // R}h̎s
                        ExecuteCommand( commandLine );
                        commandLine = string.Empty;
                        cursorIndex = 0;
                        break;
                    case Keys.Up:
                        // qXg\
                        if ( commandHistory.Count > 0 )
                        {
                            commandHistoryIndex =
                                Math.Max( 0, commandHistoryIndex - 1 );

                            commandLine = commandHistory[commandHistoryIndex];
                            cursorIndex = commandLine.Length;
                        }
                        break;
                    case Keys.Down:
                        // qXg\
                        if ( commandHistory.Count > 0 )
                        {
                            commandHistoryIndex = Math.Min( commandHistory.Count - 1,
                                                            commandHistoryIndex + 1 );
                            commandLine = commandHistory[commandHistoryIndex];
                            cursorIndex = commandLine.Length;
                        }
                        break;
                    case Keys.Tab:
                        state = State.Closing;
                        break;
                    }
                }
            }

        }

        /// <summary>
        /// L[s[gtL[`FbN
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        bool IsKeyPressed( Keys key, float dt )
        {
            // Ot[ŃL[ĂȂ΁AL[ĂƔ
            if ( prevKeyState.IsKeyUp( key ) )
            {
                keyRepeatTimer = keyRepeatStartDuration;
                pressedKey = key;
                return true;
            }

            // Ot[ŃL[Ăꍇ̓s[g
            if ( key == pressedKey )
            {
                keyRepeatTimer -= dt;
                if ( keyRepeatTimer <= 0.0f )
                {
                    keyRepeatTimer += keyRepeatDuration;
                    return true;
                }
            }

            return false;
        }

        public override void Draw( GameTime gameTime )
        {
            // R}hEBhESɕĂꍇ͕`揈Ȃ
            if ( state == State.Closed )
                return;

            SpriteFont font = debugManager.DebugFont;
            SpriteBatch spriteBatch = debugManager.SpriteBatch;
            Texture2D whiteTexture = debugManager.WhiteTexture;

            // R}hEBhẼTCYvZƕ`
            float w = GraphicsDevice.Viewport.Width;
            float h = GraphicsDevice.Viewport.Height;
            float topMargin = h * 0.1f;
            float leftMargin = w * 0.1f;

            Rectangle rect = new Rectangle();
            rect.X = (int)leftMargin;
            rect.Y = (int)topMargin;
            rect.Width = (int)( w * 0.8f );
            rect.Height = (int)( MaxLineCount * font.LineSpacing );

            Matrix mtx = Matrix.CreateTranslation(
                        new Vector3( 0, -rect.Height * ( 1.0f - stateTransition ), 0 ) );

            spriteBatch.Begin( SpriteBlendMode.AlphaBlend, SpriteSortMode.Immediate,
                                SaveStateMode.SaveState, mtx );

            spriteBatch.Draw( whiteTexture, rect, new Color( 0, 0, 0, 200 ) );

            // ̕`
            Vector2 pos = new Vector2( leftMargin, topMargin );
            foreach ( string line in lines )
            {
                spriteBatch.DrawString( font, line, pos, Color.White );
                pos.Y += font.LineSpacing;
            }

            // vvg̕`
            string leftPart = Prompt + commandLine.Substring( 0, cursorIndex );
            Vector2 cursorPos = pos + font.MeasureString( leftPart );
            cursorPos.Y = pos.Y;

            spriteBatch.DrawString( font,
                String.Format( "{0}{1}", Prompt, commandLine ), pos, Color.White );
            spriteBatch.DrawString( font, Cursor, cursorPos, Color.White );

            spriteBatch.End();
        }

        #endregion

    }
}
