﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace GroundImporter
{
    /// <summary>
    /// ヘイトマップ算出後オブジェクト
    /// </summary>
    public struct HeightMapSetter
    {
        /// <summary>画像の最大値2048に対応するための、x と z に乗算される値 xが0、zが１</summary>       
        public float[] SetedFact;

        /// <summary>上記SetedFactをベクトルにした場合の長さ</summary>
        public float SetedfactLength;

        /// <summary>元画像の各種最大値</summary>
        public float[] P_pos;

        /// <summary>画像から作成したHeightMap </summary>
        public float[][] HeightMap;


        /// <summary>
        /// 立ち位置(X,Y､Z）のポリゴンの高さを取得する。
        /// </summary>
        /// <param name="_Pos"></param>
        /// <param name="hitflg"></param>
        /// <param name="FastFlg"></param>
        /// <returns></returns>
        public float GetLandHeight(ref Vector3 _Pos)
        {
            float refF = 0;

            float tmp_a1, tmp_a2;

            //取得
            {
                //ワールド座標を、画像の座標に直すための式       
                float Inpos_toBmp_x = (_Pos.X - P_pos[(int)Ground_Pos_ID.X_min]) * SetedFact[0];
                float Inpos_toBmp_z = (_Pos.Z - P_pos[(int)Ground_Pos_ID.Z_min]) * SetedFact[1];

                //取得したいのは配列のIndexのため、整数化
                int tgtIndex_X = (int)Math.Floor(Inpos_toBmp_x);
                int tgtIndex_Z = (int)Math.Floor(Inpos_toBmp_z);

                //配列からオーバーしていたら、取得不可能
                if (tgtIndex_X <= 1 || tgtIndex_X >= HeightMap[0].Length - 1 ||
                    tgtIndex_Z <= 1 || tgtIndex_Z >= HeightMap.Length - 1)
                {
                    //hitflg = true;
                    return refF;
                }


                //取得

                //この fct_z,およびｘは、「隣の配列まで、あとどのくらいだったか」の値。
                //この数値を利用して、2つの配列数値で線形補完(で、いいのか？）を行う。
                float fct_z = Inpos_toBmp_z % 1.0f;

                float tmp1_1 = HeightMap[tgtIndex_Z][tgtIndex_X];
                float tmp2_1 = HeightMap[tgtIndex_Z + 1][tgtIndex_X];


                float tmp1_2 = HeightMap[tgtIndex_Z][tgtIndex_X + 1];
                float tmp2_2 = HeightMap[tgtIndex_Z + 1][tgtIndex_X + 1];

                float fct_x = Inpos_toBmp_x % 1.0f;

                //各値をかけていく
                if (fct_x != 0)
                {
                    tmp_a1 = MathHelper.Lerp(tmp1_1, tmp1_2, fct_x);
                    tmp_a2 = MathHelper.Lerp(tmp2_1, tmp2_2, fct_x);
                }
                else
                {
                    tmp_a1 = tmp1_1;
                    tmp_a2 = tmp2_1;
                }

                if (fct_z != 0)
                {
                    refF = MathHelper.Lerp(tmp_a1, tmp_a2, fct_z);
                }
                else
                {
                    refF = tmp_a1;
                }
            }

            return refF;
        }

    }

    public enum Ground_Pos_ID : byte
    {
        /// <summary>min=0</summary>
        X_min = 0,
        X_max,
        Z_min,
        Z_max,
        Y_min,
        Y_max,
        X_MintoMax,
        Z_MintoMax,
        Y_MintoMax,
        maxval,
    }
}