/* ****************************************************************************
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * ============================================================================
 * Eclipse Extension Plug-in Project
 * 
 * $Header: 
 * $Revision: 
 * $Date: 
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.jspc.popup.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import jp.sourceforge.jeextension.jspc.EclipseJspCPlugin;
import jp.sourceforge.jeextension.jspc.Util;

import org.apache.jasper.JspC;

import org.apache.jasper.JasperException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
/**
 * RunnableWithProgress
 */
public class JspCRunner implements IRunnableWithProgress {

    private Object element;
    
    Throwable occuredThrowable;

    /**
     * 
     */
    public JspCRunner(Object selection) {
        super();
        this.element = selection;
    }

    /**
     * {@inheritdoc}
     * @see org.eclipse.jface.operation.IRunnableWithProgress#run(org.eclipse.core.runtime.IProgressMonitor)
     */
    public void run(IProgressMonitor monitor)
            throws InvocationTargetException, InterruptedException {
        
        if (element instanceof IResource) {
            monitor.beginTask("JSP Compile Start.", 1);
            IResource resource = (IResource) element;
            File resourceFile = resource.getLocation().toFile();
            IProject project = resource.getProject();
            /*
             * JSPC
             */
            monitor.setTaskName("JSP Compiling.");
            monitor.worked(20);
            JspC jspc = new JspC();
            setupJspC(jspc, project, resourceFile);
            try {
                jspc.execute();
            } catch (JasperException e) {
                e.printStackTrace();
                e.getRootCause().printStackTrace();
                occuredThrowable = e;
            }
            monitor.setTaskName("Refresh Local Resources.");
            monitor.worked(70);
            /*
             * Refresh Local. 
             */
            try {
                project.refreshLocal(IResource.DEPTH_INFINITE, monitor);
                project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, monitor);
            } catch (CoreException e) {
            }
            monitor.done();
        } else {
            return;
        }
    }
    
    /**
     * setup JspC execution properties.
     * @param jspC
     * @param project
     * @param resourceFile
     */
    private void setupJspC(JspC jspC, IProject project, File resourceFile) {
        String location = project.getLocation().toFile().getPath();
        String uriRoot = resourceFile.getPath();
        String outputDir = EclipseJspCPlugin.getOutputDir();
        String pkgName = EclipseJspCPlugin.getJspPackage();
        String encoding = ResourcesPlugin.getEncoding();
        
        jspC.setUriroot(uriRoot);
        jspC.setOutputDir(location + outputDir);
        jspC.setPackage(pkgName);
        jspC.setJavaEncoding(encoding);
        jspC.setClassPath(Util.getProjectClassPath(project));
    }
}
