/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.logging.JasperLogger;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.tools.ant.AntClassLoader;

public class JspC
implements Options {
    public static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    public static final String SWITCH_VERBOSE = "-v";
    public static final String SWITCH_QUIET = "-q";
    public static final String SWITCH_OUTPUT_DIR = "-d";
    public static final String SWITCH_OUTPUT_SIMPLE_DIR = "-dd";
    public static final String SWITCH_IE_CLASS_ID = "-ieplugin";
    public static final String SWITCH_PACKAGE_NAME = "-p";
    public static final String SWITCH_CLASS_NAME = "-c";
    public static final String SWITCH_FULL_STOP = "--";
    public static final String SWITCH_COMPILE = "-compile";
    public static final String SWITCH_URI_BASE = "-uribase";
    public static final String SWITCH_URI_ROOT = "-uriroot";
    public static final String SWITCH_FILE_WEBAPP = "-webapp";
    public static final String SWITCH_WEBAPP_INC = "-webinc";
    public static final String SWITCH_WEBAPP_XML = "-webxml";
    public static final String SWITCH_MAPPED = "-mapped";
    public static final String SWITCH_DIE = "-die";
    public static final String SHOW_SUCCESS = "-s";
    public static final String LIST_ERRORS = "-l";
    public static final int NO_WEBXML = 0;
    public static final int INC_WEBXML = 10;
    public static final int ALL_WEBXML = 20;
    public static final int DEFAULT_DIE_LEVEL = 1;
    public static final int NO_DIE_LEVEL = 0;
    String classPath = null;
    URLClassLoader loader = null;
    boolean largeFile = false;
    boolean mappedFile = false;
    int jspVerbosityLevel = 3;
    File scratchDir;
    String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    String targetPackage;
    String targetClassName;
    String uriBase;
    String uriRoot;
    int dieLevel;
    boolean dieOnExit = false;
    static int die;
    boolean compile = false;
    String compiler = null;
    boolean dirset;
    boolean classDebugInfo = true;
    Vector extensions;
    Vector pages = new Vector();
    String webxmlFile;
    int webxmlLevel;
    Writer mapout;
    CharArrayWriter servletout;
    CharArrayWriter mappingout;
    static PrintStream log;
    JspCServletContext context;
    String javaEncoding = "UTF-8";
    private TldLocationsCache tldLocationsCache = null;
    private boolean listErrors = false;
    private boolean showSuccess = false;
    int argPos;
    boolean fullstop = false;
    String[] args;
    static final String[] javaKeywords;

    public boolean getKeepGenerated() {
        return true;
    }

    public boolean getLargeFile() {
        return this.largeFile;
    }

    public boolean isPoolingEnabled() {
        return true;
    }

    public boolean getMappedFile() {
        return this.mappedFile;
    }

    public Object getProtectionDomain() {
        return null;
    }

    public boolean getSendErrorToClient() {
        return true;
    }

    public void setClassDebugInfo(boolean b) {
        this.classDebugInfo = b;
    }

    public boolean getClassDebugInfo() {
        return this.classDebugInfo;
    }

    public int getCheckInterval() {
        return 300;
    }

    public boolean getDevelopment() {
        return false;
    }

    public boolean getReloading() {
        return true;
    }

    public String getIeClassId() {
        return this.ieClassId;
    }

    public int getJspVerbosityLevel() {
        return this.jspVerbosityLevel;
    }

    public File getScratchDir() {
        return this.scratchDir;
    }

    public Class getJspCompilerPlugin() {
        return null;
    }

    public String getJspCompilerPath() {
        return null;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String c) {
        this.compiler = c;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    public void setJavaEncoding(String encoding) {
        this.javaEncoding = encoding;
    }

    public boolean getFork() {
        return false;
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return System.getProperty("java.class.path");
    }

    public JspC() {
        Constants.jasperLog = new JasperLogger();
    }

    public void setClassPath(String s) {
        this.classPath = s;
    }

    public void setUriroot(String s) {
        if (s == null) {
            this.uriRoot = s;
            return;
        }
        try {
            this.uriRoot = new File(s).getCanonicalPath();
        }
        catch (Exception ex) {
            this.uriRoot = s;
        }
    }

    public void setVerbose(int level) {
        Constants.jasperLog.setVerbosityLevel(level);
    }

    public void setCompile(boolean b) {
        this.compile = b;
    }

    public void setValidateXml(boolean b) {
        ParserUtils.validating = b;
    }

    public void setOutputDir(String s) {
        if (s != null) {
            this.scratchDir = new File(new File(s).getAbsolutePath());
            this.dirset = true;
        } else {
            this.scratchDir = null;
        }
    }

    public void setPackage(String p) {
        this.targetPackage = p;
    }

    public void setClassName(String p) {
        this.targetClassName = p;
    }

    public void setWebXmlFragment(String s) {
        this.webxmlFile = s;
        this.webxmlLevel = 10;
    }

    void setupContext(JspCompilationContext clctxt) {
        String tmpDir;
        File f;
        String outputDir = this.scratchDir.getAbsolutePath();
        if (this.dirset && !(f = new File(tmpDir = outputDir + File.separatorChar)).exists()) {
            f.mkdirs();
        }
        clctxt.setOutputDir(outputDir);
    }

    void initClassLoader(JspCompilationContext clctxt) throws IOException {
        Object path;
        this.classPath = this.getClassPath();
        ClassLoader parent = this.getClass().getClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        File webappBase = new File(this.uriRoot);
        if (parent instanceof URLClassLoader) {
            URLClassLoader uL = (URLClassLoader)parent;
            path = uL.getURLs();
            int i = 0;
            while (i < ((URL[])path).length) {
                urls.add(path[i]);
                this.classPath = this.classPath + File.pathSeparator + path[i].getFile();
                ++i;
            }
        }
        if (parent instanceof AntClassLoader) {
            this.classPath = this.classPath + File.pathSeparator + ((AntClassLoader)parent).getClasspath();
        }
        StringTokenizer tokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            path = tokenizer.nextToken();
            try {
                File libFile = new File((String)path);
                urls.add(libFile.toURL());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
        if (webappBase.exists()) {
            File classes = new File(webappBase, "/WEB-INF/classes");
            try {
                if (classes.exists()) {
                    this.classPath = this.classPath + File.pathSeparator + classes.getCanonicalPath();
                    urls.add(classes.getCanonicalFile().toURL());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
            File lib = new File(webappBase, "/WEB-INF/lib");
            if (lib.exists() && lib.isDirectory()) {
                String[] libs = lib.list();
                int i = 0;
                while (i < libs.length) {
                    if (libs[i].length() >= 5) {
                        String ext = libs[i].substring(libs[i].length() - 4);
                        if (!".jar".equalsIgnoreCase(ext)) {
                            System.out.println("XXX bad jar " + libs[i]);
                        } else {
                            try {
                                File libFile = new File(lib, libs[i]);
                                this.classPath = this.classPath + File.pathSeparator + libFile.getCanonicalPath();
                                urls.add(libFile.getCanonicalFile().toURL());
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe.toString());
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        urls.add(new File(clctxt.getRealPath("/")).getCanonicalFile().toURL());
        URL[] urlsA = new URL[urls.size()];
        urls.toArray(urlsA);
        this.loader = new URLClassLoader(urlsA, this.getClass().getClassLoader());
    }

    public void generateWebMapping(String file, JspCompilationContext clctxt) throws IOException {
        String className = clctxt.getServletClassName();
        String packageName = clctxt.getServletPackageName();
        String thisServletName = "".equals(packageName) ? className : packageName + '.' + className;
        if (this.servletout != null) {
            this.servletout.write("\n\t<servlet>\n\t\t<servlet-name>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-name>\n\t\t<servlet-class>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-class>\n\t</servlet>\n");
        }
        if (this.mappingout != null) {
            this.mappingout.write("\n\t<servlet-mapping>\n\t\t<servlet-name>");
            this.mappingout.write(thisServletName);
            this.mappingout.write("</servlet-name>\n\t\t<url-pattern>");
            this.mappingout.write(file.replace('\\', '/'));
            this.mappingout.write("</url-pattern>\n\t</servlet-mapping>\n");
        }
    }

    public boolean processFile(String file) throws JasperException {
        try {
            if (this.scratchDir == null) {
                String temp = System.getProperty("java.io.tmpdir");
                if (temp == null) {
                    temp = "";
                }
                this.scratchDir = new File(new File(temp).getAbsolutePath());
            }
            String jspUri = file.replace('\\', '/');
            String baseDir = this.scratchDir.getCanonicalPath();
            this.setOutputDir(baseDir + jspUri.substring(0, jspUri.lastIndexOf(47)));
            JspCompilationContext clctxt = new JspCompilationContext(jspUri, false, (Options)this, (ServletContext)this.context, null, null);
            if (this.targetClassName != null && this.targetClassName.length() > 0) {
                clctxt.setServletClassName(this.targetClassName);
                this.targetClassName = null;
            }
            if (this.targetPackage != null) {
                String jspPackage = this.toPackageName(jspUri);
                if (jspPackage.equals("")) {
                    clctxt.setServletPackageName(this.targetPackage);
                } else {
                    clctxt.setServletPackageName(this.targetPackage + "." + jspPackage);
                }
            } else {
                clctxt.setServletPackageName(this.toPackageName(jspUri));
            }
            this.setupContext(clctxt);
            if (this.loader == null) {
                this.initClassLoader(clctxt);
            }
            clctxt.setClassLoader(this.loader);
            clctxt.setClassPath(this.classPath);
            Compiler clc = clctxt.createCompiler();
            this.setOutputDir(baseDir);
            if (this.compile) {
                if (clc.isOutDated()) {
                    clc.compile();
                }
            } else if (clc.isOutDated(false)) {
                clc.generateJava();
            }
            this.generateWebMapping(file, clctxt);
            if (this.showSuccess) {
                log.println("Built File: " + file);
            }
            return true;
        }
        catch (FileNotFoundException fne) {
            Constants.message((String)"jspc.error.fileDoesNotExist", (Object[])new Object[]{fne.getMessage()}, (int)2);
            throw new JasperException((Throwable)fne);
        }
        catch (Exception e) {
            Constants.message((String)"jspc.error.generalException", (Object[])new Object[]{file, e}, (int)1);
            if (this.listErrors) {
                log.println("Error in File: " + file);
                return true;
            }
            if (this.dieLevel != 0) {
                this.dieOnExit = true;
            }
            throw new JasperException("Error compiling " + file, (Throwable)e);
        }
    }

    private void locateUriRoot(File f) {
        block10: {
            String tUriBase = this.uriBase;
            if (tUriBase == null) {
                tUriBase = "/";
            }
            try {
                if (!f.exists()) break block10;
                f = new File(f.getCanonicalPath());
                while (f != null) {
                    String fParent;
                    File g = new File(f, "WEB-INF");
                    if (g.exists() && g.isDirectory()) {
                        this.uriRoot = f.getCanonicalPath();
                        this.uriBase = tUriBase;
                        Constants.message((String)"jspc.implicit.uriRoot", (Object[])new Object[]{this.uriRoot}, (int)3);
                        break;
                    }
                    if (f.exists() && f.isDirectory()) {
                        tUriBase = "/" + f.getName() + "/" + tUriBase;
                    }
                    if ((fParent = f.getParent()) == null) {
                        f = new File(this.args[this.argPos]);
                        fParent = f.getParent();
                        if (fParent == null) {
                            fParent = File.separator;
                        }
                        this.uriRoot = new File(fParent).getCanonicalPath();
                        this.uriBase = "/";
                        break;
                    }
                    f = new File(fParent);
                }
                try {
                    File froot = new File(this.uriRoot);
                    this.uriRoot = froot.getCanonicalPath();
                }
                catch (IOException ioe) {
                }
            }
            catch (IOException ioe) {}
        }
    }

    public void scanFiles(File base) {
        Stack<Object> dirs = new Stack<Object>();
        dirs.push(base);
        if (this.extensions == null) {
            this.extensions = new Vector();
            this.extensions.addElement("jsp");
        }
        while (!dirs.isEmpty()) {
            String s = dirs.pop().toString();
            File f = new File(s);
            if (!f.exists() || !f.isDirectory()) continue;
            String[] files = f.list();
            int i = 0;
            while (i < files.length) {
                File f2 = new File(s, files[i]);
                if (f2.isDirectory()) {
                    dirs.push(f2.getPath());
                } else {
                    String ext = files[i].substring(files[i].lastIndexOf(46) + 1);
                    if (this.extensions.contains(ext)) {
                        this.pages.addElement(s + File.separatorChar + files[i]);
                    }
                }
                ++i;
            }
        }
    }

    private void initWebXml() {
        try {
            if (this.webxmlLevel >= 10) {
                File fmapings = new File(this.webxmlFile);
                this.mapout = new FileWriter(fmapings);
                this.servletout = new CharArrayWriter();
                this.mappingout = new CharArrayWriter();
            } else {
                this.mapout = null;
                this.servletout = null;
                this.mappingout = null;
            }
            if (this.webxmlLevel >= 20) {
                this.mapout.write(Constants.getString((String)"jspc.webxml.header"));
            } else if (this.webxmlLevel >= 10) {
                this.mapout.write(Constants.getString((String)"jspc.webinc.header"));
            }
        }
        catch (IOException ioe) {
            this.mapout = null;
            this.servletout = null;
            this.mappingout = null;
        }
    }

    private void completeWebXml() {
        block5: {
            if (this.mapout == null) break block5;
            try {
                this.servletout.writeTo(this.mapout);
                this.mappingout.writeTo(this.mapout);
                if (this.webxmlLevel >= 20) {
                    this.mapout.write(Constants.getString((String)"jspc.webxml.footer"));
                } else if (this.webxmlLevel >= 10) {
                    this.mapout.write(Constants.getString((String)"jspc.webinc.footer"));
                }
                this.mapout.close();
            }
            catch (IOException ioe) {}
        }
    }

    private void initServletContext() {
        try {
            this.context = new JspCServletContext(new PrintWriter(System.out), new URL("file:" + this.uriRoot.replace('\\', '/') + '/'));
            this.tldLocationsCache = new TldLocationsCache((ServletContext)this.context);
        }
        catch (MalformedURLException me) {
            System.out.println("**" + me);
        }
    }

    public void execute() throws JasperException {
        File uriRootF;
        if (this.uriRoot == null) {
            if (this.pages.size() == 0) {
                throw new JasperException("No uriRoot or files");
            }
            String firstJsp = (String)this.pages.elementAt(0);
            this.locateUriRoot(new File(firstJsp));
        }
        if (this.pages.size() == 0) {
            this.scanFiles(new File(this.uriRoot));
        }
        if (!(uriRootF = new File(this.uriRoot)).exists() || !uriRootF.isDirectory()) {
            throw new JasperException(Constants.getString((String)"jsp.error.jspc.uriroot_not_dir"));
        }
        if (this.context == null) {
            this.initServletContext();
        }
        this.initWebXml();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        Enumeration e = this.pages.elements();
        while (e.hasMoreElements()) {
            String nextjsp = e.nextElement().toString();
            try {
                File fjsp = new File(nextjsp);
                if (!fjsp.exists()) {
                    Constants.message((String)"jspc.error.fileDoesNotExist", (Object[])new Object[]{fjsp}, (int)2);
                    continue;
                }
                String s = fjsp.getCanonicalPath();
                if (s.startsWith(this.uriRoot)) {
                    nextjsp = s.substring(this.uriRoot.length());
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (nextjsp.startsWith("." + File.separatorChar)) {
                nextjsp = nextjsp.substring(2);
            }
            this.processFile(nextjsp);
        }
        this.completeWebXml();
    }

    public static void main(String[] arg) {
        block4: {
            if (arg.length == 0) {
                System.out.println(Constants.getString((String)"jspc.usage"));
            } else {
                try {
                    log = System.out;
                    JspC jspc = new JspC();
                    jspc.setArgs(arg);
                    jspc.execute();
                }
                catch (JasperException je) {
                    System.err.print("error:");
                    je.printStackTrace();
                    if (die == 0) break block4;
                    System.exit(die);
                }
            }
        }
    }

    private String nextArg() {
        if (this.argPos >= this.args.length || (this.fullstop = SWITCH_FULL_STOP.equals(this.args[this.argPos]))) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private String nextFile() {
        if (this.fullstop) {
            ++this.argPos;
        }
        if (this.argPos >= this.args.length) {
            return null;
        }
        return this.args[this.argPos++];
    }

    /*
     * WARNING - void declaration
     */
    void setArgs(String[] arg) {
        String file;
        String tok;
        this.args = arg;
        int verbosityLevel = 2;
        die = this.dieLevel = 0;
        while ((tok = this.nextArg()) != null) {
            void var2_3;
            if (var2_3.equals(SWITCH_QUIET)) {
                verbosityLevel = 2;
                continue;
            }
            if (var2_3.equals(SWITCH_VERBOSE)) {
                verbosityLevel = 3;
                continue;
            }
            if (var2_3.startsWith(SWITCH_VERBOSE)) {
                try {
                    verbosityLevel = Integer.parseInt(var2_3.substring(SWITCH_VERBOSE.length()));
                }
                catch (NumberFormatException nfe) {
                    log.println("Verbosity level " + var2_3.substring(SWITCH_VERBOSE.length()) + " is not valid.  Option ignored.");
                }
                continue;
            }
            if (var2_3.equals(SWITCH_OUTPUT_DIR)) {
                tok = this.nextArg();
                this.setOutputDir(tok);
                continue;
            }
            if (tok.equals(SWITCH_OUTPUT_SIMPLE_DIR)) {
                tok = this.nextArg();
                if (tok != null) {
                    this.scratchDir = new File(new File(tok).getAbsolutePath());
                    this.dirset = false;
                    continue;
                }
                this.scratchDir = null;
                continue;
            }
            if (tok.equals(SWITCH_PACKAGE_NAME)) {
                this.targetPackage = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_COMPILE)) {
                this.compile = true;
                continue;
            }
            if (tok.equals(SWITCH_CLASS_NAME)) {
                this.targetClassName = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_BASE)) {
                this.uriBase = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_ROOT)) {
                this.setUriroot(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_FILE_WEBAPP)) {
                this.setUriroot(this.nextArg());
                continue;
            }
            if (tok.equals(SHOW_SUCCESS)) {
                this.showSuccess = true;
                continue;
            }
            if (tok.equals(LIST_ERRORS)) {
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_INC)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 10;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_XML)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 20;
                continue;
            }
            if (tok.equals(SWITCH_MAPPED)) {
                this.mappedFile = true;
                continue;
            }
            if (tok.startsWith(SWITCH_DIE)) {
                try {
                    this.dieLevel = Integer.parseInt(tok.substring(SWITCH_DIE.length()));
                }
                catch (NumberFormatException nfe) {
                    this.dieLevel = 1;
                }
                die = this.dieLevel;
                continue;
            }
            if (this.fullstop) break;
            --this.argPos;
            break;
        }
        while ((file = this.nextFile()) != null) {
            this.pages.addElement(file);
        }
        Constants.jasperLog.setVerbosityLevel(verbosityLevel);
    }

    public static void setLog(PrintStream log) {
        JspC.log = log;
    }

    private static boolean isJavaKeyword(String key) {
        int i = 0;
        int j = javaKeywords.length;
        while (i < j) {
            int k = (i + j) / 2;
            int result = javaKeywords[k].compareTo(key);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                i = k + 1;
                continue;
            }
            j = k;
        }
        return false;
    }

    private String toPackageName(String jspUri) {
        StringBuffer modifiedPackageName = new StringBuffer();
        int iSep = jspUri.lastIndexOf(47);
        int nameStart = 1;
        int i = 1;
        while (i < iSep) {
            char ch = jspUri.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                modifiedPackageName.append(ch);
            } else if (ch == '/') {
                if (JspC.isJavaKeyword(jspUri.substring(nameStart, i))) {
                    modifiedPackageName.append('_');
                }
                nameStart = i + 1;
                modifiedPackageName.append('.');
            } else {
                modifiedPackageName.append(this.mangleChar(ch));
            }
            ++i;
        }
        if (nameStart < iSep && JspC.isJavaKeyword(jspUri.substring(nameStart, iSep))) {
            modifiedPackageName.append('_');
        }
        return modifiedPackageName.toString();
    }

    private String mangleChar(char ch) {
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        int i = 1;
        while (i <= nzeros) {
            result[i] = 48;
            ++i;
        }
        int i2 = nzeros + 1;
        int j = 0;
        while (i2 < 6) {
            result[i2] = s.charAt(j);
            ++i2;
            ++j;
        }
        return new String(result);
    }

    static {
        javaKeywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throws", "transient", "try", "void", "volatile", "while"};
    }
}

