/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/entry/IPartitionEntry.java,v 1.7 2007/10/25 03:16:49 kohnosuke Exp $
 * $Revision: 1.7 $
 * $Date: 2007/10/25 03:16:49 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.entry;

/**
 * IPartitionEntry
 * @since 1.0.0
 * <!-- #ReqID:10017 RegExp (Partition) -->
 */
public interface IPartitionEntry extends IEntry {
    
    /** partition name, "__java_javadoc" */
    String JAVA_DOC = "__java_javadoc";
    
    /** partition name, "__java_multiline_comment" */
    String JAVA_MULTILINE = "__java_multiline_comment";
    
    /** partition name, "__java_singleline_comment" */
    String JAVA_SINGLELINE = "__java_singleline_comment";
    
    /** partition name, "__java_string" */
    String JAVA_STRING = "__java_string";
    
    /** partition name, "__java_character" */
    String JAVA_CHAR = "__java_character";
    
    /**
     * Returns Partition end keyword.
     * @return end keyword.
     */
    String getEnd();
    
    /**
     * Returns Partition start keyword.
     * @return start keyword.
     */
    String getStart();
    
    /**
     * Returns RegExp Expression.
     * @return start keyword.
     */
    String getRegExp();
    
    /**
     * Returns list includes IDependsEntry depends this partition.
     * @return DependsEntryList
     */
    DependsEntryList getDependsEntryList();
    
    /**
     * Set partition end keyword.
     * @param end end keyword.
     */
    void setEnd(String end);
    
    /**
     * Set partition entry name.
     * @param name name of partition.
     */
    void setName(String name);
    
    /**
     * Set Partition start keyword.
     * @param start start keyword.
     */
    void setStart(String start);
    /**
     * Set RegExp Partition Keyword.
     * @param regexp regexp expression
     */
    void setRegExp(String regexp);
    
    /**
     * Get View Strings for PartitionEntryDialog.
     * @return view
     */
    String getView();
    
    /**
     * Set View Strings for PartitionEntryDialog.
     * @param view strings
     */
    void setView(String view);
}
