/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/SourceViewerConfigurationProxyHandler.java,v 1.5 2007/10/25 03:16:49 kohnosuke Exp $
 * $Revision: 1.5 $
 * $Date: 2007/10/25 03:16:49 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;

import java.lang.reflect.Method;

import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

import javassist.util.proxy.MethodHandler;
import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntryList;

/**
 * SourceViewerConfigurationProxyHandler
 * @since 2.0.0
 */
public class SourceViewerConfigurationProxyHandler implements MethodHandler {
    
    /** SourceViewerConfiguration */
    private final SourceViewerConfiguration fWrapped;
    
    /** default file's extension is '*' */
    private String fFileExtension = "*";
    
    /**
     * Constructor.
     * @param wrapped   SourceViewerConfiguraiton
     */
    public SourceViewerConfigurationProxyHandler(Object wrapped) {
        super();
        fWrapped = (SourceViewerConfiguration) wrapped;
    }
    
    /**
     * Set target file's extension.
     * @param fileExtension file's extension.
     */
    public void setFileExtension(String fileExtension) {
        fFileExtension = fileExtension;
    }
    
    /**
     * {@inheritDoc}
     */
    public Object invoke(Object self, Method thisMethod, Method proceed,
            Object[] args) throws Throwable {
        
        // proxy method
        if (thisMethod.getName().equals("getConfiguredContentTypes")) {
            return getConfiguredContentTypes((ISourceViewer) args[0]); 
        }
        // proxy method
        if (thisMethod.getName().equals("getPresentationReconciler")) {
            return getPresentationReconciler((ISourceViewer) args[0]);
        }
        // origin
        return proceed.invoke(self, args);
    }
    
    /**
     * Proxy, SourceViewerConfiguration#getConfiguredContentTypes.
     * 
     * @param sourceViewer  ISourceViewer
     * @return  content types for style editor.
     */
    private String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return StyleEditorTools.getContentTypes(fFileExtension);
    }
    
    /**
     * Proxy, SourceViewerConfiguration#getPresentationReconciler.
     * 
     * @param sourceViewer  ISourceViewer
     * @return  IPresentationReconciler for style editor.
     */
    private IPresentationReconciler getPresentationReconciler(
            ISourceViewer sourceViewer) {
        
        PresentationReconciler reconciler = (PresentationReconciler) 
                            fWrapped.getPresentationReconciler(sourceViewer);
        
        reconciler.setDamager(null, "__java_string");
        reconciler.setRepairer(null, "__java_string");
        reconciler.setDamager(null, "__java_character");
        reconciler.setRepairer(null, "__java_character");
        reconciler.setDamager(null, "__java_singleline_comment");
        reconciler.setRepairer(null, "__java_singleline_comment");
        
        // get current editting file extension.
        String ext = fFileExtension;
        
        // for default content type.
        StyleEditorTools tools =
            StyleEditorPlugin.getDefault().getEditorTools();
        {
            PartitionEntryList list =
                    StyleEditorTools.getPartitionEntryList(ext, false);
            for (int i = 0; i < list.size(); i++) {
                IPartitionEntry pe = list.getPartitionEntry(i);
                String partName = pe.getName();
                
                // create scanner.
                RuleBasedScanner scanner = tools.createScanner(partName, ext);
                scanner.setDefaultReturnToken(tools.getDefaultToken(pe));
                
                // create damager repairer and set one to.
                DefaultDamagerRepairer dr =
                        new StyleEditorDamagerRepairer(scanner);
                reconciler.setDamager (dr, partName);
                reconciler.setRepairer(dr, partName);
            }
        }
        
        return reconciler;
    }
    
}
