/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLFile;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.common.xml.XMLNodeList;
import jp.sourceforge.jeextension.common.xml.XMLReader;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorCore;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.DefinedStyleEntry;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntryList;
import jp.sourceforge.jeextension.styleeditor.entry.FontEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IDependsEntry;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntryList;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class StyleEditorPlugin
extends AbstractUIPlugin {
    private static StyleEditorPlugin fPlugin;
    private static DefinedStyleEntry styleEntry;
    private StyleEditorCore fCore;
    static /* synthetic */ Class class$0;

    static {
        styleEntry = new DefinedStyleEntry();
    }

    public static DefinedStyleEntry getDefinedStyleEntry() {
        return styleEntry;
    }

    public static void load() {
        IPath path = StyleEditorPlugin.getDefault().getStateLocation();
        path = path.append("configuration.xml");
        XMLFile file = new XMLFile(path.toFile(), "ISO-8859-1");
        StyleEditorPlugin.load(file);
    }

    public static void load(XMLFile file) {
        XMLNode root;
        styleEntry.clearAll();
        if (!file.getFile().exists()) {
            StyleEditorPlugin.loadDefault();
            return;
        }
        try {
            root = file.readNode();
        }
        catch (XMLException e) {
            StyleEditorPlugin.log(e);
            return;
        }
        StyleEditorPlugin.internalLoad(root);
    }

    public static void loadDefault() {
        XMLNode root;
        styleEntry.clearAll();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("default-configuration.xml");
        XMLReader reader = new XMLReader("ISO-8859-1");
        try {
            root = reader.readAsXMLNode(stream);
        }
        catch (XMLException e) {
            StyleEditorPlugin.log(e);
            return;
        }
        StyleEditorPlugin.internalLoad(root);
    }

    public static void log(Throwable e) {
        ILog log = StyleEditorPlugin.getDefault().getLog();
        String pluginId = StyleEditorPlugin.getDefault().getBundle().getSymbolicName();
        log.log((IStatus)new Status(4, pluginId, 10001, "internal_error", e));
    }

    public static void save() {
        IPath path = StyleEditorPlugin.getDefault().getStateLocation();
        path = path.append("configuration.xml");
        XMLFile file = new XMLFile(path.toFile(), "ISO-8859-1");
        StyleEditorPlugin.save(file);
    }

    public static void save(XMLFile file) {
        XMLNode root = new XMLNode("define");
        Map partEntryListMap = styleEntry.getPartitionEntryMap();
        Iterator iterator = partEntryListMap.keySet().iterator();
        while (iterator.hasNext()) {
            String ext = (String)iterator.next();
            XMLNode extNode = new XMLNode("extension");
            extNode.setAttribute("name", ext);
            root.addChild(extNode);
            FontEntry fontEntry = styleEntry.getFontEntry(ext);
            if (fontEntry != null) {
                extNode.setAttribute("font-name", fontEntry.getName());
                extNode.setAttribute("font-size", String.valueOf(fontEntry.getSize()));
            }
            PartitionEntryList partEntryList = styleEntry.getPartitionEntryList(ext, false);
            int i = 0;
            while (i < partEntryList.size()) {
                IPartitionEntry partEntry = partEntryList.getPartitionEntry(i);
                XMLNode pNode = partEntry.createNode();
                extNode.addChild(pNode);
                DependsEntryList depdEntryList = partEntry.getDependsEntryList();
                int j = 0;
                while (j < depdEntryList.size()) {
                    IDependsEntry depdEntry = depdEntryList.getDependsEntry(j);
                    XMLNode dNode = depdEntry.createNode();
                    pNode.addChild(dNode);
                    ++j;
                }
                ++i;
            }
        }
        try {
            file.writeNode(root);
        }
        catch (XMLException e) {
            StyleEditorPlugin.log(e);
            return;
        }
    }

    public static String getRuntimeVersion() {
        String version = (String)Platform.getBundle((String)"org.eclipse.core.runtime").getHeaders().get("Bundle-Version");
        return version;
    }

    public static StyleEditorPlugin getDefault() {
        return fPlugin;
    }

    private static void internalLoad(XMLNode root) {
        XMLNodeList extNodeList = root.getChildNodes();
        int i = 0;
        while (i < extNodeList.size()) {
            XMLNode extNode = extNodeList.getNode(i);
            String ext = extNode.getAttribute("name");
            PartitionEntryList partitionEntryList = styleEntry.getPartitionEntryList(ext, true);
            String fontName = extNode.getAttribute("font-name");
            String fontSize = extNode.getAttribute("font-size");
            if (fontName != null && fontSize != null) {
                FontEntry fontEntry = new FontEntry(fontName, fontSize);
                styleEntry.addFontEntry(fontEntry, ext);
            }
            XMLNodeList partNodeList = extNode.getChildNodes();
            int j = 0;
            while (j < partNodeList.size()) {
                XMLNode partNode = partNodeList.getNode(j);
                PartitionEntry partEntry = new PartitionEntry(partNode, ext);
                partitionEntryList.add(partEntry);
                DependsEntryList dependsEntryList = partEntry.getDependsEntryList();
                XMLNodeList entryNodeList = partNode.getChildNodes();
                int k = 0;
                while (k < entryNodeList.size()) {
                    XMLNode entryNode = entryNodeList.getNode(k);
                    dependsEntryList.add(new DependsEntry(entryNode, ext));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public StyleEditorPlugin() {
        fPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (styleEntry.isSizeZero()) {
            StyleEditorPlugin.load();
        }
    }

    public synchronized StyleEditorTools getEditorTools() {
        return this.getCore().getEditorTools();
    }

    public synchronized IColorManager getColorManager() {
        return this.getCore().getColorManager();
    }

    public void stop(BundleContext context) throws Exception {
        this.getCore().dispose();
        super.stop(context);
    }

    public synchronized StyleEditorCore getCore() {
        if (this.fCore == null) {
            this.fCore = new StyleEditorCore();
        }
        return this.fCore;
    }
}

