/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/StyleEditor.java,v 1.1 2005/01/29 03:24:19 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/29 03:24:19 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;

/**
 * DefinedEditor is based TextEditor.
 */
public class StyleEditor extends TextEditor {

    /**
     * ColorManager object.
     */
    private ColorManager fColorManager;

    /**
     * SourceViewerConfiguration object.
     */
    private EditorConfiguration fEditorConf;

    /**
     * Font object.
     */
    private Font fFont;

    /**
     * Initiate Editor.
     */
    public StyleEditor() {
        super();
        
        fEditorConf = new EditorConfiguration(this);
        DocumentProvider provider = new DocumentProvider(fEditorConf);
        
        fColorManager = fEditorConf.getColorManager();
        
        setSourceViewerConfiguration(fEditorConf);
        setDocumentProvider(provider);
    }

    /**
     * Returns current editting file extension.
     * @return file extension.
     */
    public String getFileExtension() {
        // get current editting file extension.
        IFileEditorInput input = (IFileEditorInput) getEditorInput();
        return input.getFile().getFileExtension();
    }

    /**
     * @see org.eclipse.ui.editors.text.TextEditor#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        
        // #ReqID:6168 Set Editor Font.
        fFont = EditorTools.getFont(getFileExtension());
        getSourceViewer().getTextWidget().setFont(fFont);
    }

    /**
     * {@inheritDoc}
     * @see org.eclipse.ui.IWorkbenchPart#dispose()
     */
    public void dispose() {
        fColorManager.dispose();
        if (fFont != null) {
            fFont.dispose();
        }
        super.dispose();
    }
}
