/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/entry/PartitionEntry.java,v 1.1 2005/01/29 03:24:35 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/29 03:24:35 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.entry;

import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;

import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.RGB;

/**
 * PartitionEntry
 */
public class PartitionEntry implements IPartitionEntry {
    
    /** partition end keyword. */
    private String fEnd = "";
    
    /** partition name. */
    private String fName = "";
    
    /** defined RGB color. */
    private RGB fRGB = new RGB(0, 0, 0);
    
    /** defined rule. */
    private IExtRule fRule;
    
    /** partition start keyword. */
    private String fStart = "";
    
    /** list includes IDependsEntry depends this partition. */
    private DependsEntryList fDepends = new DependsEntryList();
    
    /**
     * Initiate this object. for default constructor.
     */
    public PartitionEntry() {
        super();
    }
    
    /**
     * Initiate this object. using XMLNode.
     * @param node  XMLNode
     * @param ext   extension name. (ex. java, means *.java)
     */
    public PartitionEntry(XMLNode node, String ext) {
        super();
        fName = node.getAttribute("name");
        fStart         = node.getAttribute("start");
        fEnd           = node.getAttribute("end");
        this.fRGB.red   = Integer.parseInt(node.getAttribute("red"));
        this.fRGB.green = Integer.parseInt(node.getAttribute("green"));
        this.fRGB.blue  = Integer.parseInt(node.getAttribute("blue"));
        
        if (fName.equals("__dftl_partition_content_type")) {
            fName = IDocument.DEFAULT_CONTENT_TYPE;
            return;
        }
        this.fRule = EditorTools.createExtRule(node, ext);
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#createNode()
     */
    public XMLNode createNode() {
        XMLNode xmlNode = new XMLNode("partition");
        xmlNode.setAttribute("name" , this.fName);
        xmlNode.setAttribute("red"  , String.valueOf(fRGB.red));
        xmlNode.setAttribute("green", String.valueOf(fRGB.green));
        xmlNode.setAttribute("blue" , String.valueOf(fRGB.blue));
        xmlNode.setAttribute("start", this.getStart());
        xmlNode.setAttribute("end"  , this.getEnd());
        return xmlNode;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#getEnd()
     */
    public String getEnd() {
        return fEnd;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#getName()
     */
    public String getName() {
        return fName;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#getRGB()
     */
    public RGB getRGB() {
        return fRGB;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#getRule()
     */
    public IExtRule getRule() {
        return this.fRule;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#getStart()
     */
    public String getStart() {
        return fStart;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry#getDependsEntryList()
     */
    public DependsEntryList getDependsEntryList() {
        return fDepends;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#setEnd(java.lang.String)
     */
    public void setEnd(String string) {
        fEnd = string;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#setName(java.lang.String)
     */
    public void setName(String string) {
       fName = string;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IEntry#setRGB(org.eclipse.swt.graphics.RGB)
     */
    public void setRGB(RGB newRgb) {
        this.fRGB = newRgb;
    }
    
    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.styleeditor.entry.IEntry#setRule(jp.sourceforge.jeextension.styleeditor.text.IExtRule)
     */
    public void setRule(IExtRule rule) {
        fRule = rule;
    }

    /**
     * {@inheritDoc}
     * @see jp.sourceforge.jeextension.editor.entry.IPartitionEntry#setStart(java.lang.String)
     */
    public void setStart(String string) {
        fStart = string;
    }

}
