/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.LiteralAttribute;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.Variable;
import org.apache.xalan.xsltc.compiler.XslElement;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class LiteralElement
extends Instruction {
    private String _name;
    private LiteralElement _literalElemParent;
    private Vector _attributeElements = null;
    private Hashtable _accessedPrefixes = null;
    private static final String XMLNS_STRING = "xmlns";

    LiteralElement() {
    }

    public QName getName() {
        return this._qname;
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("LiteralElement name = " + this._name);
        this.displayContents(indent + 4);
    }

    private String accessedNamespace(String prefix) {
        if (this._accessedPrefixes == null) {
            return null;
        }
        return (String)this._accessedPrefixes.get(prefix);
    }

    public void registerNamespace(String prefix, String uri, SymbolTable stable, boolean declared) {
        String old;
        if (this._literalElemParent != null) {
            String parentUri = this._literalElemParent.accessedNamespace(prefix);
            if (parentUri == null) {
                this._literalElemParent.registerNamespace(prefix, uri, stable, declared);
                return;
            }
            if (parentUri.equals(uri)) {
                return;
            }
        }
        if (this._accessedPrefixes == null) {
            this._accessedPrefixes = new Hashtable();
        } else if (!declared && (old = (String)this._accessedPrefixes.get(prefix)) != null) {
            if (old.equals(uri)) {
                return;
            }
            prefix = stable.generateNamespacePrefix();
        }
        if (!prefix.equals("xml")) {
            this._accessedPrefixes.put(prefix, uri);
        }
    }

    private String translateQName(QName qname, SymbolTable stable) {
        String uri;
        String localname = qname.getLocalPart();
        String prefix = qname.getPrefix();
        if (prefix == null) {
            prefix = "";
        } else if (prefix.equals(XMLNS_STRING)) {
            return XMLNS_STRING;
        }
        String alternative = stable.lookupPrefixAlias(prefix);
        if (alternative != null) {
            stable.excludeNamespaces(prefix);
            prefix = alternative;
        }
        if ((uri = this.lookupNamespace(prefix)) == null) {
            return localname;
        }
        this.registerNamespace(prefix, uri, stable, false);
        if (prefix != "") {
            return prefix + ":" + localname;
        }
        return localname;
    }

    public void addAttribute(SyntaxTreeNode attribute) {
        if (this._attributeElements == null) {
            this._attributeElements = new Vector(2);
        }
        this._attributeElements.add(attribute);
    }

    public void setFirstAttribute(SyntaxTreeNode attribute) {
        if (this._attributeElements == null) {
            this._attributeElements = new Vector(2);
        }
        this._attributeElements.insertElementAt(attribute, 0);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._attributeElements != null) {
            int count = this._attributeElements.size();
            int i = 0;
            while (i < count) {
                SyntaxTreeNode node = (SyntaxTreeNode)this._attributeElements.elementAt(i);
                node.typeCheck(stable);
                ++i;
            }
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public Enumeration getNamespaceScope(SyntaxTreeNode node) {
        Hashtable all = new Hashtable();
        while (node != null) {
            Hashtable mapping = node.getPrefixMapping();
            if (mapping != null) {
                Enumeration prefixes = mapping.keys();
                while (prefixes.hasMoreElements()) {
                    String prefix = (String)prefixes.nextElement();
                    if (all.containsKey(prefix)) continue;
                    all.put(prefix, mapping.get(prefix));
                }
            }
            node = node.getParent();
        }
        return all.keys();
    }

    public void parseContents(Parser parser) {
        SymbolTable stable = parser.getSymbolTable();
        stable.setCurrentNode(this);
        SyntaxTreeNode _literalElemParent = this.getParent();
        while (_literalElemParent != null && !(_literalElemParent instanceof LiteralElement)) {
            _literalElemParent = _literalElemParent.getParent();
        }
        if (!(_literalElemParent instanceof LiteralElement)) {
            _literalElemParent = null;
        }
        this._name = this.translateQName(this._qname, stable);
        int count = this._attributes.getLength();
        int i = 0;
        while (i < count) {
            QName qname = parser.getQName(this._attributes.getQName(i));
            String uri = qname.getNamespace();
            String val = this._attributes.getValue(i);
            if (qname == parser.getUseAttributeSets()) {
                this.setFirstAttribute(new UseAttributeSets(val, parser));
            } else if (qname == parser.getExtensionElementPrefixes()) {
                stable.excludeNamespaces(val);
            } else if (qname == parser.getExcludeResultPrefixes()) {
                stable.excludeNamespaces(val);
            } else {
                String prefix = qname.getPrefix();
                if (!(prefix != null && prefix.equals(XMLNS_STRING) || prefix == null && qname.getLocalPart().equals(XMLNS_STRING) || uri != null && uri.equals("http://www.w3.org/1999/XSL/Transform"))) {
                    String name = this.translateQName(qname, stable);
                    LiteralAttribute attr = new LiteralAttribute(name, val, parser);
                    this.addAttribute(attr);
                    attr.setParent(this);
                    attr.parseContents(parser);
                }
            }
            ++i;
        }
        Enumeration include = this.getNamespaceScope(this);
        while (include.hasMoreElements()) {
            String uri;
            String prefix = (String)include.nextElement();
            if (prefix.equals("xml") || (uri = this.lookupNamespace(prefix)) == null || stable.isExcludedNamespace(uri)) continue;
            this.registerNamespace(prefix, uri, stable, true);
        }
        this.parseChildren(parser);
        int i2 = 0;
        while (i2 < count) {
            QName qname = parser.getQName(this._attributes.getQName(i2));
            String val = this._attributes.getValue(i2);
            if (qname == parser.getExtensionElementPrefixes()) {
                stable.unExcludeNamespaces(val);
            } else if (qname == parser.getExcludeResultPrefixes()) {
                stable.unExcludeNamespaces(val);
            }
            ++i2;
        }
    }

    protected boolean contextDependent() {
        return this.dependentContents();
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        il.append(methodGen.loadHandler());
        il.append(new PUSH(cpg, this._name));
        il.append(InstructionConstants.DUP2);
        il.append(methodGen.startElement());
        int i = 0;
        while (i < this.elementCount()) {
            SyntaxTreeNode item = (SyntaxTreeNode)this.elementAt(i);
            if (item instanceof Variable) {
                item.translate(classGen, methodGen);
                this.removeElement(item);
            }
            ++i;
        }
        if (this._accessedPrefixes != null) {
            boolean declaresDefaultNS = false;
            Enumeration e = this._accessedPrefixes.keys();
            while (e.hasMoreElements()) {
                String prefix = (String)e.nextElement();
                String uri = (String)this._accessedPrefixes.get(prefix);
                if (uri == "" && prefix == "") continue;
                if (prefix == "") {
                    declaresDefaultNS = true;
                }
                il.append(methodGen.loadHandler());
                il.append(new PUSH(cpg, prefix));
                il.append(new PUSH(cpg, uri));
                il.append(methodGen.namespace());
            }
            if (!declaresDefaultNS && this._parent instanceof XslElement && ((XslElement)this._parent).declaresDefaultNS()) {
                il.append(methodGen.loadHandler());
                il.append(new PUSH(cpg, ""));
                il.append(new PUSH(cpg, ""));
                il.append(methodGen.namespace());
            }
        }
        if (this._attributeElements != null) {
            int count = this._attributeElements.size();
            int i2 = 0;
            while (i2 < count) {
                SyntaxTreeNode node = (SyntaxTreeNode)this._attributeElements.elementAt(i2);
                node.translate(classGen, methodGen);
                ++i2;
            }
        }
        this.translateContents(classGen, methodGen);
        il.append(methodGen.endElement());
    }
}

