/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.common.xml;

import java.io.File;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.common.xml.XMLReader;
import jp.sourceforge.jeextension.common.xml.XMLWriter;
import org.w3c.dom.Document;

public class XMLFile {
    protected File currentFile;
    protected String fileEncoding;

    public XMLFile(String string) {
        this(string, System.getProperty("file.encoding"));
    }

    public XMLFile(String string, String string2) {
        this(new File(string.replace('/', File.separatorChar)), string2);
    }

    public XMLFile(File file) {
        this(file, System.getProperty("file.encoding"));
    }

    public XMLFile(File file, String string) {
        this.fileEncoding = string;
        this.currentFile = file;
        if (this.currentFile.isDirectory()) {
            throw new IllegalArgumentException(file.getPath() + " isn't File object." + " can't initiate except file path.");
        }
    }

    public File getFile() {
        return this.currentFile;
    }

    public void writeDocument(Document document) throws XMLException {
        XMLWriter xMLWriter = new XMLWriter(this.fileEncoding);
        xMLWriter.write(this.currentFile, document);
    }

    public void writeNode(XMLNode xMLNode) throws XMLException {
        XMLWriter xMLWriter = new XMLWriter(this.fileEncoding);
        xMLWriter.write(this.currentFile, xMLNode);
    }

    public XMLNode readNode() throws XMLException {
        XMLReader xMLReader = new XMLReader(this.fileEncoding);
        return xMLReader.readAsXMLNode(this.currentFile);
    }

    public Document readDocument() throws XMLException {
        XMLReader xMLReader = new XMLReader(this.fileEncoding);
        return xMLReader.readAsDocument(this.currentFile);
    }
}

