/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.preferences;

import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntry;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class AddPartitionDialog
extends DefaultDialog {
    private ColorSelector fColorSel;
    private Label fLabelEnd;
    private Label fLabelKwd;
    private Label fLabelStr;
    private IPartitionEntry[] fStyleContainer;
    private IPartitionEntry fStyleEntry;
    private Text fTextEnd;
    private Text fTextNme;
    private Text fTextStr;
    private Button fCheckBase;
    private String fExtension;

    AddPartitionDialog(Shell shell, IPartitionEntry[] container, String ext) {
        super(shell);
        this.fStyleEntry = container[0];
        this.fStyleContainer = container;
        this.fExtension = ext;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.fCheckBase) {
            if (this.fCheckBase.getSelection()) {
                this.fTextStr.setText("");
                this.fTextEnd.setText("");
                this.fTextNme.setText("__dftl_partition_content_type");
                this.fTextStr.setEnabled(false);
                this.fTextEnd.setEnabled(false);
                this.fTextNme.setEnabled(false);
            } else {
                this.fTextStr.setEnabled(true);
                this.fTextEnd.setEnabled(true);
                this.fTextNme.setEnabled(true);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.fCheckBase = new Button(composite, 32);
        this.fCheckBase.setText(this.getMessage("pref.partition.dlg.base"));
        this.fCheckBase.setSelection(false);
        this.fCheckBase.addListener(13, (Listener)this);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fCheckBase.setLayoutData((Object)gridData);
        this.fLabelStr = new Label(composite, 0);
        this.fLabelStr.setText(this.getMessage("pref.partition.dlg.start"));
        this.fTextStr = new Text(composite, 2048);
        this.fTextStr.setLayoutData((Object)new GridData(768));
        this.fLabelEnd = new Label(composite, 0);
        this.fLabelEnd.setText(this.getMessage("pref.partition.dlg.end"));
        this.fTextEnd = new Text(composite, 2048);
        this.fTextEnd.setLayoutData((Object)new GridData(768));
        this.fLabelKwd = new Label(composite, 0);
        this.fLabelKwd.setText(this.getMessage("pref.partition.dlg.name"));
        this.fTextNme = new Text(composite, 2048);
        this.fTextNme.setLayoutData((Object)new GridData(768));
        Label cLabelClr = new Label(composite, 0);
        cLabelClr.setText(this.getMessage("pref.partition.dlg.color"));
        this.fColorSel = new ColorSelector(composite);
        this.fColorSel.setColorValue(new RGB(0, 0, 0));
        if (this.fStyleEntry != null) {
            PartitionEntry pe = (PartitionEntry)this.fStyleEntry;
            this.fTextStr.setText(pe.getStart());
            this.fTextEnd.setText(pe.getEnd());
            this.fTextNme.setText(pe.getName());
            this.fColorSel.setColorValue(this.fStyleEntry.getRGB());
        }
        return composite;
    }

    protected void okPressed() {
        RGB rgb = this.fColorSel.getColorValue();
        XMLNode node = new XMLNode("partition");
        node.setAttribute("name", this.fTextNme.getText());
        node.setAttribute("red", String.valueOf(rgb.red));
        node.setAttribute("green", String.valueOf(rgb.green));
        node.setAttribute("blue", String.valueOf(rgb.blue));
        node.setAttribute("start", this.fTextStr.getText());
        node.setAttribute("end", this.fTextEnd.getText());
        if (this.fStyleEntry == null) {
            this.fStyleEntry = new PartitionEntry(node, this.fExtension);
        } else {
            EditorTools.changePartitionEntry(this.fStyleEntry, node, this.fExtension);
        }
        this.fStyleContainer[0] = this.fStyleEntry;
        super.okPressed();
    }
}

