/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.core;

import jp.sourceforge.jeextension.styleeditor.core.ColorManager;
import jp.sourceforge.jeextension.styleeditor.core.DoubleClickStrategy;
import jp.sourceforge.jeextension.styleeditor.core.EditorTools;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditor;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.entry.PartitionEntryList;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

class EditorConfiguration
extends SourceViewerConfiguration {
    private ColorManager fColorManager = new ColorManager();
    private DoubleClickStrategy fDoubleClickStrategy;
    private EditorTools fEditorTools;
    private StyleEditor fStyleEditor;

    EditorConfiguration(StyleEditor styleEditor) {
        this.fStyleEditor = styleEditor;
    }

    public ColorManager getColorManager() {
        return this.fColorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.getTool().getContentTypes(this.fStyleEditor.getFileExtension());
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new DoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        String ext = this.fStyleEditor.getFileExtension();
        EditorTools tools = this.getTool();
        RuleBasedScanner scanner = tools.createScanner("__dftl_partition_content_type", ext);
        scanner.setDefaultReturnToken(tools.getDefaultToken());
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        PartitionEntryList list = EditorTools.getPartitionEntryList(ext, false);
        int i = 0;
        while (i < list.size()) {
            IPartitionEntry pe = list.getPartitionEntry(i);
            String partName = pe.getName();
            RuleBasedScanner scanner2 = tools.createScanner(partName, ext);
            scanner2.setDefaultReturnToken(tools.getDefaultToken(pe));
            DefaultDamagerRepairer dr2 = new DefaultDamagerRepairer((ITokenScanner)scanner2);
            reconciler.setDamager((IPresentationDamager)dr2, partName);
            reconciler.setRepairer((IPresentationRepairer)dr2, partName);
            ++i;
        }
        return reconciler;
    }

    private EditorTools getTool() {
        if (this.fEditorTools == null) {
            this.fEditorTools = new EditorTools(this);
        }
        return this.fEditorTools;
    }
}

