/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.CHOOSEFONT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell parent) {
        this(parent, 32768);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        boolean success;
        int hDC;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int hwndOwner = 0;
        if (this.parent != null) {
            hwndOwner = this.parent.handle;
        }
        int hHeap = OS.GetProcessHeap();
        CHOOSEFONT lpcf = new CHOOSEFONT();
        lpcf.lStructSize = 60;
        lpcf.hwndOwner = hwndOwner;
        lpcf.Flags = 257;
        int lpLogFont = OS.HeapAlloc(hHeap, 8, LOGFONT.sizeof);
        if (this.fontData != null && this.fontData.data != null) {
            LOGFONT logFont = this.fontData.data;
            int lfHeight = logFont.lfHeight;
            hDC = OS.GetDC(0);
            int pixels = -Compatibility.round(this.fontData.height * OS.GetDeviceCaps(hDC, 90), 72);
            OS.ReleaseDC(0, hDC);
            logFont.lfHeight = pixels;
            lpcf.Flags |= 0x40;
            OS.MoveMemory(lpLogFont, logFont, LOGFONT.sizeof);
            logFont.lfHeight = lfHeight;
        }
        lpcf.lpLogFont = lpLogFont;
        if (this.rgb != null) {
            int red = this.rgb.red & 0xFF;
            int green = this.rgb.green << 8 & 0xFF00;
            int blue = this.rgb.blue << 16 & 0xFF0000;
            lpcf.rgbColors = red | green | blue;
        }
        if (success = OS.ChooseFont(lpcf)) {
            LOGFONT logFont = new LOGFONT();
            OS.MoveMemory(logFont, lpLogFont, LOGFONT.sizeof);
            hDC = OS.GetDC(0);
            int logPixelsY = OS.GetDeviceCaps(hDC, 90);
            int pixels = 0;
            if (logFont.lfHeight > 0) {
                int hFont = OS.CreateFontIndirect(logFont);
                int oldFont = OS.SelectObject(hDC, hFont);
                TEXTMETRIC lptm = new TEXTMETRIC();
                OS.GetTextMetrics(hDC, lptm);
                OS.SelectObject(hDC, oldFont);
                OS.DeleteObject(hFont);
                pixels = logFont.lfHeight - lptm.tmInternalLeading;
            } else {
                pixels = -logFont.lfHeight;
            }
            OS.ReleaseDC(0, hDC);
            int points = Compatibility.round(pixels * 72, logPixelsY);
            this.fontData = FontData.win32_new(logFont, points);
            int red = lpcf.rgbColors & 0xFF;
            int green = lpcf.rgbColors >> 8 & 0xFF;
            int blue = lpcf.rgbColors >> 16 & 0xFF;
            this.rgb = new RGB(red, green, blue);
        }
        if (lpLogFont != 0) {
            OS.HeapFree(hHeap, 0, lpLogFont);
        }
        if (!success) {
            return null;
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

