/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IAccessible;
import org.eclipse.swt.internal.ole.win32.IEnumVARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;

public class Accessible {
    int refCount = 0;
    int enumIndex = 0;
    COMObject objIAccessible;
    COMObject objIEnumVARIANT;
    IAccessible iaccessible;
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Object[] variants;
    Control control;

    Accessible(Control control) {
        this.control = control;
        int[] ppvObject = new int[1];
        int result = COM.CreateStdAccessibleObject(control.handle, -4, COM.IIDIAccessible, ppvObject);
        if (result == -2147467263) {
            return;
        }
        if (result != 0) {
            OLE.error(1001, result);
        }
        this.iaccessible = new IAccessible(ppvObject[0]);
        this.iaccessible.AddRef();
        int[] nArray = new int[28];
        nArray[0] = 2;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 5;
        nArray[6] = 8;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 5;
        nArray[10] = 5;
        nArray[11] = 5;
        nArray[12] = 5;
        nArray[13] = 5;
        nArray[14] = 5;
        nArray[15] = 5;
        nArray[16] = 6;
        nArray[17] = 5;
        nArray[18] = 1;
        nArray[19] = 1;
        nArray[20] = 5;
        nArray[21] = 5;
        nArray[22] = 8;
        nArray[23] = 6;
        nArray[24] = 3;
        nArray[25] = 4;
        nArray[26] = 5;
        nArray[27] = 5;
        this.objIAccessible = new COMObject(nArray){

            public int method0(int[] args) {
                return Accessible.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] args) {
                return Accessible.this.Release();
            }

            public int method7(int[] args) {
                return Accessible.this.get_accParent(args[0]);
            }

            public int method8(int[] args) {
                return Accessible.this.get_accChildCount(args[0]);
            }

            public int method9(int[] args) {
                return Accessible.this.get_accChild(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method10(int[] args) {
                return Accessible.this.get_accName(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method11(int[] args) {
                return Accessible.this.get_accValue(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method12(int[] args) {
                return Accessible.this.get_accDescription(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method13(int[] args) {
                return Accessible.this.get_accRole(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method14(int[] args) {
                return Accessible.this.get_accState(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method15(int[] args) {
                return Accessible.this.get_accHelp(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method16(int[] args) {
                return Accessible.this.get_accHelpTopic(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            public int method17(int[] args) {
                return Accessible.this.get_accKeyboardShortcut(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method18(int[] args) {
                return Accessible.this.get_accFocus(args[0]);
            }

            public int method19(int[] args) {
                return Accessible.this.get_accSelection(args[0]);
            }

            public int method20(int[] args) {
                return Accessible.this.get_accDefaultAction(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method21(int[] args) {
                return Accessible.this.accSelect(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method22(int[] args) {
                return Accessible.this.accLocation(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
            }

            public int method23(int[] args) {
                return Accessible.this.accNavigate(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            public int method24(int[] args) {
                return Accessible.this.accHitTest(args[0], args[1], args[2]);
            }

            public int method25(int[] args) {
                return Accessible.this.accDoDefaultAction(args[0], args[1], args[2], args[3]);
            }

            public int method26(int[] args) {
                return Accessible.this.put_accName(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method27(int[] args) {
                return Accessible.this.put_accValue(args[0], args[1], args[2], args[3], args[4]);
            }
        };
        int[] nArray2 = new int[7];
        nArray2[0] = 2;
        nArray2[3] = 3;
        nArray2[4] = 1;
        nArray2[6] = 1;
        this.objIEnumVARIANT = new COMObject(nArray2){

            public int method0(int[] args) {
                return Accessible.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] args) {
                return Accessible.this.Release();
            }

            public int method3(int[] args) {
                return Accessible.this.Next(args[0], args[1], args[2]);
            }

            public int method4(int[] args) {
                return Accessible.this.Skip(args[0]);
            }

            public int method5(int[] args) {
                return Accessible.this.Reset();
            }
        };
        this.AddRef();
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    public void addAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(listener);
    }

    public void removeAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(listener);
    }

    public void addAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(listener);
    }

    public void removeAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(listener);
    }

    public void setFocus(int childID) {
        this.checkWidget();
        int id = childID == -1 ? 0 : (this.control instanceof Tree ? childID : childID + 1);
        COM.NotifyWinEvent(32773, this.control.handle, -4, id);
    }

    public void internal_dispose_Accessible() {
        if (this.iaccessible != null) {
            this.iaccessible.Release();
        }
        this.iaccessible = null;
        this.Release();
    }

    public int internal_WM_GETOBJECT(int wParam, int lParam) {
        if (this.objIAccessible == null) {
            return 0;
        }
        if (lParam == -4) {
            return COM.LresultFromObject(COM.IIDIAccessible, wParam, this.objIAccessible.getAddress());
        }
        return 0;
    }

    int QueryInterface(int arg1, int arg2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, arg1, 16);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown)) {
            OS.MoveMemory(arg2, new int[]{this.objIAccessible.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, COM.IIDIDispatch)) {
            OS.MoveMemory(arg2, new int[]{this.objIAccessible.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, COM.IIDIAccessible)) {
            OS.MoveMemory(arg2, new int[]{this.objIAccessible.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, COM.IIDIEnumVARIANT)) {
            OS.MoveMemory(arg2, new int[]{this.objIEnumVARIANT.getAddress()}, 4);
            this.AddRef();
            this.enumIndex = 0;
            return 0;
        }
        int[] ppvObject = new int[1];
        int result = this.iaccessible.QueryInterface(guid, ppvObject);
        OS.MoveMemory(arg2, ppvObject, 4);
        return result;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.objIAccessible != null) {
                this.objIAccessible.dispose();
            }
            this.objIAccessible = null;
            if (this.objIEnumVARIANT != null) {
                this.objIEnumVARIANT.dispose();
            }
            this.objIEnumVARIANT = null;
        }
        return this.refCount;
    }

    int accDoDefaultAction(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int code = this.iaccessible.accDoDefaultAction(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2);
        if (code == -2147024809) {
            code = 1;
        }
        return code;
    }

    int accHitTest(int xLeft, int yTop, int pvarChild) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return this.iaccessible.accHitTest(xLeft, yTop, pvarChild);
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = -2;
        event.x = xLeft;
        event.y = yTop;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getChildAtPoint(event);
            ++i;
        }
        int childID = event.childID;
        if (childID == -2) {
            return this.iaccessible.accHitTest(xLeft, yTop, pvarChild);
        }
        if (childID == -1) {
            childID = 0;
        } else if (!(this.control instanceof Tree)) {
            // empty if block
        }
        OS.MoveMemory(pvarChild, new short[]{3}, 2);
        OS.MoveMemory(pvarChild + 8, new int[]{++childID}, 4);
        return 0;
    }

    int accLocation(int pxLeft, int pyTop, int pcxWidth, int pcyHeight, int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if ((varChild_vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        int osLeft = 0;
        int osTop = 0;
        int osWidth = 0;
        int osHeight = 0;
        int code = this.iaccessible.accLocation(pxLeft, pyTop, pcxWidth, pcyHeight, varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2);
        if (code == -2147024809) {
            code = 1;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return code;
        }
        if (code == 0) {
            int[] pLeft = new int[1];
            int[] pTop = new int[1];
            int[] pWidth = new int[1];
            int[] pHeight = new int[1];
            OS.MoveMemory(pLeft, pxLeft, 4);
            OS.MoveMemory(pTop, pyTop, 4);
            OS.MoveMemory(pWidth, pcxWidth, 4);
            OS.MoveMemory(pHeight, pcyHeight, 4);
            osLeft = pLeft[0];
            osTop = pTop[0];
            osWidth = pWidth[0];
            osHeight = pHeight[0];
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = varChild_lVal == 0 ? -1 : (this.control instanceof Tree ? varChild_lVal : varChild_lVal - 1);
        event.x = osLeft;
        event.y = osTop;
        event.width = osWidth;
        event.height = osHeight;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getLocation(event);
            ++i;
        }
        OS.MoveMemory(pxLeft, new int[]{event.x}, 4);
        OS.MoveMemory(pyTop, new int[]{event.y}, 4);
        OS.MoveMemory(pcxWidth, new int[]{event.width}, 4);
        OS.MoveMemory(pcyHeight, new int[]{event.height}, 4);
        return 0;
    }

    int accNavigate(int navDir, int varStart_vt, int varStart_reserved1, int varStart_lVal, int varStart_reserved2, int pvarEndUpAt) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int code = this.iaccessible.accNavigate(navDir, varStart_vt, varStart_reserved1, varStart_lVal, varStart_reserved2, pvarEndUpAt);
        if (code == -2147024809) {
            code = 1;
        }
        return code;
    }

    int accSelect(int flagsSelect, int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int code = this.iaccessible.accSelect(flagsSelect, varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2);
        if (code == -2147024809) {
            code = 1;
        }
        return code;
    }

    int get_accChild(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int ppdispChild) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if ((varChild_vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        if (this.accessibleControlListeners.size() == 0) {
            int code = this.iaccessible.get_accChild(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, ppdispChild);
            if (code == -2147024809) {
                code = 1;
            }
            return code;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = varChild_lVal == 0 ? -1 : (this.control instanceof Tree ? varChild_lVal : varChild_lVal - 1);
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getChild(event);
            ++i;
        }
        Accessible accessible = event.accessible;
        if (accessible != null) {
            OS.MoveMemory(ppdispChild, new int[]{accessible.objIAccessible.getAddress()}, 4);
            return 0;
        }
        return 1;
    }

    int get_accChildCount(int pcountChildren) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int osChildCount = 0;
        int code = this.iaccessible.get_accChildCount(pcountChildren);
        if (this.accessibleControlListeners.size() == 0) {
            return code;
        }
        if (code == 0) {
            int[] pChildCount = new int[1];
            OS.MoveMemory(pChildCount, pcountChildren, 4);
            osChildCount = pChildCount[0];
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = -1;
        event.detail = osChildCount;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getChildCount(event);
            ++i;
        }
        OS.MoveMemory(pcountChildren, new int[]{event.detail}, 4);
        return 0;
    }

    int get_accDefaultAction(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int pszDefaultAction) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if ((varChild_vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String osDefaultAction = null;
        int code = this.iaccessible.get_accDefaultAction(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, pszDefaultAction);
        if (code == -2147024809) {
            code = 1;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return code;
        }
        if (code == 0) {
            int[] pDefaultAction = new int[1];
            OS.MoveMemory(pDefaultAction, pszDefaultAction, 4);
            int size = COM.SysStringByteLen(pDefaultAction[0]);
            if (size > 0) {
                char[] buffer = new char[(size + 1) / 2];
                OS.MoveMemory(buffer, pDefaultAction[0], size);
                osDefaultAction = new String(buffer);
            }
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = varChild_lVal == 0 ? -1 : (this.control instanceof Tree ? varChild_lVal : varChild_lVal - 1);
        event.result = osDefaultAction;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getDefaultAction(event);
            ++i;
        }
        if (event.result == null) {
            return code;
        }
        char[] data = (String.valueOf(event.result) + "\u0000").toCharArray();
        int ptr = COM.SysAllocString(data);
        OS.MoveMemory(pszDefaultAction, new int[]{ptr}, 4);
        return 0;
    }

    int get_accDescription(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int pszDescription) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if ((varChild_vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String osDescription = null;
        int code = this.iaccessible.get_accDescription(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, pszDescription);
        if (code == -2147024809) {
            code = 1;
        }
        if (this.accessibleListeners.size() == 0) {
            return code;
        }
        if (code == 0) {
            int[] pDescription = new int[1];
            OS.MoveMemory(pDescription, pszDescription, 4);
            int size = COM.SysStringByteLen(pDescription[0]);
            if (size > 0) {
                char[] buffer = new char[(size + 1) / 2];
                OS.MoveMemory(buffer, pDescription[0], size);
                osDescription = new String(buffer);
            }
        }
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = varChild_lVal == 0 ? -1 : (this.control instanceof Tree ? varChild_lVal : varChild_lVal - 1);
        event.result = osDescription;
        int i = 0;
        while (i < this.accessibleListeners.size()) {
            AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i);
            listener.getDescription(event);
            ++i;
        }
        if (event.result == null) {
            return code;
        }
        char[] data = (String.valueOf(event.result) + "\u0000").toCharArray();
        int ptr = COM.SysAllocString(data);
        OS.MoveMemory(pszDescription, new int[]{ptr}, 4);
        return 0;
    }

    int get_accFocus(int pvarChild) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int osChild = -2;
        int code = this.iaccessible.get_accFocus(pvarChild);
        if (this.accessibleControlListeners.size() == 0) {
            return code;
        }
        if (code == 0) {
            short[] pvt = new short[1];
            OS.MoveMemory(pvt, pvarChild, 2);
            if (pvt[0] == 3) {
                int[] pChild = new int[1];
                OS.MoveMemory(pChild, pvarChild + 8, 4);
                osChild = pChild[0] == 0 ? -1 : pChild[0] - 1;
            }
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = osChild;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getFocus(event);
            ++i;
        }
        Accessible accessible = event.accessible;
        if (accessible != null) {
            OS.MoveMemory(pvarChild, new short[]{9}, 2);
            OS.MoveMemory(pvarChild + 8, new int[]{accessible.objIAccessible.getAddress()}, 4);
            return 0;
        }
        int childID = event.childID;
        if (childID == -2) {
            OS.MoveMemory(pvarChild, new short[1], 2);
            return 1;
        }
        if (childID == -1) {
            OS.MoveMemory(pvarChild, new short[]{9}, 2);
            OS.MoveMemory(pvarChild + 8, new int[]{this.objIAccessible.getAddress()}, 4);
            return 0;
        }
        OS.MoveMemory(pvarChild, new short[]{3}, 2);
        OS.MoveMemory(pvarChild + 8, new int[]{childID + 1}, 4);
        return 0;
    }

    int get_accHelp(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int pszHelp) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if ((varChild_vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String osHelp = null;
        int code = this.iaccessible.get_accHelp(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, pszHelp);
        if (code == -2147024809) {
            code = 1;
        }
        if (this.accessibleListeners.size() == 0) {
            return code;
        }
        if (code == 0) {
            int[] pHelp = new int[1];
            OS.MoveMemory(pHelp, pszHelp, 4);
            int size = COM.SysStringByteLen(pHelp[0]);
            if (size > 0) {
                char[] buffer = new char[(size + 1) / 2];
                OS.MoveMemory(buffer, pHelp[0], size);
                osHelp = new String(buffer);
            }
        }
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = varChild_lVal == 0 ? -1 : (this.control instanceof Tree ? varChild_lVal : varChild_lVal - 1);
        event.result = osHelp;
        int i = 0;
        while (i < this.accessibleListeners.size()) {
            AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i);
            listener.getHelp(event);
            ++i;
        }
        if (event.result == null) {
            return code;
        }
        char[] data = (String.valueOf(event.result) + "\u0000").toCharArray();
        int ptr = COM.SysAllocString(data);
        OS.MoveMemory(pszHelp, new int[]{ptr}, 4);
        return 0;
    }

    int get_accHelpTopic(int pszHelpFile, int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int pidTopic) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int code = this.iaccessible.get_accHelpTopic(pszHelpFile, varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, pidTopic);
        if (code == -2147024809) {
            code = 1;
        }
        return code;
    }

    int get_accKeyboardShortcut(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int pszKeyboardShortcut) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if ((varChild_vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String osKeyboardShortcut = null;
        int code = this.iaccessible.get_accKeyboardShortcut(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, pszKeyboardShortcut);
        if (code == -2147024809) {
            code = 1;
        }
        if (this.accessibleListeners.size() == 0) {
            return code;
        }
        if (code == 0) {
            int[] pKeyboardShortcut = new int[1];
            OS.MoveMemory(pKeyboardShortcut, pszKeyboardShortcut, 4);
            int size = COM.SysStringByteLen(pKeyboardShortcut[0]);
            if (size > 0) {
                char[] buffer = new char[(size + 1) / 2];
                OS.MoveMemory(buffer, pKeyboardShortcut[0], size);
                osKeyboardShortcut = new String(buffer);
            }
        }
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = varChild_lVal == 0 ? -1 : (this.control instanceof Tree ? varChild_lVal : varChild_lVal - 1);
        event.result = osKeyboardShortcut;
        int i = 0;
        while (i < this.accessibleListeners.size()) {
            AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i);
            listener.getKeyboardShortcut(event);
            ++i;
        }
        if (event.result == null) {
            return code;
        }
        char[] data = (String.valueOf(event.result) + "\u0000").toCharArray();
        int ptr = COM.SysAllocString(data);
        OS.MoveMemory(pszKeyboardShortcut, new int[]{ptr}, 4);
        return 0;
    }

    int get_accName(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int pszName) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if ((varChild_vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String osName = null;
        int code = this.iaccessible.get_accName(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, pszName);
        if (code == -2147024809) {
            code = 1;
        }
        if (this.accessibleListeners.size() == 0) {
            return code;
        }
        if (code == 0) {
            int[] pName = new int[1];
            OS.MoveMemory(pName, pszName, 4);
            int size = COM.SysStringByteLen(pName[0]);
            if (size > 0) {
                char[] buffer = new char[(size + 1) / 2];
                OS.MoveMemory(buffer, pName[0], size);
                osName = new String(buffer);
            }
        }
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = varChild_lVal == 0 ? -1 : (this.control instanceof Tree ? varChild_lVal : varChild_lVal - 1);
        event.result = osName;
        int i = 0;
        while (i < this.accessibleListeners.size()) {
            AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i);
            listener.getName(event);
            ++i;
        }
        if (event.result == null) {
            return code;
        }
        char[] data = (String.valueOf(event.result) + "\u0000").toCharArray();
        int ptr = COM.SysAllocString(data);
        OS.MoveMemory(pszName, new int[]{ptr}, 4);
        return 0;
    }

    int get_accParent(int ppdispParent) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        return this.iaccessible.get_accParent(ppdispParent);
    }

    int get_accRole(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int pvarRole) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if ((varChild_vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        int osRole = 10;
        int code = this.iaccessible.get_accRole(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, pvarRole);
        if (code == -2147024809) {
            code = 1;
        }
        if (this.accessibleControlListeners.size() == 0 && !(this.control instanceof Tree) && !(this.control instanceof Table)) {
            return code;
        }
        if (code == 0) {
            short[] pvt = new short[1];
            OS.MoveMemory(pvt, pvarRole, 2);
            if (pvt[0] == 3) {
                int[] pRole = new int[1];
                OS.MoveMemory(pRole, pvarRole + 8, 4);
                osRole = pRole[0];
            }
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.detail = this.osToRole(osRole);
        if (varChild_lVal == 0) {
            event.childID = -1;
        } else if (this.control instanceof Tree) {
            event.childID = varChild_lVal;
            if ((this.control.getStyle() & 0x20) != 0) {
                event.detail = 44;
            }
        } else if (this.control instanceof Table) {
            event.childID = varChild_lVal - 1;
            if ((this.control.getStyle() & 0x20) != 0) {
                event.detail = 44;
            }
        } else {
            event.childID = varChild_lVal - 1;
        }
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            ++i;
        }
        int role = this.roleToOs(event.detail);
        OS.MoveMemory(pvarRole, new short[]{3}, 2);
        OS.MoveMemory(pvarRole + 8, new int[]{role}, 4);
        return 0;
    }

    int get_accSelection(int pvarChildren) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int osChild = -2;
        int code = this.iaccessible.get_accSelection(pvarChildren);
        if (this.accessibleControlListeners.size() == 0) {
            return code;
        }
        if (code == 0) {
            short[] pvt = new short[1];
            OS.MoveMemory(pvt, pvarChildren, 2);
            if (pvt[0] == 3) {
                int[] pChild = new int[1];
                OS.MoveMemory(pChild, pvarChildren + 8, 4);
                osChild = pChild[0] == 0 ? -1 : pChild[0] - 1;
            } else if (pvt[0] == 13) {
                osChild = -3;
            }
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = osChild;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getSelection(event);
            ++i;
        }
        Accessible accessible = event.accessible;
        if (accessible != null) {
            OS.MoveMemory(pvarChildren, new short[]{9}, 2);
            OS.MoveMemory(pvarChildren + 8, new int[]{accessible.objIAccessible.getAddress()}, 4);
            return 0;
        }
        int childID = event.childID;
        if (childID == -2) {
            OS.MoveMemory(pvarChildren, new short[1], 2);
            return 1;
        }
        if (childID == -3) {
            OS.MoveMemory(pvarChildren, new short[]{13}, 2);
            OS.MoveMemory(pvarChildren + 8, new int[]{this.objIAccessible.getAddress()}, 4);
            return 0;
        }
        if (childID == -1) {
            OS.MoveMemory(pvarChildren, new short[]{9}, 2);
            OS.MoveMemory(pvarChildren + 8, new int[]{this.objIAccessible.getAddress()}, 4);
            return 0;
        }
        OS.MoveMemory(pvarChildren, new short[]{3}, 2);
        OS.MoveMemory(pvarChildren + 8, new int[]{childID + 1}, 4);
        return 0;
    }

    int get_accState(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int pvarState) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if ((varChild_vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        int osState = 0;
        int code = this.iaccessible.get_accState(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, pvarState);
        if (code == -2147024809) {
            code = 1;
        }
        if (this.accessibleControlListeners.size() == 0 && !(this.control instanceof Tree) && !(this.control instanceof Table)) {
            return code;
        }
        if (code == 0) {
            short[] pvt = new short[1];
            OS.MoveMemory(pvt, pvarState, 2);
            if (pvt[0] == 3) {
                int[] pState = new int[1];
                OS.MoveMemory(pState, pvarState + 8, 4);
                osState = pState[0];
            }
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.detail = this.osToState(osState);
        if (varChild_lVal == 0) {
            event.childID = -1;
        } else if (this.control instanceof Tree) {
            boolean checked;
            event.childID = varChild_lVal;
            int hwnd = this.control.handle;
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 24;
            tvItem.hItem = varChild_lVal;
            tvItem.stateMask = 61440;
            int result = OS.SendMessage(hwnd, OS.TVM_GETITEM, 0, tvItem);
            boolean bl = checked = result != 0 && (tvItem.state >> 12 & 1) == 0;
            if (checked) {
                event.detail |= 0x10;
            }
        } else if (this.control instanceof Table) {
            event.childID = varChild_lVal - 1;
            Table table = (Table)this.control;
            TableItem item = table.getItem(event.childID);
            if (item != null && item.getChecked()) {
                event.detail |= 0x10;
            }
        } else {
            event.childID = varChild_lVal - 1;
        }
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getState(event);
            ++i;
        }
        int state = this.stateToOs(event.detail);
        OS.MoveMemory(pvarState, new short[]{3}, 2);
        OS.MoveMemory(pvarState + 8, new int[]{state}, 4);
        return 0;
    }

    int get_accValue(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int pszValue) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if ((varChild_vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String osValue = null;
        int code = this.iaccessible.get_accValue(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, pszValue);
        if (code == -2147024809) {
            code = 1;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return code;
        }
        if (code == 0) {
            int[] pValue = new int[1];
            OS.MoveMemory(pValue, pszValue, 4);
            int size = COM.SysStringByteLen(pValue[0]);
            if (size > 0) {
                char[] buffer = new char[(size + 1) / 2];
                OS.MoveMemory(buffer, pValue[0], size);
                osValue = new String(buffer);
            }
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = varChild_lVal == 0 ? -1 : (this.control instanceof Tree ? varChild_lVal : varChild_lVal - 1);
        event.result = osValue;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getValue(event);
            ++i;
        }
        if (event.result == null) {
            return code;
        }
        char[] data = (String.valueOf(event.result) + "\u0000").toCharArray();
        int ptr = COM.SysAllocString(data);
        OS.MoveMemory(pszValue, new int[]{ptr}, 4);
        return 0;
    }

    int put_accName(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int szName) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int code = this.iaccessible.put_accName(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, szName);
        if (code == -2147024809) {
            code = 1;
        }
        return code;
    }

    int put_accValue(int varChild_vt, int varChild_reserved1, int varChild_lVal, int varChild_reserved2, int szValue) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int code = this.iaccessible.put_accValue(varChild_vt, varChild_reserved1, varChild_lVal, varChild_reserved2, szValue);
        if (code == -2147024809) {
            code = 1;
        }
        return code;
    }

    int Next(int celt, int rgvar, int pceltFetched) {
        int i;
        if (this.accessibleControlListeners.size() == 0) {
            int[] ppvObject = new int[1];
            int code = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, ppvObject);
            if (code != 0) {
                return code;
            }
            IEnumVARIANT ienumvariant = new IEnumVARIANT(ppvObject[0]);
            int[] celtFetched = new int[1];
            code = ienumvariant.Next(celt, rgvar, celtFetched);
            OS.MoveMemory(pceltFetched, celtFetched, 4);
            return code;
        }
        if (rgvar == 0) {
            return -2147024809;
        }
        if (pceltFetched == 0 && celt != 1) {
            return -2147024809;
        }
        if (this.enumIndex == 0) {
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = -1;
            i = 0;
            while (i < this.accessibleControlListeners.size()) {
                AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
                listener.getChildren(event);
                ++i;
            }
            this.variants = event.children;
        }
        Object[] nextItems = null;
        if (this.variants != null && celt >= 1) {
            int endIndex = this.enumIndex + celt - 1;
            if (endIndex > this.variants.length - 1) {
                endIndex = this.variants.length - 1;
            }
            if (this.enumIndex <= endIndex) {
                nextItems = new Object[endIndex - this.enumIndex + 1];
                int i2 = 0;
                while (i2 < nextItems.length) {
                    Object child = this.variants[this.enumIndex];
                    nextItems[i2] = child instanceof Integer ? new Integer((Integer)child + 1) : child;
                    ++this.enumIndex;
                    ++i2;
                }
            }
        }
        if (nextItems != null) {
            i = 0;
            while (i < nextItems.length) {
                Object nextItem = nextItems[i];
                if (nextItem instanceof Integer) {
                    int item = (Integer)nextItem;
                    OS.MoveMemory(rgvar + i * 16, new short[]{3}, 2);
                    OS.MoveMemory(rgvar + i * 16 + 8, new int[]{item}, 4);
                } else {
                    int address = ((Accessible)nextItem).objIAccessible.getAddress();
                    OS.MoveMemory(rgvar + i * 16, new short[]{9}, 2);
                    OS.MoveMemory(rgvar + i * 16 + 8, new int[]{address}, 4);
                }
                ++i;
            }
            if (pceltFetched != 0) {
                OS.MoveMemory(pceltFetched, new int[]{nextItems.length}, 4);
            }
            if (nextItems.length == celt) {
                return 0;
            }
        } else if (pceltFetched != 0) {
            OS.MoveMemory(pceltFetched, new int[1], 4);
        }
        return 1;
    }

    int Skip(int celt) {
        if (this.accessibleControlListeners.size() == 0) {
            int[] ppvObject = new int[1];
            int code = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, ppvObject);
            if (code != 0) {
                return code;
            }
            IEnumVARIANT ienumvariant = new IEnumVARIANT(ppvObject[0]);
            code = ienumvariant.Skip(celt);
            return code;
        }
        if (celt < 1) {
            return -2147024809;
        }
        this.enumIndex += celt;
        if (this.enumIndex > this.variants.length - 1) {
            this.enumIndex = this.variants.length - 1;
            return 1;
        }
        return 0;
    }

    int Reset() {
        if (this.accessibleControlListeners.size() == 0) {
            int[] ppvObject = new int[1];
            int code = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, ppvObject);
            if (code != 0) {
                return code;
            }
            IEnumVARIANT ienumvariant = new IEnumVARIANT(ppvObject[0]);
            code = ienumvariant.Reset();
            return code;
        }
        this.enumIndex = 0;
        return 0;
    }

    int stateToOs(int state) {
        int osState = 0;
        if ((state & 2) != 0) {
            osState |= 2;
        }
        if ((state & 0x200000) != 0) {
            osState |= 0x200000;
        }
        if ((state & 0x1000000) != 0) {
            osState |= 0x1000000;
        }
        if ((state & 4) != 0) {
            osState |= 4;
        }
        if ((state & 0x100000) != 0) {
            osState |= 0x100000;
        }
        if ((state & 8) != 0) {
            osState |= 8;
        }
        if ((state & 0x10) != 0) {
            osState |= 0x10;
        }
        if ((state & 0x200) != 0) {
            osState |= 0x200;
        }
        if ((state & 0x400) != 0) {
            osState |= 0x400;
        }
        if ((state & 0x80) != 0) {
            osState |= 0x80;
        }
        if ((state & 0x800) != 0) {
            osState |= 0x800;
        }
        if ((state & 0x40) != 0) {
            osState |= 0x40;
        }
        if ((state & 0x8000) != 0) {
            osState |= 0x8000;
        }
        if ((state & 0x10000) != 0) {
            osState |= 0x10000;
        }
        if ((state & 0x20000) != 0) {
            osState |= 0x20000;
        }
        return osState;
    }

    int osToState(int osState) {
        int state = 0;
        if ((osState & 2) != 0) {
            state |= 2;
        }
        if ((osState & 0x200000) != 0) {
            state |= 0x200000;
        }
        if ((osState & 0x1000000) != 0) {
            state |= 0x1000000;
        }
        if ((osState & 4) != 0) {
            state |= 4;
        }
        if ((osState & 0x100000) != 0) {
            state |= 0x100000;
        }
        if ((osState & 8) != 0) {
            state |= 8;
        }
        if ((osState & 0x10) != 0) {
            state |= 0x10;
        }
        if ((osState & 0x200) != 0) {
            state |= 0x200;
        }
        if ((osState & 0x400) != 0) {
            state |= 0x400;
        }
        if ((osState & 0x80) != 0) {
            state |= 0x80;
        }
        if ((osState & 0x800) != 0) {
            state |= 0x800;
        }
        if ((osState & 0x40) != 0) {
            state |= 0x40;
        }
        if ((osState & 0x8000) != 0) {
            state |= 0x8000;
        }
        if ((osState & 0x10000) != 0) {
            state |= 0x10000;
        }
        if ((osState & 0x20000) != 0) {
            state |= 0x20000;
        }
        return state;
    }

    int roleToOs(int role) {
        switch (role) {
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 21: {
                return 21;
            }
            case 13: {
                return 13;
            }
            case 3: {
                return 3;
            }
            case 18: {
                return 18;
            }
            case 41: {
                return 41;
            }
            case 43: {
                return 43;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 46: {
                return 46;
            }
            case 42: {
                return 42;
            }
            case 22: {
                return 22;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 24: {
                return 24;
            }
            case 29: {
                return 29;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 60: {
                return 60;
            }
            case 37: {
                return 37;
            }
            case 48: {
                return 48;
            }
            case 51: {
                return 51;
            }
        }
        return 10;
    }

    int osToRole(int osRole) {
        int role = 10;
        switch (osRole) {
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 21: {
                return 21;
            }
            case 13: {
                return 13;
            }
            case 3: {
                return 3;
            }
            case 18: {
                return 18;
            }
            case 41: {
                return 41;
            }
            case 43: {
                return 43;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 46: {
                return 46;
            }
            case 42: {
                return 42;
            }
            case 22: {
                return 22;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 24: {
                return 24;
            }
            case 29: {
                return 29;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 60: {
                return 60;
            }
            case 37: {
                return 37;
            }
            case 48: {
                return 48;
            }
            case 51: {
                return 51;
            }
        }
        return role;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }
}

