/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ViewForm
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    private Control topLeft;
    private Control topCenter;
    private Control topRight;
    private Control content;
    private boolean separateTopCenter = false;
    private int drawLine1 = -1;
    private int drawLine2 = -1;
    private boolean showBorder = false;
    private int BORDER_TOP = 0;
    private int BORDER_BOTTOM = 0;
    private int BORDER_LEFT = 0;
    private int BORDER_RIGHT = 0;
    private Color borderColor1 = new Color(this.getDisplay(), borderInsideRGB);
    private Color borderColor2 = new Color(this.getDisplay(), borderMiddleRGB);
    private Color borderColor3 = new Color(this.getDisplay(), borderOutsideRGB);
    private Rectangle oldArea;
    private static final int OFFSCREEN = -200;

    public ViewForm(Composite parent, int style) {
        super(parent, ViewForm.checkStyle(style));
        this.setBorderVisible((style & 0x800) != 0);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ViewForm.this.onPaint(event.gc);
            }
        });
        this.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ViewForm.this.onResize();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                ViewForm.this.onDispose();
            }
        });
    }

    private static int checkStyle(int style) {
        int mask = 0x6800000;
        return style & mask | 0x100000;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point leftSize = new Point(0, 0);
        if (this.topLeft != null) {
            leftSize = this.topLeft.computeSize(-1, -1);
            ++leftSize.x;
        }
        Point centerSize = new Point(0, 0);
        if (this.topCenter != null) {
            centerSize = this.topCenter.computeSize(-1, -1);
        }
        Point rightSize = new Point(0, 0);
        if (this.topRight != null) {
            rightSize = this.topRight.computeSize(-1, -1);
        }
        Point size = new Point(0, 0);
        if (this.separateTopCenter || wHint != -1 && leftSize.x + centerSize.x + rightSize.x > wHint) {
            size.x = leftSize.x + rightSize.x;
            size.x = Math.max(centerSize.x, size.x);
            size.y = Math.max(leftSize.y, rightSize.y) + 1;
            if (this.topCenter != null) {
                size.y += centerSize.y;
            }
        } else {
            size.x = leftSize.x + centerSize.x + rightSize.x;
            size.y = Math.max(leftSize.y, Math.max(centerSize.y, rightSize.y)) + 1;
        }
        if (this.content != null) {
            Point contentSize = new Point(0, 0);
            contentSize = this.content.computeSize(-1, -1);
            size.x = Math.max(size.x, contentSize.x);
            size.y += contentSize.y + 1;
        }
        size.x += 2 * this.marginWidth;
        size.y += 2 * this.marginHeight;
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int trimX = x - this.BORDER_LEFT;
        int trimY = y - this.BORDER_TOP;
        int trimWidth = width + this.BORDER_LEFT + this.BORDER_RIGHT;
        int trimHeight = height + this.BORDER_TOP + this.BORDER_BOTTOM;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle clientArea = super.getClientArea();
        clientArea.x += this.BORDER_LEFT;
        clientArea.y += this.BORDER_TOP;
        clientArea.width -= this.BORDER_LEFT + this.BORDER_RIGHT;
        clientArea.height -= this.BORDER_TOP + this.BORDER_BOTTOM;
        return clientArea;
    }

    public Control getContent() {
        return this.content;
    }

    public Control getTopCenter() {
        return this.topCenter;
    }

    public Control getTopLeft() {
        return this.topLeft;
    }

    public Control getTopRight() {
        return this.topRight;
    }

    public void layout(boolean changed) {
        this.checkWidget();
        Rectangle rect = this.getClientArea();
        this.drawLine1 = -1;
        this.drawLine2 = -1;
        Point leftSize = new Point(0, 0);
        if (this.topLeft != null && !this.topLeft.isDisposed()) {
            leftSize = this.topLeft.computeSize(-1, -1);
        }
        Point centerSize = new Point(0, 0);
        if (this.topCenter != null && !this.topCenter.isDisposed()) {
            centerSize = this.topCenter.computeSize(-1, -1);
        }
        Point rightSize = new Point(0, 0);
        if (this.topRight != null && !this.topRight.isDisposed()) {
            rightSize = this.topRight.computeSize(-1, -1);
        }
        int minTopWidth = leftSize.x + centerSize.x + rightSize.x + 2 * this.marginWidth + 1;
        int height = rect.y + this.marginHeight;
        boolean top = false;
        if (this.separateTopCenter || minTopWidth > rect.width) {
            int topHeight = Math.max(rightSize.y, leftSize.y);
            if (this.topRight != null && !this.topRight.isDisposed()) {
                top = true;
                this.topRight.setBounds(rect.x + rect.width - this.marginWidth - rightSize.x, rect.y + 1 + this.marginHeight, rightSize.x, topHeight);
                height += 1 + topHeight;
            }
            if (this.topLeft != null && !this.topLeft.isDisposed()) {
                top = true;
                leftSize = this.topLeft.computeSize(rect.width - 2 * this.marginWidth - rightSize.x - 1, -1);
                this.topLeft.setBounds(rect.x + 1 + this.marginWidth, rect.y + 1 + this.marginHeight, leftSize.x, topHeight);
                height = Math.max(height, rect.y + this.marginHeight + 1 + topHeight);
            }
            if (this.topCenter != null && !this.topCenter.isDisposed()) {
                top = true;
                if (height > rect.y + this.marginHeight) {
                    this.drawLine1 = height++;
                }
                centerSize = this.topCenter.computeSize(rect.width - 2 * this.marginWidth, -1);
                this.topCenter.setBounds(rect.x + rect.width - this.marginWidth - centerSize.x, height, centerSize.x, centerSize.y);
                height += centerSize.y;
            }
        } else {
            int topHeight = Math.max(rightSize.y, Math.max(centerSize.y, leftSize.y));
            if (this.topRight != null && !this.topRight.isDisposed()) {
                top = true;
                this.topRight.setBounds(rect.x + rect.width - this.marginWidth - rightSize.x, rect.y + this.marginHeight + 1, rightSize.x, topHeight);
                height += 1 + topHeight;
            }
            if (this.topCenter != null && !this.topCenter.isDisposed()) {
                top = true;
                this.topCenter.setBounds(rect.x + rect.width - this.marginWidth - rightSize.x - centerSize.x, rect.y + this.marginHeight + 1, centerSize.x, topHeight);
                height = Math.max(height, rect.y + this.marginHeight + 1 + topHeight);
            }
            if (this.topLeft != null && !this.topLeft.isDisposed()) {
                top = true;
                leftSize = this.topLeft.computeSize(rect.width - 2 * this.marginWidth - rightSize.x - centerSize.x - 1, topHeight);
                this.topLeft.setBounds(rect.x + this.marginWidth + 1, rect.y + this.marginHeight + 1, leftSize.x, topHeight);
                height = Math.max(height, rect.y + this.marginHeight + 1 + topHeight);
            }
        }
        if (this.content != null && !this.content.isDisposed()) {
            if (top) {
                this.drawLine2 = height++;
            }
            this.content.setBounds(rect.x + this.marginWidth, height, rect.width - 2 * this.marginWidth, rect.y + rect.height - height - this.marginHeight);
        }
    }

    private void onDispose() {
        if (this.borderColor1 != null) {
            this.borderColor1.dispose();
        }
        this.borderColor1 = null;
        if (this.borderColor2 != null) {
            this.borderColor2.dispose();
        }
        this.borderColor2 = null;
        if (this.borderColor3 != null) {
            this.borderColor3.dispose();
        }
        this.borderColor3 = null;
        this.topLeft = null;
        this.topCenter = null;
        this.topRight = null;
        this.content = null;
        this.oldArea = null;
    }

    private void onPaint(GC gc) {
        int y;
        Rectangle d = super.getClientArea();
        if (this.showBorder) {
            if ((this.getStyle() & 0x800000) != 0) {
                gc.setForeground(this.borderColor1);
                gc.drawRectangle(d.x, d.y, d.x + d.width - 1, d.y + d.height - 1);
            } else {
                gc.setForeground(this.borderColor1);
                gc.drawRectangle(d.x, d.y, d.x + d.width - 3, d.y + d.height - 3);
                gc.setForeground(this.borderColor2);
                gc.drawLine(d.x + 1, d.y + d.height - 2, d.x + d.width - 1, d.y + d.height - 2);
                gc.drawLine(d.x + d.width - 2, d.y + 1, d.x + d.width - 2, d.y + d.height - 1);
                gc.setForeground(this.borderColor3);
                gc.drawLine(d.x + 2, d.y + d.height - 1, d.x + d.width - 2, d.y + d.height - 1);
                gc.drawLine(d.x + d.width - 1, d.y + 2, d.x + d.width - 1, d.y + d.height - 2);
            }
        }
        if (this.drawLine1 != -1) {
            gc.setForeground(this.borderColor1);
            gc.drawLine(d.x + this.BORDER_LEFT, this.drawLine1, d.x + d.width - this.BORDER_RIGHT, this.drawLine1);
        }
        if (this.drawLine2 != -1) {
            gc.setForeground(this.borderColor1);
            gc.drawLine(d.x + this.BORDER_LEFT, this.drawLine2, d.x + d.width - this.BORDER_RIGHT, this.drawLine2);
        }
        if ((y = this.drawLine1) == -1) {
            y = this.drawLine2;
        }
        if (y != -1) {
            gc.setForeground(this.getDisplay().getSystemColor(20));
            gc.drawLine(d.x + this.BORDER_LEFT + this.marginWidth, d.y + this.BORDER_TOP + this.marginHeight, d.x + this.BORDER_LEFT + this.marginWidth, y - 1);
            gc.drawLine(d.x + this.BORDER_LEFT + this.marginWidth, d.y + this.BORDER_TOP + this.marginHeight, d.x + d.width - this.BORDER_RIGHT - this.marginWidth - 1, d.y + this.BORDER_TOP + this.marginHeight);
        }
        gc.setForeground(this.getForeground());
    }

    private void onResize() {
        this.layout();
        Rectangle area = super.getClientArea();
        if (this.oldArea == null || this.oldArea.width == 0 || this.oldArea.height == 0) {
            this.redraw();
        } else {
            int width = 0;
            if (this.oldArea.width < area.width) {
                width = area.width - this.oldArea.width + this.BORDER_RIGHT;
            } else if (this.oldArea.width > area.width) {
                width = this.BORDER_RIGHT;
            }
            this.redraw(area.x + area.width - width, area.y, width, area.height, false);
            int height = 0;
            if (this.oldArea.height < area.height) {
                height = area.height - this.oldArea.height + this.BORDER_BOTTOM;
            }
            if (this.oldArea.height > area.height) {
                height = this.BORDER_BOTTOM;
            }
            this.redraw(area.x, area.y + area.height - height, area.width, height, false);
        }
        this.oldArea = area;
    }

    public void setContent(Control content) {
        this.checkWidget();
        if (content != null && content.getParent() != this) {
            SWT.error(5);
        }
        if (this.content != null && !this.content.isDisposed()) {
            this.content.setBounds(-200, -200, 0, 0);
        }
        this.content = content;
        this.layout();
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (this.topLeft != null && !this.topLeft.isDisposed()) {
            this.topLeft.setFont(f);
        }
        if (this.topCenter != null && !this.topCenter.isDisposed()) {
            this.topCenter.setFont(f);
        }
        if (this.topRight != null && !this.topRight.isDisposed()) {
            this.topRight.setFont(f);
        }
        this.layout();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setTopCenter(Control topCenter) {
        this.checkWidget();
        if (topCenter != null && topCenter.getParent() != this) {
            SWT.error(5);
        }
        if (this.topCenter != null && !this.topCenter.isDisposed()) {
            this.topCenter.setBounds(-200, -200, 0, 0);
        }
        this.topCenter = topCenter;
        this.layout();
    }

    public void setTopLeft(Control c) {
        this.checkWidget();
        if (c != null && c.getParent() != this) {
            SWT.error(5);
        }
        if (this.topLeft != null && !this.topLeft.isDisposed()) {
            this.topLeft.setBounds(-200, -200, 0, 0);
        }
        this.topLeft = c;
        this.layout();
    }

    public void setTopRight(Control c) {
        this.checkWidget();
        if (c != null && c.getParent() != this) {
            SWT.error(5);
        }
        if (this.topRight != null && !this.topRight.isDisposed()) {
            this.topRight.setBounds(-200, -200, 0, 0);
        }
        this.topRight = c;
        this.layout();
    }

    public void setBorderVisible(boolean show) {
        this.checkWidget();
        if (this.showBorder == show) {
            return;
        }
        this.showBorder = show;
        if (this.showBorder) {
            if ((this.getStyle() & 0x800000) != 0) {
                this.BORDER_BOTTOM = 1;
                this.BORDER_RIGHT = 1;
                this.BORDER_TOP = 1;
                this.BORDER_LEFT = 1;
            } else {
                this.BORDER_TOP = 1;
                this.BORDER_LEFT = 1;
                this.BORDER_BOTTOM = 3;
                this.BORDER_RIGHT = 3;
            }
        } else {
            this.BORDER_RIGHT = 0;
            this.BORDER_LEFT = 0;
            this.BORDER_TOP = 0;
            this.BORDER_BOTTOM = 0;
        }
        this.layout();
        this.redraw();
    }

    public void setTopCenterSeparate(boolean show) {
        this.checkWidget();
        this.separateTopCenter = show;
        this.layout();
    }
}

