/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Vector;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextBidi;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class DisplayRenderer
extends StyledTextRenderer {
    private StyledText parent;

    DisplayRenderer(Device device, Font regularFont, boolean isBidi, int leftMargin, StyledText parent, int tabLength) {
        super(device, regularFont, isBidi, leftMargin);
        this.parent = parent;
        this.calculateLineHeight();
        this.setTabLength(tabLength);
    }

    protected void disposeGC(GC gc) {
        gc.dispose();
    }

    protected void drawLineBreakSelection(String line, int lineOffset, StyleRange[] styles, int paintY, GC gc, StyledTextBidi bidi) {
        int paintX;
        Point selection = this.parent.internalGetSelection();
        int lineLength = line.length();
        int selectionStart = Math.max(0, selection.x - lineOffset);
        int selectionEnd = selection.y - lineOffset;
        int horizontalScrollOffset = this.parent.internalGetHorizontalPixel();
        int leftMargin = this.getLeftMargin();
        int lineEndSpaceWidth = this.getLineEndSpaceWidth();
        int lineHeight = this.getLineHeight();
        if (selectionEnd == selectionStart || selectionEnd < 0 || selectionStart > lineLength || selectionEnd <= lineLength) {
            return;
        }
        if (bidi != null) {
            paintX = bidi.getTextWidth();
            if (paintX == 0) {
                paintX = 3;
            }
        } else {
            paintX = this.getTextPosition(line, lineOffset, lineLength, this.filterLineStyles(styles), gc);
        }
        gc.setBackground(this.parent.getSelectionBackground());
        gc.setForeground(this.parent.getSelectionForeground());
        if ((this.parent.getStyle() & 0x10000) != 0) {
            StyledText.LineCache lineCache = this.parent.internalGetLineCache();
            int selectionBackgroundWidth = Math.max(this.getClientArea().width, lineCache.getWidth());
            gc.fillRectangle(paintX - horizontalScrollOffset + leftMargin, paintY, selectionBackgroundWidth, lineHeight);
        } else {
            int lineEnd;
            StyledTextContent content;
            int lineIndex;
            boolean isWrappedLine = false;
            if (this.parent.internalGetWordWrap() && (lineIndex = (content = this.getContent()).getLineAtOffset(lineEnd = lineOffset + lineLength)) < content.getLineCount() - 1 && content.getOffsetAtLine(lineIndex + 1) == lineEnd) {
                isWrappedLine = true;
            }
            if (!isWrappedLine) {
                gc.fillRectangle(paintX - horizontalScrollOffset + leftMargin, paintY, lineEndSpaceWidth, lineHeight);
            }
        }
    }

    protected int[] getBidiSegments(int lineOffset, String lineText) {
        return this.parent.getBidiSegments(lineOffset, lineText);
    }

    protected Rectangle getClientArea() {
        return this.parent.getClientArea();
    }

    protected StyledTextContent getContent() {
        return this.parent.internalGetContent();
    }

    protected GC getGC() {
        return new GC(this.parent);
    }

    protected int getHorizontalPixel() {
        return this.parent.internalGetHorizontalPixel();
    }

    protected StyledTextEvent getLineBackgroundData(int lineOffset, String line) {
        return this.parent.getLineBackgroundData(lineOffset, line);
    }

    protected StyledTextEvent getLineStyleData(int lineOffset, String line) {
        StyledTextEvent logicalLineEvent = this.parent.getLineStyleData(lineOffset, line);
        if (logicalLineEvent != null) {
            logicalLineEvent = this.getLineStyleData(logicalLineEvent, lineOffset, line);
        }
        return logicalLineEvent;
    }

    protected Point getSelection() {
        return this.parent.internalGetSelection();
    }

    protected int getStyledTextWidth(String text, int textStartOffset, StyleRange[] lineStyles, int paintX, GC gc) {
        String textSegment;
        int textLength = text.length();
        int textIndex = 0;
        GC boldGC = null;
        GC normalGC = null;
        int fontStyle = this.getCurrentFontStyle();
        if (fontStyle == 0) {
            normalGC = gc;
        } else {
            boldGC = gc;
        }
        int styleIndex = 0;
        while (styleIndex < lineStyles.length) {
            StyleRange style = lineStyles[styleIndex];
            int styleSegmentStart = style.start - textStartOffset;
            if (styleSegmentStart + style.length >= 0) {
                if (styleSegmentStart >= textLength) break;
                if (textIndex < styleSegmentStart) {
                    textSegment = text.substring(textIndex, styleSegmentStart);
                    if (normalGC == null) {
                        normalGC = this.getGC();
                        normalGC.setFont(this.regularFont);
                    }
                    paintX += normalGC.stringExtent((String)textSegment).x;
                    textIndex = styleSegmentStart;
                }
                int textEnd = Math.min(textLength, styleSegmentStart + style.length);
                textSegment = text.substring(textIndex, textEnd);
                if (style.fontStyle == 0) {
                    if (normalGC == null) {
                        normalGC = this.getGC();
                        normalGC.setFont(this.regularFont);
                    }
                    paintX += normalGC.stringExtent((String)textSegment).x;
                } else {
                    if (boldGC == null) {
                        boldGC = this.getGC();
                        boldGC.setFont(this.boldFont);
                    }
                    paintX += boldGC.stringExtent((String)textSegment).x;
                }
                textIndex = textEnd;
            }
            ++styleIndex;
        }
        if (textIndex < textLength) {
            textSegment = text.substring(textIndex, textLength);
            if (normalGC == null) {
                normalGC = this.getGC();
                normalGC.setFont(this.regularFont);
            }
            paintX += normalGC.stringExtent((String)textSegment).x;
        }
        if (fontStyle == 0) {
            if (boldGC != null) {
                this.disposeGC(boldGC);
            }
        } else if (normalGC != null) {
            this.disposeGC(normalGC);
        }
        return paintX;
    }

    protected StyleRange[] mergeSelectionLineStyles(StyleRange[] styles) {
        Point selection = this.parent.internalGetSelection();
        int selectionStart = selection.x;
        int selectionEnd = selection.y;
        Vector<StyleRange> newStyles = new Vector<StyleRange>(styles.length);
        StyleRange selectionStyle = null;
        Color foreground = this.parent.getSelectionForeground();
        Color background = this.parent.getSelectionBackground();
        int i = 0;
        while (i < styles.length) {
            StyleRange style = styles[i];
            int styleEnd = style.start + style.length;
            if (styleEnd <= selectionStart) {
                newStyles.addElement(style);
            } else if (style.start < selectionStart && styleEnd > selectionStart) {
                StyleRange newStyle = (StyleRange)style.clone();
                newStyle.length -= styleEnd - selectionStart;
                newStyles.addElement(newStyle);
                selectionStyle = new StyleRange(selectionStart, styleEnd - selectionStart, foreground, background, newStyle.fontStyle);
                newStyles.addElement(selectionStyle);
                newStyle = this.setSelectionStyleEnd(selectionStyle, style);
                if (newStyle != null) {
                    newStyles.addElement(newStyle);
                }
            } else if (style.start >= selectionStart && style.start < selectionEnd) {
                int selectionStyleEnd;
                if (selectionStyle == null) {
                    selectionStyle = new StyleRange(selectionStart, style.start - selectionStart, foreground, background);
                    newStyles.addElement(selectionStyle);
                    if (style.start == selectionStart) {
                        selectionStyle.fontStyle = style.fontStyle;
                    }
                }
                if (style.start > (selectionStyleEnd = selectionStyle.start + selectionStyle.length) && selectionStyle.fontStyle != 0) {
                    selectionStyle = new StyleRange(selectionStyleEnd, style.start - selectionStyleEnd, foreground, background);
                    newStyles.addElement(selectionStyle);
                }
                if (selectionStyle.fontStyle != style.fontStyle) {
                    selectionStyle.length = style.start - selectionStyle.start;
                    selectionStyle = new StyleRange(style.start, style.length, foreground, background, style.fontStyle);
                    newStyles.addElement(selectionStyle);
                } else {
                    selectionStyle.length = styleEnd - selectionStyle.start;
                }
                StyleRange newStyle = this.setSelectionStyleEnd(selectionStyle, style);
                if (newStyle != null) {
                    newStyles.addElement(newStyle);
                }
            } else {
                if (selectionStyle == null) {
                    selectionStyle = new StyleRange(selectionStart, selectionEnd - selectionStart, foreground, background);
                    newStyles.addElement(selectionStyle);
                } else if (selectionStyle.start + selectionStyle.length < selectionEnd) {
                    if (selectionStyle.fontStyle != 0) {
                        int selectionStyleEnd = selectionStyle.start + selectionStyle.length;
                        selectionStyle = new StyleRange(selectionStyleEnd, selectionEnd - selectionStyleEnd, foreground, background);
                        newStyles.addElement(selectionStyle);
                    } else {
                        selectionStyle.length = selectionEnd - selectionStyle.start;
                    }
                }
                newStyles.addElement(style);
            }
            ++i;
        }
        if (selectionStyle == null) {
            selectionStyle = new StyleRange(selectionStart, selectionEnd - selectionStart, foreground, background);
            newStyles.addElement(selectionStyle);
        } else if (selectionStyle.start + selectionStyle.length < selectionEnd) {
            if (selectionStyle.fontStyle != 0) {
                int selectionStyleEnd = selectionStyle.start + selectionStyle.length;
                selectionStyle = new StyleRange(selectionStyleEnd, selectionEnd - selectionStyleEnd, foreground, background);
                newStyles.addElement(selectionStyle);
            } else {
                selectionStyle.length = selectionEnd - selectionStyle.start;
            }
        }
        styles = new StyleRange[newStyles.size()];
        newStyles.copyInto(styles);
        return styles;
    }

    protected boolean getWordWrap() {
        return this.parent.getWordWrap();
    }

    protected boolean isFullLineSelection() {
        return (this.parent.getStyle() & 0x10000) != 0;
    }

    private StyleRange setSelectionStyleEnd(StyleRange selectionStyle, StyleRange style) {
        int selectionEnd = this.parent.internalGetSelection().y;
        StyleRange newStyle = null;
        if (selectionStyle.start + selectionStyle.length > selectionEnd) {
            int styleEnd = style.start + style.length;
            selectionStyle.length = selectionEnd - selectionStyle.start;
            newStyle = (StyleRange)style.clone();
            newStyle.start = selectionEnd;
            newStyle.length = styleEnd - selectionEnd;
        }
        return newStyle;
    }
}

