/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.HELPINFO;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHRGINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TRACKMOUSEEVENT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public abstract class Control
extends Widget
implements Drawable {
    public int handle;
    Composite parent;
    int drawCount;
    int hCursor;
    int foreground;
    int background;
    Menu menu;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    static final short[] ACCENTS = new short[]{126, 96, 39, 94, 34};

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    abstract int callWindowProc(int var1, int var2, int var3);

    void checkMirrored() {
        int bits;
        if ((this.style & 0x4000000) != 0 && ((bits = OS.GetWindowLong(this.handle, -20)) & 0x400000) != 0) {
            this.style |= 0x8000000;
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    void createHandle() {
        int bits;
        int hwndParent = 0;
        if (this.handle != 0) {
            hwndParent = this.handle;
        } else if (this.parent != null) {
            hwndParent = this.parent.handle;
        }
        this.handle = OS.CreateWindowEx(this.widgetExtStyle(), this.windowClass(), null, this.widgetStyle(), Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, hwndParent, 0, OS.GetModuleHandle(null), null);
        if (this.handle == 0) {
            this.error(2);
        }
        if (((bits = OS.GetWindowLong(this.handle, -16)) & 0x40000000) != 0) {
            OS.SetWindowLong(this.handle, -12, this.handle);
        }
        if (OS.IsDBLocale && this.parent != null) {
            int hIMC = OS.ImmGetContext(hwndParent);
            OS.ImmAssociateContext(this.handle, hIMC);
            OS.ImmReleaseContext(hwndParent, hIMC);
        }
    }

    void createWidget() {
        this.background = -1;
        this.foreground = -1;
        this.checkOrientation(this.parent);
        this.createHandle();
        this.register();
        this.subclass();
        this.setDefaultFont();
        this.checkMirrored();
    }

    int defaultBackground() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return OS.GetSysColor(OS.COLOR_BTNFACE);
    }

    int defaultFont() {
        Display display = this.getDisplay();
        return display.systemFont();
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
    }

    void deregister() {
        WidgetTable.remove(this.handle);
    }

    void destroyWidget() {
        int hwnd = this.handle;
        this.releaseHandle();
        if (hwnd != 0) {
            OS.DestroyWindow(hwnd);
        }
    }

    void drawBackground(int hDC) {
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        this.drawBackground(hDC, rect);
    }

    void drawBackground(int hDC, RECT rect) {
        Display display = this.getDisplay();
        int hPalette = display.hPalette;
        if (hPalette != 0) {
            OS.SelectPalette(hDC, hPalette, false);
            OS.RealizePalette(hDC);
        }
        int pixel = this.getBackgroundPixel();
        int hBrush = this.findBrush(pixel);
        OS.FillRect(hDC, rect, hBrush);
    }

    int findBrush(int pixel) {
        return this.parent.findBrush(pixel);
    }

    int findCursor() {
        if (this.hCursor != 0) {
            return this.hCursor;
        }
        return this.parent.findCursor();
    }

    char findMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    void fixFocus() {
        Shell shell = this.getShell();
        Control control = this;
        while ((control = control.parent) != null) {
            if (!control.setFocus() && control != shell) continue;
            return;
        }
        OS.SetFocus(0);
    }

    public boolean forceFocus() {
        this.checkWidget();
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        shell.bringToTop();
        OS.SetFocus(this.handle);
        return this.isFocusControl();
    }

    void forceResize() {
        if (this.parent == null) {
            return;
        }
        WINDOWPOS[] lpwp = this.parent.lpwp;
        if (lpwp == null) {
            return;
        }
        int i = 0;
        while (i < lpwp.length) {
            WINDOWPOS wp = lpwp[i];
            if (wp != null && wp.hwnd == this.handle) {
                OS.SetWindowPos(wp.hwnd, 0, wp.x, wp.y, wp.cx, wp.cy, wp.flags);
                lpwp[i] = null;
                return;
            }
            ++i;
        }
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        return Color.win32_new(this.getDisplay(), this.getBackgroundPixel());
    }

    int getBackgroundPixel() {
        if (this.background == -1) {
            return this.defaultBackground();
        }
        return this.background;
    }

    public int getBorderWidth() {
        this.checkWidget();
        int bits = OS.GetWindowLong(this.handle, -20);
        if ((bits & 0x200) != 0) {
            return OS.GetSystemMetrics(45);
        }
        if ((bits & 0x20000) != 0) {
            return OS.GetSystemMetrics(5);
        }
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        this.forceResize();
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        int hwndParent = this.parent == null ? 0 : this.parent.handle;
        OS.MapWindowPoints(0, hwndParent, rect, 2);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    int getCodePage() {
        int hFont = OS.SendMessage(this.handle, 49, 0, 0);
        LOGFONT logFont = new LOGFONT();
        OS.GetObject(hFont, LOGFONT.sizeof, logFont);
        int cs = logFont.lfCharSet & 0xFF;
        int[] lpCs = new int[8];
        if (OS.TranslateCharsetInfo(cs, lpCs, 1)) {
            return lpCs[1];
        }
        return OS.GetACP();
    }

    public Display getDisplay() {
        Composite parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.IsWindowEnabled(this.handle);
    }

    public Font getFont() {
        this.checkWidget();
        int hFont = OS.SendMessage(this.handle, 49, 0, 0);
        if (hFont == 0) {
            hFont = this.defaultFont();
        }
        return Font.win32_new(this.getDisplay(), hFont);
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.win32_new(this.getDisplay(), this.getForegroundPixel());
    }

    int getForegroundPixel() {
        if (this.foreground == -1) {
            return this.defaultForeground();
        }
        return this.foreground;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        this.forceResize();
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        int hwndParent = this.parent == null ? 0 : this.parent.handle;
        OS.MapWindowPoints(0, hwndParent, rect, 2);
        return new Point(rect.left, rect.top);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        this.forceResize();
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Point(width, height);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        int bits = OS.GetWindowLong(this.handle, -16);
        return (bits & 0x10000000) != 0;
    }

    boolean hasCursor() {
        RECT rect = new RECT();
        if (!OS.GetClientRect(this.handle, rect)) {
            return false;
        }
        if (OS.MapWindowPoints(this.handle, 0, rect, 2) == 0) {
            return false;
        }
        POINT pt = new POINT();
        return OS.GetCursorPos(pt) && OS.PtInRect(rect, pt);
    }

    boolean hasFocus() {
        int hwndFocus = OS.GetFocus();
        while (hwndFocus != 0) {
            if (hwndFocus == this.handle) {
                return true;
            }
            if (WidgetTable.get(hwndFocus) != null) {
                return false;
            }
            hwndFocus = OS.GetParent(hwndFocus);
        }
        return false;
    }

    public int internal_new_GC(GCData data) {
        this.checkWidget();
        int hDC = data == null || data.ps == null ? OS.GetDC(this.handle) : OS.BeginPaint(this.handle, data.ps);
        if (hDC == 0) {
            SWT.error(2);
        }
        if (data != null) {
            if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154) {
                int mask = 0x6000000;
                if ((data.style & mask) != 0) {
                    data.layout = (data.style & 0x4000000) != 0 ? 1 : 0;
                } else {
                    int flags = OS.GetLayout(hDC);
                    data.style = (flags & 1) != 0 ? (data.style |= 0xC000000) : (data.style |= 0x2000000);
                }
            } else {
                data.style |= 0x2000000;
            }
            data.device = this.getDisplay();
            data.foreground = this.getForegroundPixel();
            data.background = this.getBackgroundPixel();
            data.hFont = OS.SendMessage(this.handle, 49, 0, 0);
            data.hwnd = this.handle;
        }
        return hDC;
    }

    public void internal_dispose_GC(int hDC, GCData data) {
        this.checkWidget();
        if (data == null || data.ps == null) {
            OS.ReleaseDC(this.handle, hDC);
        } else {
            OS.EndPaint(this.handle, data.ps);
        }
    }

    boolean isActive() {
        Display display = this.getDisplay();
        Shell modal = display.getModalShell();
        if (modal != null && modal != this) {
            Shell shell;
            if ((modal.style & 0x8000) != 0 && modal.parent == (shell = this.getShell())) {
                return false;
            }
            int bits = 196608;
            if ((modal.style & bits) != 0) {
                Control control = this;
                while (control != null) {
                    if (control == modal) break;
                    control = control.parent;
                }
                if (control != modal) {
                    return false;
                }
            }
        }
        return this.getShell().getEnabled();
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    boolean isFocusAncestor() {
        Display display = this.getDisplay();
        Control control = display.getFocusControl();
        while (control != null && control != this) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSize();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int bits;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return ((bits = OS.GetWindowLong(this.handle, -16)) & 0x10000) != 0;
    }

    boolean isTabItem() {
        int bits;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        if (((bits = OS.GetWindowLong(this.handle, -16)) & 0x10000) != 0) {
            return false;
        }
        int code = OS.SendMessage(this.handle, 135, 0, 0);
        if ((code & 0x100) != 0) {
            return false;
        }
        if ((code & 4) != 0) {
            return false;
        }
        if ((code & 1) != 0) {
            return false;
        }
        return (code & 2) == 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return OS.IsWindowVisible(this.handle);
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return false;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        int hwndAbove = 0;
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            int hwnd = control.handle;
            if (hwnd == 0 || hwnd == this.handle) {
                return;
            }
            hwndAbove = OS.GetWindow(hwnd, 3);
            if (hwndAbove == 0 || hwndAbove == hwnd) {
                hwndAbove = 0;
            }
        }
        int flags = 19;
        OS.SetWindowPos(this.handle, hwndAbove, 0, 0, 0, 0, flags);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        int hwndAbove = 1;
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            hwndAbove = control.handle;
        }
        if (hwndAbove == 0 || hwndAbove == this.handle) {
            return;
        }
        int flags = 19;
        OS.SetWindowPos(this.handle, hwndAbove, 0, 0, 0, 0, flags);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public void redraw() {
        this.checkWidget();
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int flags = 1029;
            OS.RedrawWindow(this.handle, null, 0, flags);
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, rect, true);
        } else {
            int flags = 1029;
            if (all) {
                flags |= 0x80;
            }
            OS.RedrawWindow(this.handle, rect, 0, flags);
        }
    }

    void register() {
        WidgetTable.put(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (OS.IsDBLocale) {
            OS.ImmAssociateContext(this.handle, 0);
        }
        if (this.toolTipText != null) {
            Shell shell = this.getShell();
            shell.setToolTipText(this.handle, null);
        }
        this.toolTipText = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.deregister();
        this.unsubclass();
        this.parent = null;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    boolean sendKeyEvent(int type, int msg, int wParam, int lParam) {
        Event event = new Event();
        if (!this.setKeyState(event, type)) {
            return true;
        }
        return this.sendKeyEvent(type, msg, wParam, lParam, event);
    }

    boolean sendKeyEvent(int type, int msg, int wParam, int lParam, Event event) {
        this.postEvent(type, event);
        return true;
    }

    boolean sendMouseEvent(int type, int button, int msg, int wParam, int lParam) {
        Event event = new Event();
        event.button = button;
        event.x = (short)(lParam & 0xFFFF);
        event.y = (short)(lParam >> 16);
        this.setInputState(event, type);
        return this.sendMouseEvent(type, msg, wParam, lParam, event);
    }

    boolean sendMouseEvent(int type, int msg, int wParam, int lParam, Event event) {
        this.postEvent(type, event);
        return true;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            pixel = color.handle;
        }
        this.setBackgroundPixel(pixel);
    }

    void setBackgroundPixel(int pixel) {
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        int flags = 52;
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), flags);
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        if (this.parent == null) {
            OS.SetWindowPos(this.handle, 0, x, y, width, height, flags);
            return;
        }
        if (this.parent.lpwp == null) {
            OS.SetWindowPos(this.handle, 0, x, y, width, height, flags);
            return;
        }
        this.forceResize();
        WINDOWPOS[] lpwp = this.parent.lpwp;
        int index = 0;
        while (index < lpwp.length) {
            if (lpwp[index] == null) break;
            ++index;
        }
        if (index == lpwp.length) {
            WINDOWPOS[] newLpwp = new WINDOWPOS[lpwp.length + 4];
            System.arraycopy(lpwp, 0, newLpwp, 0, lpwp.length);
            lpwp = newLpwp;
            this.parent.lpwp = newLpwp;
        }
        WINDOWPOS wp = new WINDOWPOS();
        wp.hwnd = this.handle;
        wp.x = x;
        wp.y = y;
        wp.cx = width;
        wp.cy = height;
        wp.flags = flags;
        lpwp[index] = wp;
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
        if (capture) {
            OS.SetCapture(this.handle);
        } else if (OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
    }

    public void setCursor(Cursor cursor) {
        Control control;
        this.checkWidget();
        this.hCursor = 0;
        if (cursor != null) {
            if (cursor.isDisposed()) {
                SWT.error(5);
            }
            this.hCursor = cursor.handle;
        }
        if (OS.IsWinCE) {
            OS.SetCursor(this.hCursor);
            return;
        }
        int hwndCursor = OS.GetCapture();
        if (hwndCursor == 0) {
            POINT pt = new POINT();
            if (!OS.GetCursorPos(pt)) {
                return;
            }
            int hwnd = hwndCursor = OS.WindowFromPoint(pt);
            while (hwnd != 0 && hwnd != this.handle) {
                hwnd = OS.GetParent(hwnd);
            }
            if (hwnd == 0) {
                return;
            }
        }
        if ((control = WidgetTable.get(hwndCursor)) == null) {
            control = this;
        }
        control.setCursor(hwndCursor);
    }

    void setCursor(int hwndCursor) {
        int lParam = 0x2000001;
        OS.SendMessage(hwndCursor, 32, hwndCursor, lParam);
    }

    void setDefaultFont() {
        Display display = this.getDisplay();
        int hFont = display.systemFont();
        OS.SendMessage(this.handle, 48, hFont, 0);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        boolean fixFocus = false;
        if (!enabled) {
            fixFocus = this.isFocusAncestor();
        }
        OS.EnableWindow(this.handle, enabled);
        if (fixFocus) {
            this.fixFocus();
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        int hFont = 0;
        if (font != null) {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            hFont = font.handle;
        }
        if (hFont == 0) {
            hFont = this.defaultFont();
        }
        OS.SendMessage(this.handle, 48, hFont, 1);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            pixel = color.handle;
        }
        this.setForegroundPixel(pixel);
    }

    void setForegroundPixel(int pixel) {
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        int flags = 21;
        if (!OS.IsWinCE) {
            flags |= 0x20;
        }
        this.setBounds(x, y, 0, 0, flags);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    boolean setRadioFocus() {
        return false;
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                OS.SendMessage(this.handle, 11, 1, 0);
                if (OS.IsWinCE) {
                    OS.InvalidateRect(this.handle, null, true);
                } else {
                    int flags = 1157;
                    OS.RedrawWindow(this.handle, null, 0, flags);
                }
            }
        } else if (this.drawCount++ == 0) {
            OS.SendMessage(this.handle, 11, 0, 0);
        }
    }

    boolean setSavedFocus() {
        return this.forceFocus();
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        int flags = 54;
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), flags);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.setFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Shell shell = this.getShell();
        this.toolTipText = string;
        shell.setToolTipText(this.handle, this.toolTipText);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0x10000000) != 0 == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        boolean fixFocus = false;
        if (!visible) {
            fixFocus = this.isFocusAncestor();
        }
        OS.ShowWindow(this.handle, visible ? 5 : 0);
        if (!visible) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (fixFocus) {
            this.fixFocus();
        }
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void subclass() {
        int newProc;
        int oldProc = this.windowProc();
        if (oldProc == (newProc = this.getDisplay().windowProc)) {
            return;
        }
        OS.SetWindowLong(this.handle, -4, newProc);
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        POINT pt = new POINT();
        pt.x = x;
        pt.y = y;
        OS.ScreenToClient(this.handle, pt);
        return new Point(pt.x, pt.y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        POINT pt = new POINT();
        pt.x = x;
        pt.y = y;
        OS.ClientToScreen(this.handle, pt);
        return new Point(pt.x, pt.y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    boolean translateAccelerator(MSG msg) {
        return this.menuShell().translateAccelerator(msg);
    }

    boolean translateMnemonic(char key) {
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        Event event = new Event();
        event.doit = this.mnemonicMatch(key);
        event.detail = 128;
        Display display = this.getDisplay();
        display.lastKey = 0;
        display.lastAscii = key;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.setKeyState(event, 31)) {
            return false;
        }
        return this.traverse(event);
    }

    boolean translateMnemonic(MSG msg) {
        Decorations shell;
        int hwnd = msg.hwnd;
        if (OS.GetKeyState(18) >= 0) {
            int code = OS.SendMessage(hwnd, 135, 0, 0);
            if ((code & 4) != 0) {
                return false;
            }
            if ((code & 0x2000) == 0) {
                return false;
            }
        }
        if ((shell = this.menuShell()).isVisible() && shell.isEnabled()) {
            char ch = this.mbcsToWcs((char)msg.wParam);
            return ch != '\u0000' && shell.translateMnemonic(ch);
        }
        return false;
    }

    boolean translateTraversal(MSG msg) {
        int key = msg.wParam;
        if (key == 18) {
            Shell shell = this.getShell();
            int hwndShell = shell.handle;
            OS.SendMessage(hwndShell, 295, 3, 0);
            return false;
        }
        int hwnd = msg.hwnd;
        int detail = 0;
        boolean doit = true;
        boolean all = false;
        boolean lastVirtual = false;
        int lastKey = key;
        int lastAscii = 0;
        switch (key) {
            case 27: {
                all = true;
                lastAscii = 27;
                int code = OS.SendMessage(hwnd, 135, 0, 0);
                if ((code & 4) != 0 && (code & 8) == 0) {
                    doit = false;
                }
                detail = 2;
                break;
            }
            case 13: {
                all = true;
                lastAscii = 13;
                int code = OS.SendMessage(hwnd, 135, 0, 0);
                if ((code & 4) != 0) {
                    doit = false;
                }
                detail = 4;
                break;
            }
            case 9: {
                lastAscii = 9;
                boolean next = OS.GetKeyState(16) >= 0;
                int code = OS.SendMessage(hwnd, 135, 0, 0);
                if ((code & 6) != 0 && next && OS.GetKeyState(17) >= 0) {
                    doit = false;
                }
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (key == 37 || key == 39)) {
                    next = !next;
                }
                detail = next ? 16 : 8;
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (OS.IsSP && (key == 37 || key == 39)) {
                    return false;
                }
                lastVirtual = true;
                int code = OS.SendMessage(hwnd, 135, 0, 0);
                if ((code & 1) != 0) {
                    doit = false;
                }
                boolean next = key == 40 || key == 39;
                detail = next ? 64 : 32;
                break;
            }
            case 33: 
            case 34: {
                all = true;
                lastVirtual = true;
                if (OS.GetKeyState(17) >= 0) {
                    return false;
                }
                detail = key == 33 ? 256 : 512;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = doit;
        event.detail = detail;
        Display display = this.getDisplay();
        display.lastKey = lastKey;
        display.lastAscii = lastAscii;
        display.lastVirtual = lastVirtual;
        display.lastNull = false;
        if (!this.setKeyState(event, 31)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                int hwndShell = shell.handle;
                OS.SendMessage(hwndShell, 295, 3, 0);
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return false;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        if (!this.isFocusControl() && !this.setFocus()) {
            return false;
        }
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus() || this.isDisposed() || this.isFocusControl()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseMnemonic(char key) {
        return this.mnemonicHit(key);
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    void unsubclass() {
        int oldProc = this.getDisplay().windowProc;
        int newProc = this.windowProc();
        if (oldProc == newProc) {
            return;
        }
        OS.SetWindowLong(this.handle, -4, newProc);
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        if (OS.IsWinCE) {
            OS.UpdateWindow(this.handle);
        } else {
            int flags = 256;
            if (all) {
                flags |= 0x80;
            }
            OS.RedrawWindow(this.handle, null, 0, flags);
        }
    }

    void updateFont(Font oldFont, Font newFont) {
        Font font = this.getFont();
        if (font.equals(oldFont)) {
            this.setFont(newFont);
        }
    }

    int widgetExtStyle() {
        int bits = 0;
        if ((this.style & 0x800) != 0) {
            bits |= 0x200;
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return bits;
        }
        bits |= 0x100000;
        if ((this.style & 0x4000000) != 0) {
            bits |= 0x400000;
        }
        return bits;
    }

    int widgetStyle() {
        return 0x54000000;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        if (OS.SetParent(this.handle, parent.handle) == 0) {
            return false;
        }
        this.parent = parent;
        return true;
    }

    abstract TCHAR windowClass();

    abstract int windowProc();

    int windowProc(int msg, int wParam, int lParam) {
        LRESULT result = null;
        switch (msg) {
            case 6: {
                result = this.WM_ACTIVATE(wParam, lParam);
                break;
            }
            case 258: {
                result = this.WM_CHAR(wParam, lParam);
                break;
            }
            case 771: {
                result = this.WM_CLEAR(wParam, lParam);
                break;
            }
            case 16: {
                result = this.WM_CLOSE(wParam, lParam);
                break;
            }
            case 273: {
                result = this.WM_COMMAND(wParam, lParam);
                break;
            }
            case 123: {
                result = this.WM_CONTEXTMENU(wParam, lParam);
                break;
            }
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: {
                result = this.WM_CTLCOLOR(wParam, lParam);
                break;
            }
            case 768: {
                result = this.WM_CUT(wParam, lParam);
                break;
            }
            case 2: {
                result = this.WM_DESTROY(wParam, lParam);
                break;
            }
            case 43: {
                result = this.WM_DRAWITEM(wParam, lParam);
                break;
            }
            case 22: {
                result = this.WM_ENDSESSION(wParam, lParam);
                break;
            }
            case 20: {
                result = this.WM_ERASEBKGND(wParam, lParam);
                break;
            }
            case 135: {
                result = this.WM_GETDLGCODE(wParam, lParam);
                break;
            }
            case 83: {
                result = this.WM_HELP(wParam, lParam);
                break;
            }
            case 276: {
                result = this.WM_HSCROLL(wParam, lParam);
                break;
            }
            case 646: {
                result = this.WM_IME_CHAR(wParam, lParam);
                break;
            }
            case 271: {
                result = this.WM_IME_COMPOSITION(wParam, lParam);
                break;
            }
            case 279: {
                result = this.WM_INITMENUPOPUP(wParam, lParam);
                break;
            }
            case 49: {
                result = this.WM_GETFONT(wParam, lParam);
                break;
            }
            case 61: {
                result = this.WM_GETOBJECT(wParam, lParam);
                break;
            }
            case 786: {
                result = this.WM_HOTKEY(wParam, lParam);
                break;
            }
            case 256: {
                result = this.WM_KEYDOWN(wParam, lParam);
                break;
            }
            case 257: {
                result = this.WM_KEYUP(wParam, lParam);
                break;
            }
            case 8: {
                result = this.WM_KILLFOCUS(wParam, lParam);
                break;
            }
            case 515: {
                result = this.WM_LBUTTONDBLCLK(wParam, lParam);
                break;
            }
            case 513: {
                result = this.WM_LBUTTONDOWN(wParam, lParam);
                break;
            }
            case 514: {
                result = this.WM_LBUTTONUP(wParam, lParam);
                break;
            }
            case 521: {
                result = this.WM_MBUTTONDBLCLK(wParam, lParam);
                break;
            }
            case 519: {
                result = this.WM_MBUTTONDOWN(wParam, lParam);
                break;
            }
            case 520: {
                result = this.WM_MBUTTONUP(wParam, lParam);
                break;
            }
            case 44: {
                result = this.WM_MEASUREITEM(wParam, lParam);
                break;
            }
            case 288: {
                result = this.WM_MENUCHAR(wParam, lParam);
                break;
            }
            case 287: {
                result = this.WM_MENUSELECT(wParam, lParam);
                break;
            }
            case 33: {
                result = this.WM_MOUSEACTIVATE(wParam, lParam);
                break;
            }
            case 673: {
                result = this.WM_MOUSEHOVER(wParam, lParam);
                break;
            }
            case 675: {
                result = this.WM_MOUSELEAVE(wParam, lParam);
                break;
            }
            case 512: {
                result = this.WM_MOUSEMOVE(wParam, lParam);
                break;
            }
            case 522: {
                result = this.WM_MOUSEWHEEL(wParam, lParam);
                break;
            }
            case 3: {
                result = this.WM_MOVE(wParam, lParam);
                break;
            }
            case 134: {
                result = this.WM_NCACTIVATE(wParam, lParam);
                break;
            }
            case 131: {
                result = this.WM_NCCALCSIZE(wParam, lParam);
                break;
            }
            case 132: {
                result = this.WM_NCHITTEST(wParam, lParam);
                break;
            }
            case 78: {
                result = this.WM_NOTIFY(wParam, lParam);
                break;
            }
            case 15: {
                result = this.WM_PAINT(wParam, lParam);
                break;
            }
            case 785: {
                result = this.WM_PALETTECHANGED(wParam, lParam);
                break;
            }
            case 528: {
                result = this.WM_PARENTNOTIFY(wParam, lParam);
                break;
            }
            case 770: {
                result = this.WM_PASTE(wParam, lParam);
                break;
            }
            case 792: {
                result = this.WM_PRINTCLIENT(wParam, lParam);
                break;
            }
            case 17: {
                result = this.WM_QUERYENDSESSION(wParam, lParam);
                break;
            }
            case 783: {
                result = this.WM_QUERYNEWPALETTE(wParam, lParam);
                break;
            }
            case 19: {
                result = this.WM_QUERYOPEN(wParam, lParam);
                break;
            }
            case 518: {
                result = this.WM_RBUTTONDBLCLK(wParam, lParam);
                break;
            }
            case 516: {
                result = this.WM_RBUTTONDOWN(wParam, lParam);
                break;
            }
            case 517: {
                result = this.WM_RBUTTONUP(wParam, lParam);
                break;
            }
            case 32: {
                result = this.WM_SETCURSOR(wParam, lParam);
                break;
            }
            case 7: {
                result = this.WM_SETFOCUS(wParam, lParam);
                break;
            }
            case 48: {
                result = this.WM_SETFONT(wParam, lParam);
                break;
            }
            case 26: {
                result = this.WM_SETTINGCHANGE(wParam, lParam);
                break;
            }
            case 11: {
                result = this.WM_SETREDRAW(wParam, lParam);
                break;
            }
            case 24: {
                result = this.WM_SHOWWINDOW(wParam, lParam);
                break;
            }
            case 5: {
                result = this.WM_SIZE(wParam, lParam);
                break;
            }
            case 262: {
                result = this.WM_SYSCHAR(wParam, lParam);
                break;
            }
            case 21: {
                result = this.WM_SYSCOLORCHANGE(wParam, lParam);
                break;
            }
            case 274: {
                result = this.WM_SYSCOMMAND(wParam, lParam);
                break;
            }
            case 260: {
                result = this.WM_SYSKEYDOWN(wParam, lParam);
                break;
            }
            case 261: {
                result = this.WM_SYSKEYUP(wParam, lParam);
                break;
            }
            case 275: {
                result = this.WM_TIMER(wParam, lParam);
                break;
            }
            case 772: {
                result = this.WM_UNDO(wParam, lParam);
                break;
            }
            case 277: {
                result = this.WM_VSCROLL(wParam, lParam);
                break;
            }
            case 71: {
                result = this.WM_WINDOWPOSCHANGED(wParam, lParam);
                break;
            }
            case 70: {
                result = this.WM_WINDOWPOSCHANGING(wParam, lParam);
            }
        }
        if (result != null) {
            return result.value;
        }
        return this.callWindowProc(msg, wParam, lParam);
    }

    LRESULT WM_ACTIVATE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_CHAR(int wParam, int lParam) {
        byte lead;
        Display display = this.getDisplay();
        if (!OS.IsUnicode && OS.IsDBLocale && OS.IsDBCSLeadByte(lead = (byte)(wParam & 0xFF))) {
            return null;
        }
        display.lastAscii = wParam;
        display.lastNull = false;
        if (display.lastKey == 0) {
            display.lastKey = wParam;
            display.lastVirtual = display.isVirtualKey(wParam);
        } else {
            short result;
            short s = result = OS.IsWinCE ? (short)0 : OS.VkKeyScan((short)wParam);
            if (!(OS.IsWinCE || result != -1 && result >> 8 > 2)) {
                if (OS.GetKeyState(17) < 0) {
                    display.lastVirtual = display.isVirtualKey(display.lastKey);
                }
            } else {
                display.lastKey = wParam;
                display.lastVirtual = false;
            }
        }
        if (!this.sendKeyEvent(1, 258, wParam, lParam)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT WM_CLEAR(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_CLOSE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_COMMAND(int wParam, int lParam) {
        if (lParam == 0) {
            int id;
            MenuItem item;
            Decorations shell = this.menuShell();
            if (shell.isEnabled() && (item = shell.findMenuItem(id = wParam & 0xFFFF)) != null && item.isEnabled()) {
                return item.wmCommandChild(wParam, lParam);
            }
            return null;
        }
        Control control = WidgetTable.get(lParam);
        if (control == null) {
            return null;
        }
        return control.wmCommandChild(wParam, lParam);
    }

    LRESULT WM_CONTEXTMENU(int wParam, int lParam) {
        if (wParam != this.handle) {
            return null;
        }
        POINT pt = new POINT();
        pt.x = (short)(lParam & 0xFFFF);
        pt.y = (short)(lParam >> 16);
        if (pt.x != -1 || pt.y != -1) {
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            OS.ScreenToClient(this.handle, pt);
            if (!OS.PtInRect(rect, pt)) {
                return null;
            }
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.setVisible(true);
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT WM_CTLCOLOR(int wParam, int lParam) {
        Control control;
        Display display = this.getDisplay();
        int hPalette = display.hPalette;
        if (hPalette != 0) {
            OS.SelectPalette(wParam, hPalette, false);
            OS.RealizePalette(wParam);
        }
        if ((control = WidgetTable.get(lParam)) == null) {
            return null;
        }
        return control.wmColorChild(wParam, lParam);
    }

    LRESULT WM_CUT(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_DESTROY(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_DRAWITEM(int wParam, int lParam) {
        DRAWITEMSTRUCT struct = new DRAWITEMSTRUCT();
        OS.MoveMemory(struct, lParam, 48);
        if (struct.CtlType == 1) {
            Decorations shell = this.menuShell();
            MenuItem item = shell.findMenuItem(struct.itemID);
            if (item == null) {
                return null;
            }
            return item.wmDrawChild(wParam, lParam);
        }
        Control control = WidgetTable.get(struct.hwndItem);
        if (control == null) {
            return null;
        }
        return control.wmDrawChild(wParam, lParam);
    }

    LRESULT WM_ENDSESSION(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_ERASEBKGND(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_GETDLGCODE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_GETFONT(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_GETOBJECT(int wParam, int lParam) {
        int result;
        if (this.accessible != null && (result = this.accessible.internal_WM_GETOBJECT(wParam, lParam)) != 0) {
            return new LRESULT(result);
        }
        return null;
    }

    LRESULT WM_HOTKEY(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_HELP(int wParam, int lParam) {
        if (OS.IsWinCE) {
            return null;
        }
        HELPINFO lphi = new HELPINFO();
        OS.MoveMemory(lphi, lParam, 28);
        Decorations shell = this.menuShell();
        if (!shell.isEnabled()) {
            return null;
        }
        if (lphi.iContextType == 2) {
            MenuItem item = shell.findMenuItem(lphi.iCtrlId);
            if (item != null && item.isEnabled()) {
                Widget widget = null;
                if (item.hooks(28)) {
                    widget = item;
                } else {
                    Menu menu = item.parent;
                    if (menu.hooks(28)) {
                        widget = menu;
                    }
                }
                if (widget != null) {
                    int hwndShell = shell.handle;
                    OS.SendMessage(hwndShell, 31, 0, 0);
                    widget.postEvent(28);
                    return LRESULT.ONE;
                }
            }
            return null;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_HSCROLL(int wParam, int lParam) {
        if (lParam == 0) {
            return null;
        }
        Control control = WidgetTable.get(lParam);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(wParam, lParam);
    }

    LRESULT WM_IME_CHAR(int wParam, int lParam) {
        Display display = this.getDisplay();
        display.lastKey = 0;
        display.lastAscii = wParam;
        display.lastNull = false;
        display.lastVirtual = false;
        this.sendKeyEvent(1, 646, wParam, lParam);
        this.sendKeyEvent(2, 646, wParam, lParam);
        display.lastAscii = 0;
        display.lastKey = 0;
        return LRESULT.ZERO;
    }

    LRESULT WM_IME_COMPOSITION(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_INITMENUPOPUP(int wParam, int lParam) {
        Display display = this.getDisplay();
        if (display.accelKeyHit) {
            return null;
        }
        Shell shell = this.getShell();
        Menu oldMenu = shell.activeMenu;
        Menu newMenu = null;
        if (lParam >> 16 == 0) {
            newMenu = this.menuShell().findMenu(wParam);
        }
        Menu menu = newMenu;
        while (menu != null && menu != oldMenu) {
            menu = menu.getParentMenu();
        }
        if (menu == null) {
            menu = shell.activeMenu;
            while (menu != null) {
                menu.sendEvent(23);
                if (menu.isDisposed()) break;
                menu = menu.getParentMenu();
                Menu ancestor = newMenu;
                while (ancestor != null && ancestor != menu) {
                    ancestor = ancestor.getParentMenu();
                }
                if (ancestor != null) break;
            }
        }
        if (newMenu != null && newMenu.isDisposed()) {
            newMenu = null;
        }
        shell.activeMenu = newMenu;
        if (newMenu != null && newMenu != oldMenu) {
            display.runDeferredEvents();
            newMenu.sendEvent(22);
        }
        return null;
    }

    LRESULT WM_KEYDOWN(int wParam, int lParam) {
        int mapKey;
        byte lead;
        switch (wParam) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((lParam & 0x40000000) == 0) break;
                return null;
            }
        }
        Display display = this.getDisplay();
        display.lastKey = 0;
        display.lastAscii = 0;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!OS.IsUnicode && OS.IsDBLocale && OS.IsDBCSLeadByte(lead = (byte)(wParam & 0xFF))) {
            return null;
        }
        int n = mapKey = OS.IsWinCE ? 0 : OS.MapVirtualKey(wParam, 2);
        if (OS.IsWinNT ? (mapKey & Integer.MIN_VALUE) != 0 : (mapKey & 0x8000) != 0) {
            return null;
        }
        if (!OS.IsWinCE) {
            int i = 0;
            while (i < ACCENTS.length) {
                short value = OS.VkKeyScan(ACCENTS[i]);
                if ((value & 0xFF) == wParam && (value & 0x600) == 1536) {
                    return null;
                }
                ++i;
            }
        }
        display.lastKey = wParam;
        boolean bl = display.lastVirtual = mapKey == 0;
        if (display.lastVirtual) {
            if (display.lastKey == 46) {
                display.lastAscii = 127;
            }
            if (96 <= display.lastKey && display.lastKey <= 111) {
                if (display.asciiKey(display.lastKey) != 0) {
                    return null;
                }
                display.lastAscii = display.numpadKey(display.lastKey);
            }
        } else {
            int asciiKey;
            if (OS.GetKeyState(16) < 0) {
                display.lastKey = display.shiftedKey(display.lastKey);
                if (display.lastKey == 0) {
                    display.lastKey = wParam;
                }
            } else {
                display.lastKey = OS.CharLower((short)mapKey);
            }
            if ((asciiKey = display.asciiKey(wParam)) != 0) {
                if (asciiKey == 32) {
                    display.lastVirtual = true;
                    return null;
                }
                if (asciiKey != wParam) {
                    return null;
                }
            }
            if (OS.GetKeyState(17) >= 0) {
                display.lastKey = 0;
                return null;
            }
            display.lastVirtual = display.isVirtualKey(wParam);
            display.lastAscii = display.controlKey(display.lastKey);
            boolean bl2 = display.lastNull = display.lastAscii == 0 && display.lastKey == 64;
        }
        if (!this.sendKeyEvent(1, 256, wParam, lParam)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT WM_KEYUP(int wParam, int lParam) {
        int mapKey;
        Display display = this.getDisplay();
        if (OS.IsWinCE && 193 <= wParam && wParam <= 198) {
            int type;
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastNull = false;
            display.lastVirtual = false;
            Event event = new Event();
            event.detail = wParam - 193 + 1;
            int n = type = (lParam & 0x40000000) != 0 ? 34 : 33;
            if (this.setInputState(event, type)) {
                this.sendEvent(type, event);
            }
            return null;
        }
        if (!this.hooks(2) && !display.filters(2)) {
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastNull = false;
            display.lastVirtual = false;
            return null;
        }
        int n = mapKey = OS.IsWinCE ? 0 : OS.MapVirtualKey(wParam, 2);
        if (OS.IsWinNT ? (mapKey & Integer.MIN_VALUE) != 0 : (mapKey & 0x8000) != 0) {
            return null;
        }
        if (!OS.IsWinCE) {
            int i = 0;
            while (i < ACCENTS.length) {
                short value = OS.VkKeyScan(ACCENTS[i]);
                if ((value & 0xFF) == wParam && (value & 0x600) == 1536) {
                    display.lastAscii = 0;
                    display.lastKey = 0;
                    display.lastNull = false;
                    display.lastVirtual = false;
                    return null;
                }
                ++i;
            }
        }
        boolean bl = display.lastVirtual = mapKey == 0;
        if (display.lastVirtual) {
            display.lastKey = wParam;
        } else {
            if (display.lastKey == 0) {
                display.lastAscii = 0;
                display.lastNull = false;
                return null;
            }
            display.lastVirtual = display.isVirtualKey(display.lastKey);
        }
        LRESULT result = null;
        if (!this.sendKeyEvent(2, 257, wParam, lParam)) {
            result = LRESULT.ZERO;
        }
        display.lastAscii = 0;
        display.lastKey = 0;
        display.lastNull = false;
        display.lastVirtual = false;
        return result;
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        Control control;
        int code = this.callWindowProc(8, wParam, lParam);
        Display display = this.getDisplay();
        Shell shell = this.getShell();
        this.sendEvent(16);
        if (!(shell.isDisposed() || (control = display.findControl(wParam)) != null && shell == control.getShell())) {
            shell.setActiveControl(null);
        }
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (code == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(code);
    }

    LRESULT WM_LBUTTONDBLCLK(int wParam, int lParam) {
        this.sendMouseEvent(3, 1, 513, wParam, lParam);
        this.sendMouseEvent(8, 1, 515, wParam, lParam);
        int result = this.callWindowProc(515, wParam, lParam);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return new LRESULT(result);
    }

    LRESULT WM_LBUTTONDOWN(int wParam, int lParam) {
        boolean dragging = false;
        boolean mouseDown = true;
        boolean dragDetect = this.hooks(29);
        if (dragDetect && !OS.IsWinCE) {
            POINT pt = new POINT();
            pt.x = (short)(lParam & 0xFFFF);
            pt.y = (short)(lParam >> 16);
            OS.ClientToScreen(this.handle, pt);
            dragging = OS.DragDetect(this.handle, pt);
            mouseDown = OS.GetKeyState(1) < 0;
        }
        this.sendMouseEvent(3, 1, 513, wParam, lParam);
        int result = this.callWindowProc(513, wParam, lParam);
        if (OS.IsPPC && this.menu != null && !this.menu.isDisposed()) {
            short x = (short)(lParam & 0xFFFF);
            short y = (short)(lParam >> 16);
            SHRGINFO shrg = new SHRGINFO();
            shrg.cbSize = 20;
            shrg.hwndClient = this.handle;
            shrg.ptDown_x = x;
            shrg.ptDown_y = y;
            shrg.dwFlags = 1;
            int type = OS.SHRecognizeGesture(shrg);
            if (type == 1000) {
                this.menu.setVisible(true);
            }
        }
        if (mouseDown && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if (dragging) {
            this.postEvent(29);
        } else if (dragDetect && OS.GetKeyState(27) >= 0) {
            OS.SendMessage(this.handle, 514, wParam, lParam);
        }
        return new LRESULT(result);
    }

    LRESULT WM_LBUTTONUP(int wParam, int lParam) {
        this.sendMouseEvent(4, 1, 514, wParam, lParam);
        int result = this.callWindowProc(514, wParam, lParam);
        if ((wParam & 0x13) == 0 && OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
        return new LRESULT(result);
    }

    LRESULT WM_MBUTTONDBLCLK(int wParam, int lParam) {
        this.sendMouseEvent(3, 2, 519, wParam, lParam);
        this.sendMouseEvent(8, 2, 521, wParam, lParam);
        int result = this.callWindowProc(521, wParam, lParam);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return new LRESULT(result);
    }

    LRESULT WM_MBUTTONDOWN(int wParam, int lParam) {
        this.sendMouseEvent(3, 2, 519, wParam, lParam);
        int result = this.callWindowProc(519, wParam, lParam);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return new LRESULT(result);
    }

    LRESULT WM_MBUTTONUP(int wParam, int lParam) {
        this.sendMouseEvent(4, 2, 520, wParam, lParam);
        int result = this.callWindowProc(520, wParam, lParam);
        if ((wParam & 0x13) == 0 && OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
        return new LRESULT(result);
    }

    LRESULT WM_MEASUREITEM(int wParam, int lParam) {
        MEASUREITEMSTRUCT struct = new MEASUREITEMSTRUCT();
        OS.MoveMemory(struct, lParam, 24);
        if (struct.CtlType == 1) {
            Decorations shell = this.menuShell();
            MenuItem item = shell.findMenuItem(struct.itemID);
            if (item == null) {
                return null;
            }
            return item.wmMeasureChild(wParam, lParam);
        }
        int hwnd = OS.GetDlgItem(this.handle, struct.CtlID);
        Control control = WidgetTable.get(hwnd);
        if (control == null) {
            return null;
        }
        return control.wmMeasureChild(wParam, lParam);
    }

    LRESULT WM_MENUCHAR(int wParam, int lParam) {
        int type = wParam >> 16;
        if (type == 0 || type == 8192) {
            Display display = this.getDisplay();
            display.mnemonicKeyHit = false;
            return new LRESULT(65536);
        }
        return null;
    }

    LRESULT WM_MENUSELECT(int wParam, int lParam) {
        int code = wParam >> 16;
        Shell shell = this.getShell();
        if (code == -1 && lParam == 0) {
            this.getDisplay();
            Menu menu = shell.activeMenu;
            while (menu != null) {
                menu.sendEvent(23);
                if (menu.isDisposed()) break;
                menu = menu.getParentMenu();
            }
            shell.activeMenu = null;
            return null;
        }
        if ((code & 0x2000) != 0) {
            return null;
        }
        if ((code & 0x80) != 0) {
            MenuItem item = null;
            Decorations menuShell = this.menuShell();
            if ((code & 0x10) != 0) {
                Menu newMenu;
                int index = wParam & 0xFFFF;
                MENUITEMINFO info = new MENUITEMINFO();
                info.cbSize = MENUITEMINFO.sizeof;
                info.fMask = 4;
                if (OS.GetMenuItemInfo(lParam, index, true, info) && (newMenu = menuShell.findMenu(info.hSubMenu)) != null) {
                    item = newMenu.cascade;
                }
            } else {
                Menu oldMenu;
                Menu newMenu = menuShell.findMenu(lParam);
                if (newMenu != null) {
                    int id = wParam & 0xFFFF;
                    item = menuShell.findMenuItem(id);
                }
                if ((oldMenu = shell.activeMenu) != null) {
                    Menu ancestor = oldMenu;
                    while (ancestor != null && ancestor != newMenu) {
                        ancestor = ancestor.getParentMenu();
                    }
                    if (ancestor == newMenu) {
                        ancestor = oldMenu;
                        while (ancestor != newMenu) {
                            ancestor.sendEvent(23);
                            if (ancestor.isDisposed()) break;
                            ancestor = ancestor.getParentMenu();
                        }
                        if (!shell.isDisposed()) {
                            if (newMenu != null && newMenu.isDisposed()) {
                                newMenu = null;
                            }
                            shell.activeMenu = newMenu;
                        }
                        if (item != null && item.isDisposed()) {
                            item = null;
                        }
                    }
                }
            }
            if (item != null) {
                item.sendEvent(30);
            }
        }
        return null;
    }

    LRESULT WM_MOUSEACTIVATE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_MOUSEHOVER(int wParam, int lParam) {
        this.sendMouseEvent(32, 0, 673, wParam, lParam);
        return null;
    }

    LRESULT WM_MOUSELEAVE(int wParam, int lParam) {
        int pos = OS.GetMessagePos();
        POINT pt = new POINT();
        pt.x = (short)(pos & 0xFFFF);
        pt.y = (short)(pos >> 16);
        OS.ScreenToClient(this.handle, pt);
        lParam = pt.x | pt.y << 16;
        this.sendMouseEvent(7, 0, 675, wParam, lParam);
        return null;
    }

    LRESULT WM_MOUSEMOVE(int wParam, int lParam) {
        Display display;
        if (!OS.IsWinCE) {
            boolean mouseHover;
            display = this.getDisplay();
            boolean mouseEnter = this.hooks(6) || display.filters(6);
            boolean mouseExit = this.hooks(7) || display.filters(7);
            boolean bl = mouseHover = this.hooks(32) || display.filters(32);
            if (mouseEnter || mouseExit || mouseHover) {
                TRACKMOUSEEVENT lpEventTrack = new TRACKMOUSEEVENT();
                lpEventTrack.cbSize = 16;
                lpEventTrack.dwFlags = 0x40000000;
                lpEventTrack.hwndTrack = this.handle;
                OS.TrackMouseEvent(lpEventTrack);
                if (lpEventTrack.dwFlags == 0) {
                    lpEventTrack.dwFlags = 3;
                    lpEventTrack.hwndTrack = this.handle;
                    OS.TrackMouseEvent(lpEventTrack);
                    if (mouseEnter) {
                        this.sendMouseEvent(6, 0, 512, wParam, lParam);
                    }
                } else {
                    lpEventTrack.dwFlags = 1;
                    OS.TrackMouseEvent(lpEventTrack);
                }
            }
        }
        display = this.getDisplay();
        int pos = OS.GetMessagePos();
        if (pos != display.lastMouse) {
            display.lastMouse = pos;
            this.sendMouseEvent(5, 0, 512, wParam, lParam);
        }
        return null;
    }

    LRESULT WM_MOUSEWHEEL(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_MOVE(int wParam, int lParam) {
        this.sendEvent(10);
        return null;
    }

    LRESULT WM_NCACTIVATE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_NCCALCSIZE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_NCHITTEST(int wParam, int lParam) {
        if (!OS.IsWindowEnabled(this.handle)) {
            return null;
        }
        if (!this.isActive()) {
            return new LRESULT(-1);
        }
        return null;
    }

    LRESULT WM_NOTIFY(int wParam, int lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        int hwnd = hdr.hwndFrom;
        if (hwnd == 0) {
            return null;
        }
        Control control = WidgetTable.get(hwnd);
        if (control == null) {
            return null;
        }
        return control.wmNotifyChild(wParam, lParam);
    }

    LRESULT WM_PAINT(int wParam, int lParam) {
        if (!this.hooks(9) && !this.filters(9)) {
            return null;
        }
        int result = 0;
        if (OS.IsWinCE) {
            RECT rect = new RECT();
            OS.GetUpdateRect(this.handle, rect, false);
            result = this.callWindowProc(15, wParam, lParam);
            OS.InvalidateRect(this.handle, rect, false);
        } else {
            int rgn = OS.CreateRectRgn(0, 0, 0, 0);
            OS.GetUpdateRgn(this.handle, rgn, false);
            result = this.callWindowProc(15, wParam, lParam);
            OS.InvalidateRgn(this.handle, rgn, false);
            OS.DeleteObject(rgn);
        }
        PAINTSTRUCT ps = new PAINTSTRUCT();
        GCData data = new GCData();
        data.ps = ps;
        GC gc = GC.win32_new(this, data);
        Event event = new Event();
        event.gc = gc;
        event.x = ps.left;
        event.y = ps.top;
        event.width = ps.right - ps.left;
        event.height = ps.bottom - ps.top;
        this.sendEvent(9, event);
        event.gc = null;
        gc.dispose();
        if (result == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(result);
    }

    LRESULT WM_PALETTECHANGED(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_PARENTNOTIFY(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_PASTE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_PRINTCLIENT(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_QUERYENDSESSION(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_QUERYNEWPALETTE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_QUERYOPEN(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_RBUTTONDBLCLK(int wParam, int lParam) {
        this.sendMouseEvent(3, 3, 516, wParam, lParam);
        this.sendMouseEvent(8, 3, 518, wParam, lParam);
        int result = this.callWindowProc(518, wParam, lParam);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return new LRESULT(result);
    }

    LRESULT WM_RBUTTONDOWN(int wParam, int lParam) {
        this.sendMouseEvent(3, 3, 516, wParam, lParam);
        int result = this.callWindowProc(516, wParam, lParam);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return new LRESULT(result);
    }

    LRESULT WM_RBUTTONUP(int wParam, int lParam) {
        this.sendMouseEvent(4, 3, 517, wParam, lParam);
        int result = this.callWindowProc(517, wParam, lParam);
        if ((wParam & 0x13) == 0 && OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
        return new LRESULT(result);
    }

    LRESULT WM_SETCURSOR(int wParam, int lParam) {
        int hitTest = lParam & 0xFFFF;
        if (hitTest == 1) {
            Control control = WidgetTable.get(wParam);
            if (control == null) {
                return null;
            }
            int hCursor = control.findCursor();
            if (hCursor != 0) {
                OS.SetCursor(hCursor);
                return LRESULT.ONE;
            }
        }
        return null;
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        int code = this.callWindowProc(7, wParam, lParam);
        Shell shell = this.getShell();
        this.sendEvent(15);
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (code == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(code);
    }

    LRESULT WM_SETTINGCHANGE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_SETFONT(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_SETREDRAW(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_SHOWWINDOW(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        this.sendEvent(11);
        return null;
    }

    LRESULT WM_SYSCHAR(int wParam, int lParam) {
        Display display = this.getDisplay();
        display.lastAscii = display.lastKey = wParam;
        display.lastVirtual = display.isVirtualKey(wParam);
        display.lastNull = false;
        if (!this.hooks(1) && !display.filters(1)) {
            return null;
        }
        display.mnemonicKeyHit = true;
        int result = this.callWindowProc(262, wParam, lParam);
        if (!display.mnemonicKeyHit) {
            this.sendKeyEvent(1, 262, wParam, lParam);
        }
        display.mnemonicKeyHit = false;
        return new LRESULT(result);
    }

    LRESULT WM_SYSCOLORCHANGE(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_SYSCOMMAND(int wParam, int lParam) {
        if ((wParam & 0xF000) == 0) {
            MenuItem item;
            Decorations shell = this.menuShell();
            if (shell.isEnabled() && (item = shell.findMenuItem(wParam & 0xFFFF)) != null) {
                item.wmCommandChild(wParam, lParam);
            }
            return LRESULT.ZERO;
        }
        int cmd = wParam & 0xFFF0;
        switch (cmd) {
            case 61536: {
                int hwndShell = this.menuShell().handle;
                int bits = OS.GetWindowLong(hwndShell, -16);
                if ((bits & 0x80000) != 0) break;
                return LRESULT.ZERO;
            }
            case 61696: {
                char key;
                Decorations shell;
                Menu menu;
                if ((this.hooks(1) || this.hooks(2)) && (menu = (shell = this.menuShell()).getMenuBar()) != null && (key = this.mbcsToWcs(lParam)) != '\u0000') {
                    key = Character.toUpperCase(key);
                    MenuItem[] items = menu.getItems();
                    int i = 0;
                    while (i < items.length) {
                        char ch;
                        MenuItem item = items[i];
                        String text = item.getText();
                        char mnemonic = this.findMnemonic(text);
                        if (text.length() > 0 && mnemonic == '\u0000' && Character.toUpperCase(ch = text.charAt(0)) == key) {
                            Display display = this.getDisplay();
                            display.mnemonicKeyHit = false;
                            return LRESULT.ZERO;
                        }
                        ++i;
                    }
                }
            }
            case 61552: 
            case 61568: {
                Decorations shell = this.menuShell();
                if (shell.isEnabled() && shell.isActive()) break;
                return LRESULT.ZERO;
            }
            case 61472: {
                this.menuShell().saveFocus();
            }
        }
        return null;
    }

    LRESULT WM_SYSKEYDOWN(int wParam, int lParam) {
        if (wParam != 121 && (lParam & 0x20000000) == 0) {
            return null;
        }
        switch (wParam) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((lParam & 0x40000000) == 0) break;
                return null;
            }
        }
        Display display = this.getDisplay();
        display.lastKey = 0;
        display.lastAscii = 0;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!OS.IsWinCE && OS.MapVirtualKey(wParam, 2) != 0) {
            if (wParam != 13) {
                return null;
            }
            display.lastAscii = 13;
        }
        display.lastKey = wParam;
        display.lastVirtual = true;
        if (display.lastKey == 46) {
            display.lastAscii = 127;
        }
        if (96 <= display.lastKey && display.lastKey <= 111 && display.asciiKey(display.lastKey) != 0) {
            return null;
        }
        if (!this.sendKeyEvent(1, 260, wParam, lParam)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT WM_SYSKEYUP(int wParam, int lParam) {
        return this.WM_KEYUP(wParam, lParam);
    }

    LRESULT WM_TIMER(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_UNDO(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_VSCROLL(int wParam, int lParam) {
        if (lParam == 0) {
            return null;
        }
        Control control = WidgetTable.get(lParam);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(wParam, lParam);
    }

    LRESULT WM_WINDOWPOSCHANGED(int wParam, int lParam) {
        return null;
    }

    LRESULT WM_WINDOWPOSCHANGING(int wParam, int lParam) {
        return null;
    }

    LRESULT wmColorChild(int wParam, int lParam) {
        if (this.background == -1 && this.foreground == -1) {
            return null;
        }
        int forePixel = this.foreground;
        int backPixel = this.background;
        if (forePixel == -1) {
            forePixel = this.defaultForeground();
        }
        if (backPixel == -1) {
            backPixel = this.defaultBackground();
        }
        OS.SetTextColor(wParam, forePixel);
        OS.SetBkColor(wParam, backPixel);
        return new LRESULT(this.findBrush(backPixel));
    }

    LRESULT wmCommandChild(int wParam, int lParam) {
        return null;
    }

    LRESULT wmDrawChild(int wParam, int lParam) {
        return null;
    }

    LRESULT wmMeasureChild(int wParam, int lParam) {
        return null;
    }

    LRESULT wmNotifyChild(int wParam, int lParam) {
        return null;
    }

    LRESULT wmScrollChild(int wParam, int lParam) {
        return null;
    }
}

