/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.commons/src/jp/sourceforge/jeextension/common/xml/XMLNodeList.java,v 1.1 2004/12/17 02:25:24 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2004/12/17 02:25:24 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.common.xml;

import java.util.ArrayList;
import java.util.List;

/**
 * XMLNodeList is managing XMLNode as list object.
 */
public final class XMLNodeList extends ArrayList implements List {
    
    /**
     * default constructor. Initiate empty XMLNodeList object.
     */
    public XMLNodeList() {
        super();
    }
    
    /**
     * Initiate XMLNodeList object using java.util.List instance that contains
     * XMLNode objects.
     * @param nodeList  java.util.List instance that be contains XMLNode
     *                  object.
     */
    XMLNodeList(List nodeList) {
        super(nodeList);
    }
    
    /**
     * Returns XMLNode object that appointed index in the list.<br>
     * Returns null if object is not instance or empty.
     * @param i list's index.
     * @return XMLNode Object. or null.
     */
    public XMLNode getNode(int i) {
        Object element = super.get(i);
        if (element instanceof XMLNode) {
            return (XMLNode) element;
        }
        else {
            return null;
        }
    }
}
