<?php

class jp_ProtectByMD5_accept extends jeans {
	static public function check_ip($ip){
		static $accept;
		if (!isset($accept)) {
			$accept=array();
			
			//Local test
			$accept[]='127.0.0.0/24';
			
			//DoCoMo
			$accept[]='210.153.84.0/24';
			$accept[]='210.136.161.0/24';
			$accept[]='210.153.86.0/24';
			$accept[]='210.153.87.0/24';
			
			//Vodafone
			$accept[]='202.179.204.0/24';
			$accept[]='202.253.96.248/29';
			$accept[]='210.146.7.192/26';
			$accept[]='210.146.60.192/26';
			$accept[]='210.151.9.128/26';
			$accept[]='210.169.130.112/29';
			$accept[]='210.169.130.120/29';
			$accept[]='210.169.176.0/24';
			$accept[]='210.175.1.128/25';
			$accept[]='210.228.189.0/24';
			$accept[]='211.8.159.128/25';
			
			//EZweb (au/Tu-Ka)
			$accept[]='61.117.0.0/24';
			$accept[]='61.117.1.0/24';
			$accept[]='61.117.2.0/26';
			$accept[]='61.202.3.0/24';
			$accept[]='210.169.40.0/24';
			$accept[]='210.196.3.192/26';
			$accept[]='210.196.5.192/26';
			$accept[]='210.230.128.0/24';
			$accept[]='210.230.141.192/26';
			$accept[]='210.234.105.32/29';
			$accept[]='210.234.108.64/26';
			$accept[]='210.251.1.192/26';
			$accept[]='210.251.2.0/27';
			$accept[]='211.5.1.0/24';
			$accept[]='211.5.2.128/25';
			$accept[]='211.5.7.0/24';
			$accept[]='218.222.1.0/24';
			$accept[]='219.108.158.0/26';
			$accept[]='59.135.38.128/25';
			$accept[]='219.108.157.0/25';
			
			//WIN
			$accept[]='219.125.148.0/24';
			$accept[]='222.5.62.0/23';
			$accept[]='222.7.56.0/23';
			
			//BREW
			$accept[]='219.125.162.0/23';
			$accept[]='219.125.164.0/22';
			$accept[]='222.3.144.0/21';
			$accept[]='222.15.70.0/23';
			$accept[]='222.15.72.0/21';
			$accept[]='59.128.128.0/20';
			$accept[]='59.135.48.0/20';
			$accept[]='59.137.0.0/20';
			$accept[]='59.137.16.0/20';
			
			//Willcom
			$accept[]='61.198.138.100/30';
			$accept[]='61.198.139.128/27';
			$accept[]='61.198.139.160/28';
			$accept[]='61.198.139.0/29';
			$accept[]='61.198.142.0/24';
			$accept[]='61.198.160.0/20';
			$accept[]='61.198.248.0/21';
			$accept[]='61.204.0.0/21';
			$accept[]='61.198.129.0/24';
			$accept[]='61.198.140.0/24';
			$accept[]='61.198.141.0/24';
			$accept[]='125.28.0.0/20';
			$accept[]='125.28.16.0/23';
			$accept[]='210.168.246.0/23';
			$accept[]='211.18.232.0/21';
			$accept[]='219.108.0.0/20';
			$accept[]='221.119.0.0/21';
			$accept[]='221.119.8.0/23';
		}
		
		// Check IP here
		// Note that this function always return false when IPv6 is used.
		if (!preg_match('/^([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)$/',$ip,$ips)) return false;
		$maskedip=array();
		$maskedip[16]=$ips[1].'.'.$ips[2].'.0.0';
		$maskedip[17]=$ips[1].'.'.$ips[2].'.'.($ips[3] & 128).'.0';
		$maskedip[18]=$ips[1].'.'.$ips[2].'.'.($ips[3] & 192).'.0';
		$maskedip[19]=$ips[1].'.'.$ips[2].'.'.($ips[3] & 224).'.0';
		$maskedip[20]=$ips[1].'.'.$ips[2].'.'.($ips[3] & 240).'.0';
		$maskedip[21]=$ips[1].'.'.$ips[2].'.'.($ips[3] & 248).'.0';
		$maskedip[22]=$ips[1].'.'.$ips[2].'.'.($ips[3] & 252).'.0';
		$maskedip[23]=$ips[1].'.'.$ips[2].'.'.($ips[3] & 254).'.0';
		$maskedip[24]=$ips[1].'.'.$ips[2].'.'.$ips[3].'.0';
		$maskedip[25]=$ips[1].'.'.$ips[2].'.'.$ips[3].'.'.($ips[4] & 128);
		$maskedip[26]=$ips[1].'.'.$ips[2].'.'.$ips[3].'.'.($ips[4] & 192);
		$maskedip[27]=$ips[1].'.'.$ips[2].'.'.$ips[3].'.'.($ips[4] & 224);
		$maskedip[28]=$ips[1].'.'.$ips[2].'.'.$ips[3].'.'.($ips[4] & 240);
		$maskedip[29]=$ips[1].'.'.$ips[2].'.'.$ips[3].'.'.($ips[4] & 248);
		$maskedip[30]=$ips[1].'.'.$ips[2].'.'.$ips[3].'.'.($ips[4] & 252);
		$maskedip[31]=$ips[1].'.'.$ips[2].'.'.$ips[3].'.'.($ips[4] & 254);
		$maskedip[32]=$ips[0];
		foreach($accept as $value){
			if (!preg_match('!^([^/]+)/([0-9]+)$!',$value,$test)) error::quit('ERROR:'.__LINE__);
			if ( !($ip=$maskedip[(int)$test[2]]) ) error::quit('ERROR:'.__LINE__);
			if (trim($ip)!=trim($test[1])) continue;
			return true;
		}
		return false;
	}
}
